#include "stdafx.h"
#include "main.h"
#include "resource.h"

//-----------------------------------------------------------------------------
namespace
{
	//	EBhEQ
	std::set<HWND>	windows;

	//	sx[h
	inline INT32 LoadAlpha( HWND hwnd, INT32 default_value = 224 )
	{
		return	GetRegInt32( hwnd, L"Alpha", default_value );
	}

	//	sxZ[u
	inline void SaveAlpha( HWND hwnd, INT32 value )
	{
		SetRegInt32( hwnd, L"Alpha", value );
	}
}

//	EBhE𔼓
void	ResetWindowAlpha( HWND hwnd )
{
	if( hwnd = GetTopParent(hwnd) ){
		//	C[hEBhE֕ϊ
		LONG_PTR const ex( GetWindowLongPtr( hwnd, GWL_EXSTYLE ) );
		if( !(ex & WS_EX_LAYERED) )
			SetWindowLongPtr( hwnd, GWL_EXSTYLE, ex | WS_EX_LAYERED );

		//	sxݒ
		SetLayeredWindowAttributes( hwnd, RGB(255,255,255), LoadAlpha(hwnd), LWA_ALPHA );
		windows.insert( hwnd );
	}
}

//	sxݒ
void	SetWindowAlpha( INT32 alpha )
{
	for( auto it(windows.begin()), e(windows.end()) ; it != e ; ++it ){
		if( IsWindow(*it) )
			SetLayeredWindowAttributes( *it, RGB(255,255,255), alpha, LWA_ALPHA );
	}
}

//-----------------------------------------------------------------------------

//	j[c[o[vOCIƂɌĂяo
EXTERN_C void	WINAPI OnCommand( HWND hwnd )
{
	ResetWindowAlpha( hwnd );
	ShowProperty( hwnd );
}

//	ԂύXꂽƂɃCxgw肳ČĂяo
EXTERN_C void	WINAPI OnEvents( HWND hwnd, UINT nEvent, LPARAM lParam ) 
{
	//	NAvOCǉ
	if( nEvent & EVENT_CREATE ){
		ResetWindowAlpha(hwnd);
	}

	//	I钼OAvOCOAvOCACXg[悤Ƃ
	if( nEvent & EVENT_CLOSE  ){
		SetWindowAlpha(255);
		windows.clear();
	}
}

//-----------------------------------------------------------------------------
namespace {

	//	sxŕ\
	inline void ShowValue( HWND dlg, int alpha )
	{
		wchar_t	str[64];
		swprintf_s( str, L"%d%%", static_cast<int>(alpha * 100 / 256. + 0.5) );
		SetDlgItemTextW( dlg, IDC_VALUE, str );
	}

	//	vpeB_CAOvV[W
	INT_PTR CALLBACK PropertyProcedure( HWND dlg, UINT msg, WPARAM wParam, LPARAM lParam )
	{
		switch( msg ){
		//	
		case WM_INITDIALOG:{
				auto const alpha( LoadAlpha(GetTopParent(dlg)) );
				SendDlgItemMessage( dlg, IDC_ALPHA, TBM_SETRANGE, false, MAKELONG(12,255) );
				SendDlgItemMessage( dlg, IDC_ALPHA, TBM_SETPOS,	  true,  alpha );
				ShowValue( dlg, alpha );
				SetWindowLongPtr( dlg, DWLP_USER, 0xff );
				SetWindowText( dlg, GetStringFromTable(IDS_NAME).c_str() );
			}
			return	false;

		//	sxgbNo[XV
		case WM_HSCROLL:
			if( reinterpret_cast<HWND>(lParam) == GetDlgItem(dlg,IDC_ALPHA) ){
				if( GetWindowLongPtr( dlg, DWLP_USER ) == 0xff ){
					auto alpha( static_cast<INT32>(SendDlgItemMessage( dlg, IDC_ALPHA, TBM_GETPOS,0,0 )) );
					alpha = (std::min)( (std::max)( alpha, 1 ), 255 );
					SetWindowAlpha( alpha );
					ShowValue( dlg, alpha );
				}
			}
			break;
		case WM_COMMAND:
			switch( LOWORD(wParam) ){
			//	I
			case IDOK:{
					auto alpha( static_cast<INT32>(SendDlgItemMessage( dlg, IDC_ALPHA, TBM_GETPOS,0,0 )) );
					alpha = (std::min)( (std::max)( alpha, 1 ), 255 );
					SetWindowAlpha( alpha );
					SaveAlpha( GetTopParent(dlg), alpha );
					EndDialog(dlg, IDOK );
				}
				return	true;
			//	LZI
			case IDCANCEL:
				SetWindowAlpha( LoadAlpha(GetTopParent(dlg)) );
				EndDialog(dlg, IDCANCEL );
				return	true;
			}
			break;
		}
		return	false;
	}
}

//	vpeB\
bool	ShowProperty( HWND parent )
{
	return	DialogBox( GetInstanceHandle(), MAKEINTRESOURCE(IDD_PROPERTY), parent, PropertyProcedure ) != -1;
}
