// implementatin of this specific plug-in is here:
//

class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_256C_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_256C_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_256C_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_256C_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_256C_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_256C_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= RGB( 255, 0, 255 )	};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 5000					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 4000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= TRUE					};

	void OnCommand( HWND hwndView )
	{
		UINT_PTR nBufLen = Editor_GetSelTextW( hwndView, 0, NULL);
		LPWSTR pBuf = new WCHAR[nBufLen];
		if( !pBuf )  return;
		Editor_GetSelTextW( hwndView, nBufLen, pBuf );
		LPWSTR p = pBuf;
		BOOL bAlphaNum = FALSE;
		UINT nCount = 0;
		while( *p ){
			BOOL b = iswalnum( *p );
			if( b && !bAlphaNum )  nCount++;
			bAlphaNum = b;
			p++;
		}
		delete [] pBuf;

		TCHAR sz[256];
		TCHAR szFormat[128];
		LoadString( EEGetInstanceHandle(), IDS_WORDS_CONTAINED, szFormat, _countof( szFormat ) );
		StringPrintf( sz, _countof( sz ), szFormat, nCount );
		TCHAR szTitle[128];
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szTitle, _countof( szTitle ) );
		MessageBox( hwndView, sz, szTitle, MB_OK | MB_ICONINFORMATION );
	}

	BOOL QueryStatus( HWND hwndView, LPBOOL pbChecked )
	{		
		*pbChecked = FALSE;
		int nFlags = (Editor_GetSelType( hwndView ) & SEL_TYPE_MASK);
		return (nFlags == SEL_TYPE_CHAR) || (nFlags == SEL_TYPE_LINE);
	}

	void OnEvents( HWND hwndView, UINT nEvent )
	{
		if( nEvent & EVENT_SEL_CHANGED ){
			Editor_UpdateToolbar( hwndView, EEGetCmdID() );
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg )
	{
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			return TRUE;
		}
		return FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return FALSE;
	}

	BOOL SetProperties( HWND /*hDlg*/ )
	{
		return FALSE;
	}
};

// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT

