/*
 * Decompiled with CFR 0.152.
 */
package ro.catalin.prata.firuploader.controller;

import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import java.util.Calendar;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

@State(name="KeysManager", storages={@Storage(id="other", file="$APP_CONFIG$/fir_im_uploader_persist.xml")})
public class KeysManager
implements PersistentStateComponent<Element>,
CompilationStatusListener {
    public static final String XML_ROOT_NAME_Key_MANAGER = "KeyManager";
    public static final String XML_ROOT_NAME_TEAM_MANAGER = "TeamManager";
    public static final String XML_TEAM_MANAGER_TEAM = "Team";
    public static final String XML_TEAM_MANAGER_NAME = "name";
    public static final String XML_TEAM_MANAGER_TOKEN = "token";
    public static final String XML_TEAM_MANAGER_DISTRIBUTION_LIST = "distribution";
    public static final String XML_TEAM_MANAGER_COMPONENT = "component";
    public static final String XML_ROOT_NAME_API_KEY = "ApiKey";
    public static final String XML_ROOT_NAME_APK_FILE_PATH = "ApkFilePath";
    public static final String XML_ROOT_NAME_APK_MD5_VAL = "MD5";
    public static final String XML_ROOT_NAME_APK_FLAG_VAL = "FLAG";
    public static final String XML_ROOT_NAME_APK_LANGUAGE_VAL = "LANGUAGE";
    public static final String XML_ROOT_NAME_APK_UPLOAD_FLAG_VAL = "UPLOAD_FLAG";
    public static final String XML_ROOT_NAME_SELECTED_MODULE_NAME = "SelectedModuleName";
    public static final String XML_ROOT_NAME_SELECTED_PROJECT_NAME = "SelectedProjectName";
    public static final int MAX_MILLISECONDS_SINCE_LAST_COMPILE = 300000;
    private static Calendar lastCompileTime = Calendar.getInstance();
    private static KeysManager sInstance = null;
    private String apiKey;
    private String apkFilePath;
    private String md5;
    private String language;
    private String uploadFlag;
    private String flag;
    private String selectedModuleName;
    private String selectedProjectName;

    public static KeysManager instance() {
        if (sInstance == null) {
            sInstance = (KeysManager)ServiceManager.getService(KeysManager.class);
            ProjectManager.getInstance().addProjectManagerListener(new ProjectManagerListener(){

                public void projectOpened(Project project) {
                    CompilerManager.getInstance((Project)project).addCompilationStatusListener((CompilationStatusListener)sInstance);
                }

                public boolean canCloseProject(Project project) {
                    return true;
                }

                public void projectClosed(Project project) {
                }

                public void projectClosing(Project project) {
                    CompilerManager.getInstance((Project)project).removeCompilationStatusListener((CompilationStatusListener)sInstance);
                }
            });
            CompilerManager.getInstance((Project)ProjectManager.getInstance().getOpenProjects()[0]).addCompilationStatusListener((CompilationStatusListener)sInstance);
        }
        return sInstance;
    }

    @Nullable
    public Element getState() {
        Element filePathTag;
        Element rootTag = new Element(XML_ROOT_NAME_Key_MANAGER);
        Element teamRootTag = new Element(XML_ROOT_NAME_TEAM_MANAGER);
        rootTag.addContent(teamRootTag);
        if (this.apiKey != null) {
            Element apiKeyTag = new Element(XML_ROOT_NAME_API_KEY).setText(this.apiKey);
            rootTag.addContent(apiKeyTag);
        }
        if (this.apkFilePath != null) {
            filePathTag = new Element(XML_ROOT_NAME_APK_FILE_PATH).setText(this.apkFilePath);
            rootTag.addContent(filePathTag);
        }
        if (this.md5 != null) {
            filePathTag = new Element(XML_ROOT_NAME_APK_MD5_VAL).setText(this.md5);
            rootTag.addContent(filePathTag);
        }
        if (this.language != null) {
            filePathTag = new Element(XML_ROOT_NAME_APK_LANGUAGE_VAL).setText(this.language);
            rootTag.addContent(filePathTag);
        }
        if (this.uploadFlag != null) {
            filePathTag = new Element(XML_ROOT_NAME_APK_UPLOAD_FLAG_VAL).setText(this.uploadFlag);
            rootTag.addContent(filePathTag);
        }
        if (this.flag != null) {
            filePathTag = new Element(XML_ROOT_NAME_APK_FLAG_VAL).setText(this.flag);
            rootTag.addContent(filePathTag);
        }
        if (this.selectedModuleName != null) {
            Element moduleName = new Element(XML_ROOT_NAME_SELECTED_MODULE_NAME).setText(this.selectedModuleName);
            rootTag.addContent(moduleName);
        }
        if (this.selectedProjectName != null) {
            Element projectName = new Element(XML_ROOT_NAME_SELECTED_PROJECT_NAME).setText(this.selectedProjectName);
            rootTag.addContent(projectName);
        }
        return rootTag;
    }

    public void loadState(Element componentTag) {
        if (componentTag.getName().equals(XML_TEAM_MANAGER_COMPONENT)) {
            Iterator rootIterator = componentTag.getDescendants();
            while (rootIterator.hasNext()) {
                Element rootElement;
                Object element = rootIterator.next();
                if (!(element instanceof Element) || (rootElement = (Element)element).getName().equals(XML_ROOT_NAME_TEAM_MANAGER)) continue;
                if (rootElement.getName().equals(XML_ROOT_NAME_API_KEY)) {
                    this.apiKey = this.parseApiKey(rootElement);
                    continue;
                }
                if (rootElement.getName().equals(XML_ROOT_NAME_APK_FILE_PATH)) {
                    this.apkFilePath = this.parseApkFilePath(rootElement);
                    continue;
                }
                if (rootElement.getName().equals(XML_ROOT_NAME_SELECTED_MODULE_NAME)) {
                    this.selectedModuleName = this.parseUserSelectedModuleName(rootElement);
                    continue;
                }
                if (rootElement.getName().equals(XML_ROOT_NAME_SELECTED_PROJECT_NAME)) {
                    this.selectedProjectName = this.parseUserSelectedProjectName(rootElement);
                    continue;
                }
                if (rootElement.getName().equals(XML_ROOT_NAME_APK_MD5_VAL)) {
                    this.md5 = this.parseMd5(rootElement);
                    continue;
                }
                if (rootElement.getName().equals(XML_ROOT_NAME_APK_LANGUAGE_VAL)) {
                    this.language = this.parseLanguage(rootElement);
                    continue;
                }
                if (rootElement.getName().equals(XML_ROOT_NAME_APK_UPLOAD_FLAG_VAL)) {
                    this.uploadFlag = this.parseUploadFlag(rootElement);
                    continue;
                }
                if (!rootElement.getName().equals(XML_ROOT_NAME_APK_FLAG_VAL)) continue;
                this.flag = this.parseFlag(rootElement);
            }
        }
    }

    public String parseUserSelectedProjectName(Element element) {
        return element.getText();
    }

    public String parseUserSelectedModuleName(Element element) {
        return element.getText();
    }

    public String parseApkFilePath(Element element) {
        return element.getText();
    }

    public String parseMd5(Element element) {
        return element.getText();
    }

    public String parseLanguage(Element element) {
        return element.getText();
    }

    public String parseFlag(Element element) {
        return element.getText();
    }

    public String parseUploadFlag(Element element) {
        return element.getText();
    }

    public String parseApiKey(Element element) {
        return element.getText();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApkFilePath() {
        return this.apkFilePath;
    }

    public void setApkFilePath(String apkFilePath) {
        this.apkFilePath = apkFilePath;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String m) {
        this.md5 = m;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String m) {
        this.language = m;
    }

    public String getUploadFlag() {
        return this.uploadFlag;
    }

    public void setUploadFlag(String flag) {
        this.uploadFlag = flag;
    }

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String fl) {
        this.flag = fl;
    }

    public String getSelectedModuleName() {
        return this.selectedModuleName;
    }

    public void setSelectedModuleName(String selectedModuleName) {
        this.selectedModuleName = selectedModuleName;
    }

    public String getSelectedProjectName() {
        return this.selectedProjectName;
    }

    public void setSelectedProjectName(String selectedProjectName) {
        this.selectedProjectName = selectedProjectName;
    }

    public static Calendar getLastCompileTime() {
        return lastCompileTime;
    }

    public static void setLastCompileTime(Calendar lastCompileTime) {
        KeysManager.lastCompileTime = lastCompileTime;
    }

    public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
        if (errors < 1) {
            lastCompileTime = Calendar.getInstance();
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(ProjectManager.getInstance().getOpenProjects()[0]);
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("\u7f16\u8bd1\u5b8c\u6bd5\u53d1\u9001\u5230FIR.im, <a href='open'>\u70b9\u51fb</a> \u6253\u5f00FIR.im uploader \u5e76\u4e0a\u4f20.", MessageType.INFO, new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        ToolWindowManager.getInstance((Project)ProjectManager.getInstance().getOpenProjects()[0]).getToolWindow("FIR.im").show(null);
                    }
                }
            }).setFadeoutTime(4000L).createBalloon().show(RelativePoint.getNorthEastOf((JComponent)statusBar.getComponent()), Balloon.Position.atRight);
        }
    }

    public void fileGenerated(String outputRoot, String relativePath) {
    }
}

