/*
 * Decompiled with CFR 0.152.
 */
package ro.catalin.prata.firuploader.provider;

import java.io.File;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import ro.catalin.prata.firuploader.Model.Binary;
import ro.catalin.prata.firuploader.Model.CustomMultiPartEntity;
import ro.catalin.prata.firuploader.utils.SearchFile;
import ro.catalin.prata.firuploader.utils.UploadToRio;
import ro.catalin.prata.firuploader.utils.Utils;
import ro.catalin.prata.firuploader.view.Main;

public class UploadService
implements CustomMultiPartEntity.ProgressListener {
    public UploadServiceDelegate uploadServiceDelegate;
    public CustomMultiPartEntity iconMultipartEntity;
    public CustomMultiPartEntity multipartEntity;
    public HttpPost post;

    public void sendBuild(String url, final String filePath, final String apiToken, final Binary binary, final String appChanglog, UploadServiceDelegate delegate) {
        this.uploadServiceDelegate = delegate;
        new Thread(new Runnable(){

            @Override
            public void run() {
                block14: {
                    Main.getInstance().setTest("\u5f00\u59cb\u4e0a\u4f20....");
                    UploadToRio uploadToRio = new UploadToRio(binary.bundleId, apiToken, binary.name, binary.versionName, binary.versionCode, appChanglog);
                    String url = uploadToRio.uploadTicket.binaryUploadUrl;
                    try {
                        DefaultHttpClient client = new DefaultHttpClient();
                        UploadService.this.post = new HttpPost(url);
                        Main.getInstance().setShortLink("http://fir.im/" + uploadToRio.uploadTicket.appShort);
                        SearchFile searchFile = new SearchFile(filePath);
                        try {
                            if (!binary.icon.isEmpty()) {
                                InputStreamBody iconToUpload = searchFile.query(binary.icon);
                                UploadService.this.iconMultipartEntity = new CustomMultiPartEntity(UploadService.this);
                                UploadService.this.iconMultipartEntity.addPart("key", (ContentBody)new StringBody(uploadToRio.uploadTicket.iconKey));
                                UploadService.this.iconMultipartEntity.addPart("token", (ContentBody)new StringBody(uploadToRio.uploadTicket.iconToken));
                                UploadService.this.iconMultipartEntity.addPart("file", (ContentBody)iconToUpload);
                                if (UploadService.this.uploadServiceDelegate == null) {
                                    return;
                                }
                                UploadService.this.uploadServiceDelegate.onPackageSizeComputed(UploadService.this.iconMultipartEntity.getContentLength());
                                UploadService.this.post.setEntity((HttpEntity)UploadService.this.iconMultipartEntity);
                                HttpResponse iconResponse = client.execute((HttpUriRequest)UploadService.this.post);
                                HttpEntity iconEntity = iconResponse.getEntity();
                                String iconResponseString = EntityUtils.toString((HttpEntity)iconEntity, (String)"UTF-8");
                                System.out.println(iconResponseString);
                                JSONObject iconJsonObject = new JSONObject(iconResponseString);
                                if (iconResponse.getStatusLine().getStatusCode() == 200) {
                                    if (UploadService.this.uploadServiceDelegate != null) {
                                        Main.getInstance().setTips("Icon upload success");
                                    } else {
                                        return;
                                    }
                                }
                                Main.getInstance().setTest("\u4e0a\u4f20icon\u5b8c\u6210....");
                                searchFile.zipFile.close();
                            }
                        }
                        catch (Exception e) {
                            Utils.postErrorNoticeTOSlack(e);
                        }
                        File fileToUpload = new File(filePath);
                        UploadService.this.multipartEntity = new CustomMultiPartEntity(UploadService.this);
                        UploadService.this.multipartEntity.addPart("key", (ContentBody)new StringBody(uploadToRio.uploadTicket.binaryKey));
                        UploadService.this.multipartEntity.addPart("token", (ContentBody)new StringBody(uploadToRio.uploadTicket.binaryToken));
                        UploadService.this.multipartEntity.addPart("file", (ContentBody)new FileBody(fileToUpload));
                        UploadService.this.multipartEntity.addPart("x:name", (ContentBody)new StringBody(uploadToRio.appName, Charset.forName("UTF-8")));
                        UploadService.this.multipartEntity.addPart("x:version", (ContentBody)new StringBody(uploadToRio.versionName, Charset.forName("UTF-8")));
                        UploadService.this.multipartEntity.addPart("x:build", (ContentBody)new StringBody(uploadToRio.versionCode));
                        UploadService.this.multipartEntity.addPart("x:changelog", (ContentBody)new StringBody(uploadToRio.changeLog, Charset.forName("UTF-8")));
                        if (UploadService.this.uploadServiceDelegate != null) {
                            UploadService.this.uploadServiceDelegate.onPackageSizeComputed(UploadService.this.multipartEntity.getContentLength());
                        }
                        UploadService.this.post.setEntity((HttpEntity)UploadService.this.multipartEntity);
                        HttpResponse response = client.execute((HttpUriRequest)UploadService.this.post);
                        HttpEntity entity = response.getEntity();
                        String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                        JSONObject jsonObject = new JSONObject(responseString);
                        if (response.getStatusLine().getStatusCode() == 200) {
                            if (UploadService.this.uploadServiceDelegate != null) {
                                UploadService.this.uploadServiceDelegate.onUploadFinished(true);
                            }
                        } else if (UploadService.this.uploadServiceDelegate != null) {
                            UploadService.this.uploadServiceDelegate.onUploadFinished(false);
                        }
                        Main.getInstance().setTest("\u4e0a\u4f20file\u5b8c\u6210....");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Main.getInstance().setTest("e" + e.getMessage());
                        Utils.postErrorNoticeTOSlack(e);
                        if (UploadService.this.uploadServiceDelegate == null) break block14;
                        UploadService.this.uploadServiceDelegate.onUploadFinished(false);
                    }
                }
            }
        }).start();
    }

    public void iconUpload() {
    }

    @Override
    public void transferred(long num) {
        if (this.uploadServiceDelegate != null) {
            this.uploadServiceDelegate.onProgressChanged(num);
        }
    }

    public static interface UploadServiceDelegate {
        public void onUploadFinished(boolean var1);

        public void onPackageSizeComputed(long var1);

        public void onProgressChanged(long var1);
    }
}

