/*
 * Decompiled with CFR 0.152.
 */
package ro.catalin.prata.firuploader.utils;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import ro.catalin.prata.firuploader.controller.KeysManager;

public class Utils {
    public static String validateString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static FileChooserDescriptor createSingleFileDescriptor(final FileType fileType) {
        return new FileChooserDescriptor(true, true, true, true, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return file.isDirectory() || file.getFileType() == fileType;
            }

            public boolean isFileSelectable(VirtualFile file) {
                return super.isFileSelectable(file) && file.getFileType() == fileType;
            }
        };
    }

    public static void postNoticeTOSlack(final String msg) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                DefaultHttpClient httpClient = new DefaultHttpClient();
                String postUrl = "https://hooks.slack.com/services/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";
                HttpPost httppost = new HttpPost(postUrl);
                HttpResponse response = null;
                try {
                    ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
                    JSONObject obj = new JSONObject();
                    obj.append("text", (Object)msg);
                    postParameters.add(new BasicNameValuePair("payload", obj.toString().replace("[", "").replace("]", "")));
                    httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    Utils.postErrorNoticeTOSlack(e);
                    e.printStackTrace();
                }
                catch (JSONException e) {
                    Utils.postErrorNoticeTOSlack((Exception)((Object)e));
                    e.printStackTrace();
                }
                try {
                    response = httpClient.execute((HttpUriRequest)httppost);
                    HttpEntity entity = response.getEntity();
                    String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    Utils.postErrorNoticeTOSlack(e);
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static void postSuccessNoticeToSlack(String msg) {
        Utils.postNoticeTOSlack("#AndroidStudio#success#" + msg);
    }

    public static void postErrorNoticeTOSlack(Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)writer, true));
        Utils.postNoticeTOSlack("#AndroidStudio#Error#" + writer.toString());
    }

    public static void local() {
        Locale locale = Locale.getDefault();
        System.out.println(locale.getLanguage());
        System.out.println(locale.getCountry());
        String language = locale.getLanguage();
        String country = locale.getCountry();
    }

    public static boolean isZh() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        if (KeysManager.instance().getLanguage() == null) {
            return language.equals("zh");
        }
        if (!KeysManager.instance().getLanguage().isEmpty()) {
            return KeysManager.instance().getLanguage().equals("chinese");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMd5(String path) {
        String value = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            FileInputStream fis = new FileInputStream(path);
            byte[] dataBytes = new byte[1024];
            int nRead = 0;
            while ((nRead = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nRead);
            }
            byte[] mBytes = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mBytes.length; ++i) {
                sb.append(Integer.toString((mBytes[i] & 0xFF) + 256, 16).substring(1));
            }
            System.out.println("Digest(in hex format):: " + sb.toString());
            value = sb.toString();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }
}

