/*
 * Decompiled with CFR 0.152.
 */
package ro.catalin.prata.firuploader.Model;

import java.io.File;
import java.io.IOException;
import net.dongliu.apk.parser.ApkParser;
import net.dongliu.apk.parser.bean.ApkMeta;
import ro.catalin.prata.firuploader.utils.Utils;

public class Binary {
    public String name;
    public String icon;
    public String bundleId;
    public String aShort;
    public String versionName;
    public String versionCode;
    public String filePath;
    public static Binary binary;

    public Binary() {
        binary = this;
    }

    public Binary(String url) {
        binary = this;
        this.filePath = url;
        this.parseApk(url);
    }

    public static Binary getInstance() {
        if (binary == null) {
            return new Binary();
        }
        return binary;
    }

    public void initPath(String url) {
        this.filePath = url;
        if (this.filePath.isEmpty()) {
            return;
        }
        this.parseApk(this.filePath);
    }

    public void parseApk(String url) {
        ApkParser apkParser = null;
        try {
            apkParser = new ApkParser(new File(url));
            ApkMeta apkMeta = apkParser.getApkMeta();
            System.out.println(apkMeta.getLabel());
            System.out.println(apkMeta.getPackageName());
            System.out.println(apkMeta.getVersionCode());
            System.out.println(apkMeta.getLabel());
            System.out.println(apkMeta.getIcon().getPath());
            this.versionName = apkMeta.getVersionName();
            this.versionCode = apkMeta.getVersionCode().toString();
            this.bundleId = apkMeta.getPackageName();
            this.name = apkMeta.getLabel();
            this.icon = apkMeta.getIcon().getPath();
            apkParser.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Utils.postErrorNoticeTOSlack(e);
        }
    }
}

