/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.util.List;
import java.util.Locale;
import net.dongliu.apk.parser.bean.Constants;
import net.dongliu.apk.parser.parser.XmlNamespaces;
import net.dongliu.apk.parser.parser.XmlStreamer;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import net.dongliu.apk.parser.struct.xml.Attribute;
import net.dongliu.apk.parser.struct.xml.XmlCData;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceStartTag;
import net.dongliu.apk.parser.struct.xml.XmlNodeEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNodeStartTag;
import org.apache.commons.lang3.StringEscapeUtils;

public class XmlTranslator
implements XmlStreamer {
    private StringBuilder sb;
    private int shift = 0;
    private XmlNamespaces namespaces;
    private boolean isLastStartTag;
    private Locale locale;
    private ResourceTable resourceTable;

    public XmlTranslator(ResourceTable resourceTable, Locale locale) {
        this.locale = locale;
        this.resourceTable = resourceTable;
        this.sb = new StringBuilder();
        this.sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        this.namespaces = new XmlNamespaces();
    }

    @Override
    public void onStartTag(XmlNodeStartTag xmlNodeStartTag) {
        if (this.isLastStartTag) {
            this.sb.append(">\n");
        }
        this.appendShift(this.shift++);
        this.sb.append('<');
        if (xmlNodeStartTag.namespace != null) {
            String prefix = this.namespaces.getPrefixViaUri(xmlNodeStartTag.namespace);
            if (prefix != null) {
                this.sb.append(prefix).append(":");
            } else {
                this.sb.append(xmlNodeStartTag.namespace).append(":");
            }
        }
        this.sb.append(xmlNodeStartTag.name);
        List<XmlNamespaces.XmlNamespace> nps = this.namespaces.consumeNameSpaces();
        if (!nps.isEmpty()) {
            for (XmlNamespaces.XmlNamespace np : nps) {
                this.sb.append(" xmlns:").append(np.getPrefix()).append("=\"").append(np.getUri()).append("\"");
            }
        }
        this.isLastStartTag = true;
    }

    @Override
    public void onEndTag(XmlNodeEndTag xmlNodeEndTag) {
        --this.shift;
        if (this.isLastStartTag) {
            this.sb.append(" />\n");
        } else {
            this.appendShift(this.shift);
            this.sb.append("</");
            if (xmlNodeEndTag.namespace != null) {
                this.sb.append(xmlNodeEndTag.namespace).append(":");
            }
            this.sb.append(xmlNodeEndTag.name);
            this.sb.append(">\n");
        }
        this.isLastStartTag = false;
    }

    @Override
    public void onAttribute(Attribute attribute) {
        String finalValue;
        this.sb.append(" ");
        String namespace = this.namespaces.getPrefixViaUri(attribute.namespace);
        if (namespace == null) {
            namespace = attribute.namespace;
        }
        if (namespace != null && !namespace.isEmpty()) {
            this.sb.append(namespace).append(':');
        }
        String value = attribute.toStringValue(this.resourceTable, this.locale);
        try {
            finalValue = this.getAttributeValueAsString(attribute.name, value);
        }
        catch (NumberFormatException e) {
            finalValue = value;
        }
        String escapedFinalValue = StringEscapeUtils.escapeXml10((String)finalValue);
        this.sb.append(attribute.name).append('=').append('\"').append(escapedFinalValue).append('\"');
    }

    private String getAttributeValueAsString(String attributeName, String value) {
        Constants.ProtectionLevel protectionLevel;
        int intValue = Integer.valueOf(value);
        String realValue = value;
        if (attributeName.equals("screenOrientation")) {
            Constants.ScreenOrientation screenOrientation = Constants.ScreenOrientation.valueOf(intValue);
            if (screenOrientation != null) {
                realValue = screenOrientation.name();
            }
        } else if (attributeName.equals("configChanges")) {
            List<Constants.ConfigChanges> configChangesList = Constants.ConfigChanges.valuesOf(intValue);
            if (!configChangesList.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Constants.ConfigChanges c : configChangesList) {
                    sb.append(c.name()).append('|');
                }
                sb.deleteCharAt(sb.length() - 1);
                realValue = sb.toString();
            }
        } else if (attributeName.equals("windowSoftInputMode")) {
            List<Constants.WindowSoftInputMode> windowSoftInputModeList = Constants.WindowSoftInputMode.valuesOf(intValue);
            if (!windowSoftInputModeList.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Constants.WindowSoftInputMode w : windowSoftInputModeList) {
                    sb.append(w.name()).append('|');
                }
                sb.deleteCharAt(sb.length() - 1);
                realValue = sb.toString();
            }
        } else if (attributeName.equals("launchMode")) {
            Constants.LaunchMode launchMode = Constants.LaunchMode.valueOf(intValue);
            if (launchMode != null) {
                realValue = launchMode.name();
            }
        } else if (attributeName.equals("installLocation")) {
            Constants.InstallLocation installLocation = Constants.InstallLocation.valueOf(intValue);
            if (installLocation != null) {
                realValue = installLocation.name();
            }
        } else if (attributeName.equals("protectionLevel") && (protectionLevel = Constants.ProtectionLevel.valueOf(intValue)) != null) {
            realValue = protectionLevel.name();
        }
        return realValue;
    }

    @Override
    public void onCData(XmlCData xmlCData) {
        this.appendShift(this.shift);
        this.sb.append(xmlCData.toStringValue(this.resourceTable, this.locale)).append('\n');
        this.isLastStartTag = false;
    }

    @Override
    public void onNamespaceStart(XmlNamespaceStartTag tag) {
        this.namespaces.addNamespace(tag);
    }

    @Override
    public void onNamespaceEnd(XmlNamespaceEndTag tag) {
        this.namespaces.removeNamespace(tag);
    }

    private void appendShift(int shift) {
        for (int i = 0; i < shift; ++i) {
            this.sb.append("\t");
        }
    }

    public String getXml() {
        return this.sb.toString();
    }
}

