/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.cert.CertificateEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.dongliu.apk.parser.bean.Activity;
import net.dongliu.apk.parser.bean.AndroidComponent;
import net.dongliu.apk.parser.bean.ApkMeta;
import net.dongliu.apk.parser.bean.ApkSignStatus;
import net.dongliu.apk.parser.bean.CertificateMeta;
import net.dongliu.apk.parser.bean.Constants;
import net.dongliu.apk.parser.bean.DexClass;
import net.dongliu.apk.parser.bean.GlEsVersion;
import net.dongliu.apk.parser.bean.Icon;
import net.dongliu.apk.parser.bean.IntentFilter;
import net.dongliu.apk.parser.bean.Permission;
import net.dongliu.apk.parser.bean.Receiver;
import net.dongliu.apk.parser.bean.Service;
import net.dongliu.apk.parser.bean.UseFeature;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.parser.BinaryXmlParser;
import net.dongliu.apk.parser.parser.CertificateParser;
import net.dongliu.apk.parser.parser.DexParser;
import net.dongliu.apk.parser.parser.ResourceTableParser;
import net.dongliu.apk.parser.parser.XmlTranslator;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import net.dongliu.apk.parser.utils.Utils;
import net.dongliu.apk.parser.utils.XmlUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApkParser
implements Closeable {
    private DexClass[] dexClasses;
    private ResourceTable resourceTable;
    private Map<Locale, String> manifestXmlMap;
    private Map<Locale, ApkMeta> apkMetaMap;
    private Set<Locale> locales;
    private List<CertificateMeta> certificateMetas;
    private final ZipFile zf;
    private File apkFile;
    private Locale preferredLocale = Locale.getDefault();

    public ApkParser(File apkFile) throws IOException {
        this.apkFile = apkFile;
        this.zf = new ZipFile(apkFile);
        this.manifestXmlMap = new HashMap<Locale, String>();
        this.apkMetaMap = new HashMap<Locale, ApkMeta>();
    }

    public String getManifestXml() throws IOException {
        if (!this.manifestXmlMap.containsKey(this.preferredLocale)) {
            this.parseManifestXml();
        }
        return this.manifestXmlMap.get(this.preferredLocale);
    }

    public ApkMeta getApkMeta() throws IOException {
        if (!this.apkMetaMap.containsKey(this.preferredLocale)) {
            this.parseApkMeta();
        }
        return this.apkMetaMap.get(this.preferredLocale);
    }

    public Set<Locale> getLocales() throws IOException {
        if (this.locales == null) {
            this.parseResourceTable();
        }
        return this.locales;
    }

    public List<CertificateMeta> getCertificateMetas() throws IOException, CertificateEncodingException {
        if (this.certificateMetas == null) {
            this.parseCertificate();
        }
        return this.certificateMetas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCertificate() throws IOException, CertificateEncodingException {
        ZipArchiveEntry entry = null;
        Enumeration enu = this.zf.getEntries();
        while (enu.hasMoreElements() && ((entry = (ZipArchiveEntry)enu.nextElement()).isDirectory() || !entry.getName().toUpperCase().endsWith(".RSA") && !entry.getName().toUpperCase().endsWith(".DSA"))) {
        }
        if (entry == null) {
            throw new ParserException("ApkParser certificate not found");
        }
        InputStream in = this.zf.getInputStream(entry);
        try {
            CertificateParser parser = new CertificateParser(in);
            parser.parse();
            this.certificateMetas = parser.getCertificateMetas();
        }
        finally {
            in.close();
        }
    }

    private void parseApkMeta() throws IOException {
        Document document;
        if (!this.manifestXmlMap.containsKey(this.preferredLocale)) {
            this.parseManifestXml();
        }
        String xml = this.manifestXmlMap.get(this.preferredLocale);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new ParserException("Parse manifest xml failed", e);
        }
        ApkMeta apkMeta = new ApkMeta();
        Node manifestNode = document.getElementsByTagName("manifest").item(0);
        NamedNodeMap manifestAttr = manifestNode.getAttributes();
        apkMeta.setPackageName(XmlUtils.getAttribute(manifestAttr, "package"));
        apkMeta.setVersionCode(XmlUtils.getLongAttribute(manifestAttr, "android:versionCode"));
        apkMeta.setVersionName(XmlUtils.getAttribute(manifestAttr, "android:versionName"));
        String installLocation = XmlUtils.getAttribute(manifestAttr, "android:installLocation");
        if (installLocation != null) {
            apkMeta.setInstallLocation(Constants.InstallLocation.valueOf(installLocation));
        }
        NodeList nodes = manifestNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("uses-sdk")) {
                this.parseSdk(apkMeta, node);
                continue;
            }
            if (nodeName.equals("supports-screens")) {
                this.parseScreens(apkMeta, node);
                continue;
            }
            if (nodeName.equals("uses-feature")) {
                this.parseUsesFeature(apkMeta, node);
                continue;
            }
            if (nodeName.equals("application")) {
                this.parseApplication(apkMeta, node);
                continue;
            }
            if (nodeName.equals("uses-permission")) {
                this.parseUsesPermission(apkMeta, node);
                continue;
            }
            if (!nodeName.equals("permission")) continue;
            this.parsePermission(apkMeta, node);
        }
        this.apkMetaMap.put(this.preferredLocale, apkMeta);
    }

    private void parseApplication(ApkMeta apkMeta, Node node) throws IOException {
        NamedNodeMap attributes = node.getAttributes();
        apkMeta.setLabel(XmlUtils.getAttribute(attributes, "android:label"));
        String iconPath = XmlUtils.getAttribute(attributes, "android:icon");
        if (iconPath != null) {
            Icon icon = this.getIcon(iconPath);
            apkMeta.setIcon(icon);
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (childName.equals("service")) {
                this.parseService(apkMeta, child);
                continue;
            }
            if (childName.equals("activity")) {
                this.parseActivity(apkMeta, child);
                continue;
            }
            if (!childName.equals("receiver")) continue;
            this.parseReceiver(apkMeta, child);
        }
    }

    private void parseActivity(ApkMeta apkMeta, Node node) {
        Activity activity = new Activity();
        this.fillComponent(node, activity);
        apkMeta.addActivity(activity);
        apkMeta.addIntentFilters(activity.getIntentFilters());
    }

    private void parseService(ApkMeta apkMeta, Node node) {
        Service service = new Service();
        this.fillComponent(node, service);
        apkMeta.addService(service);
        apkMeta.addIntentFilters(service.getIntentFilters());
    }

    private void parseReceiver(ApkMeta apkMeta, Node node) {
        Receiver receiver = new Receiver();
        this.fillComponent(node, receiver);
        apkMeta.addReceiver(receiver);
        apkMeta.addIntentFilters(receiver.getIntentFilters());
    }

    private void fillComponent(Node node, AndroidComponent component) {
        NamedNodeMap attributes = node.getAttributes();
        component.setName(XmlUtils.getAttribute(attributes, "android:name"));
        component.setExported(XmlUtils.getBoolAttribute(attributes, "android:exported", false));
        component.setProcess(XmlUtils.getAttribute(attributes, "android:process"));
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (!childName.equals("intent-filter")) continue;
            IntentFilter intentFilter = this.getIntentFilter(child);
            intentFilter.setOwner(component);
            component.addIntentFilter(intentFilter);
        }
    }

    private IntentFilter getIntentFilter(Node intentNode) {
        NodeList intentChildren = intentNode.getChildNodes();
        IntentFilter intentFilter = new IntentFilter();
        for (int j = 0; j < intentChildren.getLength(); ++j) {
            Node intentChild = intentChildren.item(j);
            String intentChildName = intentChild.getNodeName();
            NamedNodeMap intentChildAttributes = intentChild.getAttributes();
            if (intentChildName.equals("action")) {
                intentFilter.addAction(XmlUtils.getAttribute(intentChildAttributes, "android:name"));
                continue;
            }
            if (intentChildName.equals("category")) {
                intentFilter.addCategory(XmlUtils.getAttribute(intentChildAttributes, "android:name"));
                continue;
            }
            if (!intentChildName.equals("data")) continue;
            String scheme = XmlUtils.getAttribute(intentChildAttributes, "android:scheme");
            String host = XmlUtils.getAttribute(intentChildAttributes, "android:host");
            String pathPrefix = XmlUtils.getAttribute(intentChildAttributes, "android:pathPrefix");
            String mimeType = XmlUtils.getAttribute(intentChildAttributes, "android:mimeType");
            String type = XmlUtils.getAttribute(intentChildAttributes, "android:type");
            IntentFilter.IntentData data = new IntentFilter.IntentData();
            data.setScheme(scheme);
            data.setMimeType(mimeType);
            data.setHost(host);
            data.setPathPrefix(pathPrefix);
            data.setType(type);
            intentFilter.addData(data);
        }
        return intentFilter;
    }

    private void parseUsesPermission(ApkMeta apkMeta, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        apkMeta.addUsesPermission(XmlUtils.getAttribute(attributes, "android:name"));
    }

    private void parseUsesFeature(ApkMeta apkMeta, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        String name = XmlUtils.getAttribute(attributes, "android:name");
        boolean required = XmlUtils.getBoolAttribute(attributes, "android:required", true);
        if (name != null) {
            UseFeature useFeature = new UseFeature();
            useFeature.setName(name);
            useFeature.setRequired(required);
            apkMeta.addUseFeatures(useFeature);
        } else {
            Integer gl = XmlUtils.getIntAttribute(attributes, "android:glEsVersion");
            if (gl != null) {
                int v = gl;
                GlEsVersion glEsVersion = new GlEsVersion();
                glEsVersion.setMajor(v >> 16);
                glEsVersion.setMinor(v & 0xFFFF);
                glEsVersion.setRequired(required);
                apkMeta.setGlEsVersion(glEsVersion);
            }
        }
    }

    private void parseSdk(ApkMeta apkMeta, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        apkMeta.setMinSdkVersion(XmlUtils.getAttribute(attributes, "android:minSdkVersion"));
        apkMeta.setMaxSdkVersion(XmlUtils.getAttribute(attributes, "android:maxSdkVersion"));
        apkMeta.setTargetSdkVersion(XmlUtils.getAttribute(attributes, "android:targetSdkVersion"));
    }

    private void parseScreens(ApkMeta apkMeta, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        apkMeta.setSmallScreens(XmlUtils.getBoolAttribute(attributes, "android:minSdkVersion", false));
        apkMeta.setLargeScreens(XmlUtils.getBoolAttribute(attributes, "android:largeScreens", false));
        apkMeta.setNormalScreens(XmlUtils.getBoolAttribute(attributes, "android:normalScreens", false));
        apkMeta.setAnyDensity(XmlUtils.getBoolAttribute(attributes, "android:anyDensity", false));
    }

    private void parsePermission(ApkMeta apkMeta, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Permission permission = new Permission();
        permission.setName(XmlUtils.getAttribute(attributes, "android:name"));
        permission.setLabel(XmlUtils.getAttribute(attributes, "android:label"));
        permission.setIcon(XmlUtils.getAttribute(attributes, "android:icon"));
        permission.setGroup(XmlUtils.getAttribute(attributes, "android:group"));
        permission.setDescription(XmlUtils.getAttribute(attributes, "android:description"));
        String protectionLevel = XmlUtils.getAttribute(attributes, "android:protectionLevel");
        if (protectionLevel != null) {
            permission.setProtectionLevel(Constants.ProtectionLevel.valueOf(protectionLevel));
        }
        apkMeta.addPermission(permission);
    }

    private void parseManifestXml() throws IOException {
        String xml = this.transBinaryXml("AndroidManifest.xml");
        if (xml == null) {
            throw new ParserException("Manifest xml file not found");
        }
        this.manifestXmlMap.put(this.preferredLocale, xml);
    }

    public String transBinaryXml(String path) throws IOException {
        ZipArchiveEntry entry = Utils.getEntry(this.zf, path);
        if (entry == null) {
            return null;
        }
        if (this.resourceTable == null) {
            this.parseResourceTable();
        }
        InputStream in = this.zf.getInputStream(entry);
        ByteBuffer buffer = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)in));
        BinaryXmlParser binaryXmlParser = new BinaryXmlParser(buffer);
        binaryXmlParser.setLocale(this.preferredLocale);
        XmlTranslator xmlTranslator = new XmlTranslator(this.resourceTable, this.preferredLocale);
        binaryXmlParser.setXmlStreamer(xmlTranslator);
        binaryXmlParser.parse();
        return xmlTranslator.getXml();
    }

    public DexClass[] getDexClasses() throws IOException {
        if (this.dexClasses == null) {
            this.parseDexFile();
        }
        return this.dexClasses;
    }

    private void parseDexFile() throws IOException {
        ZipArchiveEntry resourceEntry = Utils.getEntry(this.zf, "classes.dex");
        if (resourceEntry == null) {
            throw new ParserException("Resource table not found");
        }
        InputStream in = this.zf.getInputStream(resourceEntry);
        ByteBuffer buffer = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)in));
        DexParser dexParser = new DexParser(buffer);
        dexParser.parse();
        this.dexClasses = dexParser.getDexClasses();
    }

    private Icon getIcon(String iconPath) throws IOException {
        if (this.preferredLocale == null) {
            throw new ParserException("PreferredLocale must be set first");
        }
        ZipArchiveEntry entry = Utils.getEntry(this.zf, iconPath);
        if (entry == null) {
            return null;
        }
        Icon icon = new Icon();
        icon.setPath(entry.getName());
        icon.setFormat(iconPath.substring(iconPath.indexOf(".") + 1));
        int idx = iconPath.indexOf("dpi/");
        if (idx > 0) {
            icon.setDpiLevel(iconPath.substring(iconPath.lastIndexOf("-", idx) + 1, idx + "dpi".length()));
        } else {
            icon.setDpiLevel("");
        }
        InputStream inputStream = this.zf.getInputStream(entry);
        icon.setData(IOUtils.toByteArray((InputStream)inputStream));
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApkSignStatus verifyApk() throws IOException {
        ZipArchiveEntry entry = Utils.getEntry(this.zf, "META-INF/MANIFEST.MF");
        if (entry == null) {
            return ApkSignStatus.notSigned;
        }
        JarFile jarFile = new JarFile(this.apkFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        byte[] buffer = new byte[8192];
        while (entries.hasMoreElements()) {
            JarEntry e = entries.nextElement();
            if (e.isDirectory()) continue;
            InputStream in = jarFile.getInputStream(e);
            try {
                int count;
                while ((count = in.read(buffer, 0, buffer.length)) != -1) {
                }
            }
            catch (SecurityException se) {
                ApkSignStatus apkSignStatus = ApkSignStatus.incorrect;
                return apkSignStatus;
            }
            finally {
                in.close();
            }
        }
        return ApkSignStatus.signed;
    }

    private void parseResourceTable() throws IOException {
        ZipArchiveEntry entry = Utils.getEntry(this.zf, "resources.arsc");
        if (entry == null) {
            this.resourceTable = new ResourceTable();
            this.locales = Collections.emptySet();
            return;
        }
        this.resourceTable = new ResourceTable();
        this.locales = Collections.emptySet();
        InputStream in = this.zf.getInputStream(entry);
        ByteBuffer buffer = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)in));
        ResourceTableParser resourceTableParser = new ResourceTableParser(buffer);
        resourceTableParser.parse();
        this.resourceTable = resourceTableParser.getResourceTable();
        this.locales = resourceTableParser.getLocales();
    }

    @Override
    public void close() throws IOException {
        this.certificateMetas = null;
        this.apkMetaMap = null;
        this.manifestXmlMap = null;
        this.resourceTable = null;
        this.certificateMetas = null;
        this.zf.close();
    }

    public Locale getPreferredLocale() {
        return this.preferredLocale;
    }

    public void setPreferredLocale(Locale preferredLocale) {
        this.preferredLocale = preferredLocale;
    }
}

