/*
 * Decompiled with CFR 0.152.
 */
package ro.catalin.prata.firuploader.view;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import ro.catalin.prata.firuploader.Model.Binary;
import ro.catalin.prata.firuploader.Model.Document;
import ro.catalin.prata.firuploader.controller.KeysManager;
import ro.catalin.prata.firuploader.controller.ModulesManager;
import ro.catalin.prata.firuploader.provider.UploadService;
import ro.catalin.prata.firuploader.utils.TimerScan;
import ro.catalin.prata.firuploader.utils.Utils;

public class Main
implements ToolWindowFactory,
UploadService.UploadServiceDelegate {
    private JPanel panel1;
    private JButton setTokenBtn;
    private JComboBox projectCombo;
    private JLabel apkPath;
    private JLabel shortLink;
    private JTextArea changeLogTa;
    private JButton uploadBtn;
    private JProgressBar progressBar;
    private JButton settingBtn;
    private JLabel tips;
    private JLabel formHeader;
    private JLabel formToken;
    private JLabel formProject;
    private JLabel formPath;
    private JLabel formLink;
    private JLabel formLog;
    private JLabel formHelp;
    private JLabel formTip;
    private JCheckBox formTipCB;
    private JLabel formUpload;
    private JCheckBox formUploadCB;
    private ToolWindow toolWindow;
    private String appVersion;
    private String appVersionCode;
    private String appId;
    private String appName;
    private String appShort;
    public static Main m;
    private String apkAbsolutePath;
    public Binary binary;
    public Document document;
    private Color COLOR_DARK_PURPLE;
    private TimerScan timerScan;

    public Main() {
        this.$$$setupUI$$$();
        this.COLOR_DARK_PURPLE = new Color(37, 172, 201);
        this.initComponent();
        if (!"yes".equals(KeysManager.instance().getUploadFlag()) || !"cancel".equals(KeysManager.instance().getUploadFlag())) {
            KeysManager.instance().setUploadFlag("cancel");
        }
        m = this;
        this.binary = new Binary();
        Main.getInstance().setTest("start");
        Main.getInstance().setTest("end");
        this.progressBar.setVisible(false);
        this.tips.setVisible(false);
        this.uploadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.updateBuildVersionFields();
                Main.this.performUploadValidation();
            }
        });
        this.setTokenBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String apiKey = Messages.showInputDialog((Project)ProjectManager.getInstance().getOpenProjects()[0], (String)"<HTML>\u83b7\u53d6api token <a href=\"http://fir.im/user/info\">here</a>.</HTML>", (String)"api token", null, (String)KeysManager.instance().getApiKey(), null);
                if (apiKey != null && apiKey.length() > 3) {
                    KeysManager.instance().setApiKey(apiKey);
                }
            }
        });
        this.projectCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                File file;
                KeysManager.instance().setSelectedModuleName((String)Main.this.projectCombo.getSelectedItem());
                Module module = ModulesManager.instance().getModuleByName((String)Main.this.projectCombo.getSelectedItem());
                String filePath = ModulesManager.instance().getAndroidApkPath(module);
                if (filePath == null) {
                    filePath = "";
                }
                if (!(file = new File(filePath)).exists() || filePath.toLowerCase().indexOf(".apk") < 0) {
                    filePath = "";
                }
                Main.this.apkAbsolutePath = filePath;
                Main.this.binary.initPath(Main.this.apkAbsolutePath);
                Main.this.apkPath.setText(Main.this.splitPath(filePath));
                Main.this.updateBuildVersionFields();
            }
        });
        this.setupValuesOnUI();
        this.settingBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileType type = FileTypeManager.getInstance().getFileTypeByExtension("apk");
                FileChooserDescriptor descriptor = Utils.createSingleFileDescriptor(type);
                descriptor.setTitle("APK File");
                descriptor.setDescription("choose apk to upload FIR.im");
                VirtualFile fileToSelect = ProjectManager.getInstance().getOpenProjects()[0].getBaseDir();
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, null, (VirtualFile)fileToSelect, (Consumer)new FileChooser.FileChooserConsumer(){

                    public void cancelled() {
                    }

                    public void consume(List<VirtualFile> virtualFiles) {
                        String filePath = virtualFiles.get(0).getPath();
                        File file = new File(filePath);
                        if (!file.exists() || filePath.toLowerCase().indexOf(".apk") < 0) {
                            filePath = "";
                        }
                        Main.this.apkAbsolutePath = filePath;
                        Main.this.apkPath.setText(Main.this.splitPath(filePath));
                        Main.this.binary.initPath(Main.this.apkAbsolutePath);
                        KeysManager.instance().setApkFilePath(filePath);
                        Main.this.updateBuildVersionFields();
                    }
                });
            }
        });
        this.shortLink.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Main.this.browserUrl(Main.getInstance().shortLink.getText());
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.formHelp.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    Desktop desktop = Desktop.getDesktop();
                    String message = "mailto:yh@fir.im?subject=firuploader";
                    URI uri = URI.create(message);
                    desktop.mail(uri);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Utils.postErrorNoticeTOSlack(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.timerScan = new TimerScan();
        this.formTipCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Main.this.formTipCB.isSelected()) {
                    KeysManager.instance().setFlag("");
                } else {
                    KeysManager.instance().setFlag("cancel");
                }
            }
        });
        this.formUploadCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Main.this.formUploadCB.isSelected()) {
                    KeysManager.instance().setUploadFlag("yes");
                } else {
                    KeysManager.instance().setUploadFlag("cancel");
                }
            }
        });
    }

    public String splitPath(String filep) {
        String rt = "";
        if (filep == null) {
            filep = "";
        }
        if (filep.length() > 30) {
            filep = "..." + filep.substring(filep.length() - 30, filep.length());
        }
        return filep;
    }

    public void setShortLink(String sh) {
        this.appShort = sh;
        this.shortLink.setText(sh);
        this.shortLink.repaint();
    }

    public static Main getInstance() {
        return m;
    }

    public void updateBuildVersionFields() {
        Module module = ModulesManager.instance().getModuleByName((String)this.projectCombo.getSelectedItem());
        String[] apk = new String[3];
        if (this.apkAbsolutePath != null) {
            this.binary.initPath(this.apkAbsolutePath);
        }
    }

    public void setTips(String content) {
        Main.getInstance().tips.setText(content);
    }

    public void performUploadValidation() {
        String mm = this.apkPath.getText();
        if (KeysManager.instance().getApiKey() == null) {
            Messages.showErrorDialog((String)"\u8bf7\u8bbe\u7f6efir.im\u7684api token", (String)"api token \u4e0d\u5408\u6cd5");
        } else if (this.apkAbsolutePath == null || this.apkAbsolutePath.length() < 3) {
            Messages.showErrorDialog((String)"\u5de5\u7a0b\u6ca1\u6709\u53d1\u73b0apk\u6587\u4ef6\u8bf7\u5355\u51fb\u8bbe\u7f6e\u6765\u8bbe\u7f6eapk\u8def\u5f84", (String)"apk\u6587\u4ef6\u4e0d\u5408\u6cd5");
        } else if (this.binary.name == null) {
            this.binary.name = Messages.showInputDialog((Project)ProjectManager.getInstance().getOpenProjects()[0], (String)"<HTML>\u8bf7\u8bbe\u7f6eapk\u5e94\u7528\u540d\u79f0</HTML>", (String)"apk\u7684\u540d\u79f0", null, (String)"", null);
        } else {
            this.uploadBuild();
        }
    }

    public void uploadBuild() {
        Main.getInstance().binary.initPath(this.apkAbsolutePath);
        this.progressBar.setValue(0);
        this.progressBar.setVisible(true);
        this.uploadBtn.setEnabled(false);
        this.tips.setVisible(true);
        this.uploadBtn.setText("uploading...");
        this.tips.setText("uploading....");
        new UploadService().sendBuild(null, this.apkAbsolutePath, KeysManager.instance().getApiKey(), this.binary, this.changeLogTa.getText(), this);
    }

    public void setTest(String text) {
    }

    public void setupValuesOnUI() {
        Module previouslySelectedModule = ModulesManager.instance().getModuleByName(KeysManager.instance().getSelectedModuleName());
        if (previouslySelectedModule != null) {
            File file;
            String filePath = ModulesManager.instance().getAndroidApkPath(previouslySelectedModule);
            if (filePath == null) {
                filePath = "";
            }
            if (!(file = new File(filePath)).exists() || filePath.toLowerCase().indexOf(".apk") < 0) {
                filePath = "";
            }
            this.apkAbsolutePath = filePath;
            this.apkPath.setText(this.splitPath(filePath));
            this.binary.initPath(this.apkAbsolutePath);
        } else {
            File file;
            previouslySelectedModule = ModulesManager.instance().getMostImportantModule();
            String filePath = ModulesManager.instance().getAndroidApkPath(previouslySelectedModule);
            if (filePath == null) {
                filePath = "";
            }
            if (!(file = new File(filePath)).exists()) {
                filePath = "";
            }
            this.apkAbsolutePath = filePath;
            this.apkPath.setText(this.splitPath(filePath));
            this.binary.initPath(this.apkAbsolutePath);
        }
        this.projectCombo.setModel(new DefaultComboBoxModel<String>(ModulesManager.instance().getAllModuleNames()));
        this.projectCombo.setSelectedIndex(ModulesManager.instance().getSelectedModuleIndex(previouslySelectedModule.getName()));
        this.updateBuildVersionFields();
    }

    public void createToolWindowContent(Project project, ToolWindow toolWindow) {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent((JComponent)this.panel1, "", false);
        toolWindow.getContentManager().addContent(content);
        this.toolWindow = toolWindow;
        ProjectManager.getInstance().addProjectManagerListener(new ProjectManagerListener(){

            public void projectOpened(Project project) {
                File file;
                Module previouslySelectedModule = ModulesManager.instance().getMostImportantModule();
                String filePath = previouslySelectedModule.getModuleFilePath();
                if (filePath == null) {
                    filePath = "";
                }
                if (!(file = new File(filePath)).exists() || filePath.toLowerCase().indexOf(".apk") < 0) {
                    filePath = "";
                }
                Main.this.apkAbsolutePath = filePath;
                Main.this.binary.initPath(Main.this.apkAbsolutePath);
                Main.this.apkPath.setText(Main.this.splitPath(filePath));
                KeysManager.instance().setSelectedModuleName(previouslySelectedModule.getName());
                String[] modules = ModulesManager.instance().getAllModuleNames();
                if (modules != null) {
                    Main.this.projectCombo.setModel(new DefaultComboBoxModel<String>(ModulesManager.instance().getAllModuleNames()));
                }
                Main.this.projectCombo.setSelectedIndex(ModulesManager.instance().getSelectedModuleIndex(previouslySelectedModule.getName()));
            }

            public boolean canCloseProject(Project project) {
                return true;
            }

            public void projectClosed(Project project) {
            }

            public void projectClosing(Project project) {
            }
        });
    }

    @Override
    public void onUploadFinished(final boolean finishedSuccessful) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!finishedSuccessful) {
                    Messages.showErrorDialog((String)"\u4e0a\u4f20\u5931\u8d25\uff01\u6709\u95ee\u9898\u8bf7\u8054\u7cfbdev@fir.im", (String)"\u4e0a\u4f20\u5931\u8d25\uff01\u6709\u95ee\u9898\u8bf7\u8054\u7cfbdev@fir.im");
                    Main.this.progressBar.setVisible(false);
                    Main.this.uploadBtn.setEnabled(true);
                    Main.this.uploadBtn.setText(Main.this.document.uploadBtn);
                    Main.this.changeLogTa.setText("");
                    Main.getInstance().tips.setVisible(false);
                    Main.getInstance().tips.repaint();
                    return;
                }
                Main.this.progressBar.setVisible(false);
                Main.this.uploadBtn.setEnabled(true);
                Main.this.uploadBtn.setText(Main.this.document.uploadBtn);
                Main.getInstance().tips.setText("File upload success");
                KeysManager.instance().setMd5(Utils.getMd5(Main.getInstance().binary.filePath));
                Main.this.changeLogTa.setText("");
                Main.this.uploadFinishNotice();
                Thread th = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(2000L);
                            Main.getInstance().tips.setVisible(false);
                            Main.getInstance().tips.repaint();
                            Utils.postSuccessNoticeToSlack("#" + Main.getInstance().binary.name + "#" + Main.getInstance().appShort);
                        }
                        catch (Exception e) {
                            Utils.postErrorNoticeTOSlack(e);
                            System.out.println(e);
                        }
                    }
                });
                th.start();
            }
        });
    }

    @Override
    public void onPackageSizeComputed(final long totalSize) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.progressBar.setMaximum((int)totalSize);
            }
        });
    }

    @Override
    public void onProgressChanged(final long progress) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.progressBar.setValue((int)progress);
            }
        });
    }

    public void uploadFinishNotice() {
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(ProjectManager.getInstance().getOpenProjects()[0]);
        JComponent component = statusBar.getComponent();
        Rectangle rect = component.getVisibleRect();
        Point p = new Point(rect.x + rect.width - 30, rect.y - 30);
        RelativePoint point = new RelativePoint((Component)component, p);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("<p style='font-size:12px;color:black'>fir.im\u4e0a\u4f20\u6210\u529fY(^_^)Y</p></br><p style='font-size:12px;'> <a style='font-size:12px' href='" + this.shortLink.getText() + "'>" + this.shortLink.getText() + "</a> \u6253\u5f00\u94fe\u63a5\u53bb\u67e5\u770b.</p>", MessageType.INFO, new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Main.this.browserUrl(Main.getInstance().shortLink.getText());
                }
            }
        }).setFadeoutTime(10000L).setCloseButtonEnabled(true).createBalloon().show(point, Balloon.Position.atRight);
    }

    public void browserUrl(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            Utils.postErrorNoticeTOSlack(e1);
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
            Utils.postErrorNoticeTOSlack(e1);
        }
    }

    public void initComponent() {
        this.document = new Document();
        this.formHeader.setText(this.document.formHeader);
        this.formLink.setText(this.document.formLink);
        this.formLog.setText(this.document.formLog);
        this.formPath.setText(this.document.formPath);
        this.formToken.setText(this.document.formToken);
        this.formProject.setText(this.document.formProject);
        this.settingBtn.setText(this.document.settingBtn);
        this.setTokenBtn.setText(this.document.setTokenBtn);
        this.uploadBtn.setText(this.document.uploadBtn);
        this.formTip.setText(this.document.formTip);
        if ("cancel".equals(KeysManager.instance().getFlag())) {
            this.formTipCB.setSelected(false);
        } else {
            this.formTipCB.setSelected(true);
        }
        if ("cancel".equals(KeysManager.instance().getUploadFlag())) {
            this.formUploadCB.setSelected(false);
        } else if ("yes".equals(KeysManager.instance().getUploadFlag())) {
            this.formUploadCB.setSelected(true);
        } else {
            this.formUploadCB.setSelected(false);
            KeysManager.instance().setUploadFlag("cancel");
        }
        this.formUpload.setText(this.document.formUpload);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JProgressBar jProgressBar;
        JButton jButton;
        JLabel jLabel2;
        JLabel jLabel3;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel4;
        JLabel jLabel5;
        JButton jButton2;
        JComboBox jComboBox;
        JLabel jLabel6;
        JButton jButton3;
        JTextArea jTextArea;
        JLabel jLabel7;
        JLabel jLabel8;
        JLabel jLabel9;
        JLabel jLabel10;
        JLabel jLabel11;
        JLabel jLabel12;
        JPanel jPanel;
        this.panel1 = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 5, 5));
        ((Component)jPanel2).setForeground(new Color(-6237205));
        ((Component)jPanel2).setBackground(new Color(-14308151));
        jPanel.add((Component)jPanel2, "North");
        this.formHeader = jLabel12 = new JLabel();
        jLabel12.setText("FIR.im \u4e00\u952e\u4e0a\u4f20");
        Font font = jLabel12.getFont();
        jLabel12.setFont(new Font(font.getName(), font.getStyle(), 20));
        ((Component)jLabel12).setForeground(new Color(-1));
        Component component = jPanel2.add(jLabel12);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(16, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setBackground(new Color(-1));
        jPanel3.setToolTipText("");
        jPanel.add((Component)jPanel3, "Center");
        Font font2 = jPanel3.getFont();
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, new Font(font2.getName(), font2.getStyle(), font2.getSize()), new Color(-16777216)));
        this.formProject = jLabel11 = new JLabel();
        jLabel11.setText("PROJECT");
        Font font3 = jLabel11.getFont();
        jLabel11.setFont(new Font("AppleMyungjo", font3.getStyle(), 20));
        ((Component)jLabel11).setForeground(new Color(-6710887));
        jPanel3.add((Component)jLabel11, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.formPath = jLabel10 = new JLabel();
        jLabel10.setText("APK PATH");
        Font font4 = jLabel10.getFont();
        jLabel10.setFont(new Font("AppleMyungjo", font4.getStyle(), 20));
        ((Component)jLabel10).setForeground(new Color(-6710887));
        jPanel3.add((Component)jLabel10, new GridConstraints(7, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.formToken = jLabel9 = new JLabel();
        jLabel9.setText("TOKEN");
        Font font5 = jLabel9.getFont();
        jLabel9.setFont(new Font("AppleMyungjo", font5.getStyle(), 16));
        ((Component)jLabel9).setForeground(new Color(-6710887));
        jLabel9.putClientProperty("html.disable", Boolean.FALSE);
        jPanel3.add((Component)jLabel9, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.formLink = jLabel8 = new JLabel();
        jLabel8.setText("SHORT LINK");
        Font font6 = jLabel8.getFont();
        jLabel8.setFont(new Font("AppleMyungjo", font6.getStyle(), 20));
        ((Component)jLabel8).setForeground(new Color(-6710887));
        jPanel3.add((Component)jLabel8, new GridConstraints(10, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.formLog = jLabel7 = new JLabel();
        jLabel7.setText("CHANGE LOG");
        Font font7 = jLabel7.getFont();
        jLabel7.setFont(new Font(font7.getName(), font7.getStyle(), 20));
        ((Component)jLabel7).setForeground(new Color(-6710887));
        jPanel3.add((Component)jLabel7, new GridConstraints(12, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(12, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.changeLogTa = jTextArea = new JTextArea();
        jTextArea.setWrapStyleWord(true);
        ((Component)jTextArea).setBackground(new Color(-724752));
        jTextArea.setToolTipText("\u66f4\u65b0\u65e5\u5fd7..");
        jTextArea.setLineWrap(true);
        jPanel4.add((Component)jTextArea, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(230, 100), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(6, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(9, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(11, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel5).setBackground(new Color(-1));
        jPanel3.add((Component)jPanel5, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.setTokenBtn = jButton3 = new JButton();
        ((Component)jButton3).setBackground(new Color(-14308151));
        jButton3.setText("Setting");
        jPanel5.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(130, 30), null));
        this.formHelp = jLabel6 = new JLabel();
        jLabel6.setToolTipText("\u9700\u8981\u5e2e\u52a9\uff1f");
        jLabel6.setText("?         ");
        Font font8 = jLabel6.getFont();
        jLabel6.setFont(new Font(font8.getName(), 1, 22));
        ((Component)jLabel6).setForeground(new Color(-13369396));
        jPanel5.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel6).setBackground(new Color(-1));
        jPanel3.add((Component)jPanel6, new GridConstraints(5, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.projectCombo = jComboBox = new JComboBox();
        jPanel6.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, new Dimension(130, 30), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel7).setBackground(new Color(-1));
        jPanel3.add((Component)jPanel7, new GridConstraints(7, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.settingBtn = jButton2 = new JButton();
        jButton2.setText("Choose Path");
        jPanel7.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(130, 30), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel8).setBackground(new Color(-1));
        Font font9 = jPanel8.getFont();
        jPanel8.setFont(new Font(font9.getName(), font9.getStyle(), 16));
        jPanel8.setToolTipText("");
        jPanel3.add((Component)jPanel8, new GridConstraints(10, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.shortLink = jLabel5 = new JLabel();
        jLabel5.setToolTipText("\u70b9\u51fb\u67e5\u770b");
        jLabel5.setText("");
        Font font10 = jLabel5.getFont();
        jLabel5.setFont(new Font(font10.getName(), font10.getStyle(), 16));
        ((Component)jLabel5).setForeground(new Color(-16737895));
        jPanel8.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.apkPath = jLabel4 = new JLabel();
        jLabel4.setText("");
        Font font11 = jLabel4.getFont();
        jLabel4.setFont(new Font(font11.getName(), font11.getStyle(), 11));
        jPanel3.add((Component)jLabel4, new GridConstraints(8, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel9).setBackground(new Color(-1));
        jPanel3.add((Component)jPanel9, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel10).setBackground(new Color(-1));
        jPanel3.add((Component)jPanel10, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel11).setBackground(new Color(-1));
        jPanel3.add((Component)jPanel11, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel12).setBackground(new Color(-1));
        jPanel3.add((Component)jPanel12, new GridConstraints(13, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.formTipCB = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("");
        jCheckBox2.setToolTipText("\u68c0\u6d4b\u6587\u4ef6\u6539\u53d8\u662f\u5426\u63d0\u793a");
        jPanel12.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel12.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel13).setBackground(new Color(-1));
        jPanel3.add((Component)jPanel13, new GridConstraints(14, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.formUploadCB = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jCheckBox.setToolTipText("\u81ea\u52a8\u4e0a\u4f20\u529f\u80fd\uff0c\u5982\u679c\u9009\u4e2d\u53d1\u73b0\u6587\u4ef6\u6539\u53d8\u81ea\u5df1\u4f1a\u4e0a\u4f20");
        jPanel13.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel13.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel14).setBackground(new Color(-1));
        jPanel3.add((Component)jPanel14, new GridConstraints(15, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.formTip = jLabel3 = new JLabel();
        jLabel3.setToolTipText("\u68c0\u6d4b\u6587\u4ef6\u6539\u53d8\u662f\u5426\u63d0\u793a");
        jLabel3.setText("CHECK  TIP");
        jLabel3.setDisplayedMnemonic(' ');
        jLabel3.setDisplayedMnemonicIndex(6);
        Font font12 = jLabel3.getFont();
        jLabel3.setFont(new Font(font12.getName(), font12.getStyle(), 20));
        ((Component)jLabel3).setForeground(new Color(-6710887));
        jPanel3.add((Component)jLabel3, new GridConstraints(13, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.formUpload = jLabel2 = new JLabel();
        jLabel2.setToolTipText("\u81ea\u52a8\u4e0a\u4f20\u529f\u80fd\uff0c\u5982\u679c\u9009\u4e2d\u53d1\u73b0\u6587\u4ef6\u6539\u53d8\u81ea\u5df1\u4f1a\u4e0a\u4f20");
        jLabel2.setText("AUTO UPLOAD");
        Font font13 = jLabel2.getFont();
        jLabel2.setFont(new Font(font13.getName(), font13.getStyle(), 20));
        ((Component)jLabel2).setForeground(new Color(-6710887));
        jPanel3.add((Component)jLabel2, new GridConstraints(14, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new GridLayoutManager(6, 1, new Insets(20, 0, 20, 0), -1, -1, false, false));
        ((Component)jPanel15).setBackground(new Color(-1));
        jPanel.add((Component)jPanel15, "South");
        this.uploadBtn = jButton = new JButton();
        ((Component)jButton).setBackground(new Color(-14308151));
        jButton.setText("Upload");
        jPanel15.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 0, 3, 0, null, new Dimension(240, 45), null));
        this.progressBar = jProgressBar = new JProgressBar();
        jPanel15.add((Component)jProgressBar, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        this.tips = jLabel = new JLabel();
        jLabel.setText("Success");
        Font font14 = jLabel.getFont();
        jLabel.setFont(new Font(font14.getName(), font14.getStyle(), 18));
        ((Component)jLabel).setForeground(new Color(-52429));
        jPanel15.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel16).setBackground(new Color(-1));
        jPanel15.add((Component)jPanel16, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel17).setBackground(new Color(-1));
        jPanel15.add((Component)jPanel17, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel18).setBackground(new Color(-1));
        jPanel15.add((Component)jPanel18, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel1;
    }
}

