/*
 * Decompiled with CFR 0.152.
 */
package ro.catalin.prata.firuploader.provider;

import java.io.File;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import ro.catalin.prata.firuploader.Model.Binary;
import ro.catalin.prata.firuploader.Model.CustomMultiPartEntity;
import ro.catalin.prata.firuploader.utils.SearchFile;
import ro.catalin.prata.firuploader.utils.UploadToRio;
import ro.catalin.prata.firuploader.utils.Utils;
import ro.catalin.prata.firuploader.view.Main;

public class UploadService
implements CustomMultiPartEntity.ProgressListener {
    private UploadServiceDelegate uploadServiceDelegate;

    public void sendBuild(String url, final String filePath, final String apiToken, final Binary binary, final String appChanglog, UploadServiceDelegate delegate) {
        this.uploadServiceDelegate = delegate;
        new Thread(new Runnable(){

            @Override
            public void run() {
                block12: {
                    Main.getInstance().setTest("\u5f00\u59cb\u4e0a\u4f20....");
                    UploadToRio uploadToRio = new UploadToRio(binary.bundleId, apiToken, binary.name, binary.versionName, binary.versionCode, appChanglog);
                    String url = uploadToRio.uploadTicket.binaryUploadUrl;
                    try {
                        DefaultHttpClient client = new DefaultHttpClient();
                        HttpPost post = new HttpPost(url);
                        Main.getInstance().setShortLink("http://fir.im/" + uploadToRio.uploadTicket.appShort);
                        SearchFile searchFile = new SearchFile(filePath);
                        try {
                            if (!binary.icon.isEmpty()) {
                                InputStreamBody iconToUpload = searchFile.query(binary.icon);
                                CustomMultiPartEntity iconMultipartEntity = new CustomMultiPartEntity(UploadService.this);
                                iconMultipartEntity.addPart("key", (ContentBody)new StringBody(uploadToRio.uploadTicket.iconKey));
                                iconMultipartEntity.addPart("token", (ContentBody)new StringBody(uploadToRio.uploadTicket.iconToken));
                                iconMultipartEntity.addPart("file", (ContentBody)iconToUpload);
                                if (UploadService.this.uploadServiceDelegate != null) {
                                    UploadService.this.uploadServiceDelegate.onPackageSizeComputed(iconMultipartEntity.getContentLength());
                                }
                                post.setEntity((HttpEntity)iconMultipartEntity);
                                HttpResponse iconResponse = client.execute((HttpUriRequest)post);
                                HttpEntity iconEntity = iconResponse.getEntity();
                                String iconResponseString = EntityUtils.toString((HttpEntity)iconEntity, (String)"UTF-8");
                                System.out.println(iconResponseString);
                                Main.getInstance().setTest("kkkkkkkkkkkkkkkkkkk" + iconResponseString);
                                Main.getInstance().setTest("response.getStatusLine().getStatusCode()" + iconResponse.getStatusLine().getStatusCode());
                                JSONObject iconJsonObject = new JSONObject(iconResponseString);
                                if (iconResponse.getStatusLine().getStatusCode() == 200 && UploadService.this.uploadServiceDelegate != null) {
                                    Main.getInstance().setTips("Icon upload success");
                                }
                                Main.getInstance().setTest("\u4e0a\u4f20icon\u5b8c\u6210....");
                                searchFile.zipFile.close();
                            }
                        }
                        catch (Exception e) {
                            Utils.postErrorNoticeTOSlack(e);
                        }
                        File fileToUpload = new File(filePath);
                        CustomMultiPartEntity multipartEntity = new CustomMultiPartEntity(UploadService.this);
                        multipartEntity.addPart("key", (ContentBody)new StringBody(uploadToRio.uploadTicket.binaryKey));
                        multipartEntity.addPart("token", (ContentBody)new StringBody(uploadToRio.uploadTicket.binaryToken));
                        multipartEntity.addPart("file", (ContentBody)new FileBody(fileToUpload));
                        multipartEntity.addPart("x:name", (ContentBody)new StringBody(uploadToRio.appName, Charset.forName("UTF-8")));
                        multipartEntity.addPart("x:version", (ContentBody)new StringBody(uploadToRio.versionName, Charset.forName("UTF-8")));
                        multipartEntity.addPart("x:build", (ContentBody)new StringBody(uploadToRio.versionCode));
                        multipartEntity.addPart("x:changelog", (ContentBody)new StringBody(uploadToRio.changeLog, Charset.forName("UTF-8")));
                        if (UploadService.this.uploadServiceDelegate != null) {
                            UploadService.this.uploadServiceDelegate.onPackageSizeComputed(multipartEntity.getContentLength());
                        }
                        post.setEntity((HttpEntity)multipartEntity);
                        HttpResponse response = client.execute((HttpUriRequest)post);
                        HttpEntity entity = response.getEntity();
                        String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                        System.out.println(responseString);
                        Main.getInstance().setTest("kkkkkkkkkkkkkkkkkkk" + responseString);
                        Main.getInstance().setTest("response.getStatusLine().getStatusCode()" + response.getStatusLine().getStatusCode());
                        JSONObject jsonObject = new JSONObject(responseString);
                        if (response.getStatusLine().getStatusCode() == 200) {
                            if (UploadService.this.uploadServiceDelegate != null) {
                                UploadService.this.uploadServiceDelegate.onUploadFinished(true);
                            }
                        } else if (UploadService.this.uploadServiceDelegate != null) {
                            UploadService.this.uploadServiceDelegate.onUploadFinished(false);
                        }
                        Main.getInstance().setTest("\u4e0a\u4f20file\u5b8c\u6210....");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Main.getInstance().setTest("e" + e.getMessage());
                        Utils.postErrorNoticeTOSlack(e);
                        if (UploadService.this.uploadServiceDelegate == null) break block12;
                        UploadService.this.uploadServiceDelegate.onUploadFinished(false);
                    }
                }
            }
        }).start();
    }

    public void iconUpload() {
    }

    @Override
    public void transferred(long num) {
        if (this.uploadServiceDelegate != null) {
            this.uploadServiceDelegate.onProgressChanged(num);
        }
    }

    public static interface UploadServiceDelegate {
        public void onUploadFinished(boolean var1);

        public void onPackageSizeComputed(long var1);

        public void onProgressChanged(long var1);
    }
}

