/*
 * Decompiled with CFR 0.152.
 */
package ro.catalin.prata.firuploader.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import ro.catalin.prata.firuploader.Model.UploadTicket;
import ro.catalin.prata.firuploader.Model.UploadToken;
import ro.catalin.prata.firuploader.utils.Utils;

public class UploadToRio {
    public static final String FIR_UPLOAD_TOKEN_URL = "http://fir.im/api/v2/info/";
    public static final String FIR_UPDATE_APP_INFO = "http://fir.im/api/v2/app/";
    public static final String FIR_BASE_URL = "http://api.fir.im";
    public UploadToken uploadToken;
    public String versionId;
    public String token;
    public String appName;
    public String appId;
    public String versionName;
    public String versionCode;
    public String changeLog;
    public String appShort;
    public String appOid;
    public UploadTicket uploadTicket;

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public UploadToRio(String appId, String token, String appName, String versionName, String versionCode, String changeLog) {
        this.appId = appId;
        this.appName = appName;
        this.versionCode = versionCode;
        this.changeLog = changeLog;
        this.versionName = versionName;
        this.token = token;
        this.uploadTicket = new UploadTicket(this.getUploadToken());
    }

    public JSONObject getUploadToken() {
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            String url = "http://api.fir.im/apps";
            String type = "android";
            HttpPost post = new HttpPost(url);
            ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
            postParameters.add(new BasicNameValuePair("type", type));
            postParameters.add(new BasicNameValuePair("bundle_id", this.appId));
            postParameters.add(new BasicNameValuePair("api_token", this.token));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, "UTF-8"));
            HttpResponse response = null;
            response = httpClient.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            System.out.println(responseString);
            JSONObject jo = new JSONObject(responseString);
            return jo;
        }
        catch (UnsupportedEncodingException e) {
            Utils.postErrorNoticeTOSlack(e);
            e.printStackTrace();
        }
        catch (IOException e) {
            Utils.postErrorNoticeTOSlack(e);
            e.printStackTrace();
        }
        catch (JSONException e) {
            Utils.postErrorNoticeTOSlack((Exception)((Object)e));
            e.printStackTrace();
        }
        return new JSONObject();
    }

    public JSONObject uploadBinary() {
        return new JSONObject();
    }

    public JSONObject uploadIcon() {
        return new JSONObject();
    }
}

