/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import net.dongliu.apk.parser.bean.Locales;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.parser.XmlStreamer;
import net.dongliu.apk.parser.struct.ChunkHeader;
import net.dongliu.apk.parser.struct.StringPool;
import net.dongliu.apk.parser.struct.StringPoolHeader;
import net.dongliu.apk.parser.struct.xml.Attribute;
import net.dongliu.apk.parser.struct.xml.XmlCData;
import net.dongliu.apk.parser.struct.xml.XmlHeader;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceStartTag;
import net.dongliu.apk.parser.struct.xml.XmlNodeEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNodeHeader;
import net.dongliu.apk.parser.struct.xml.XmlNodeStartTag;
import net.dongliu.apk.parser.struct.xml.XmlResourceMapHeader;
import net.dongliu.apk.parser.utils.Buffers;
import net.dongliu.apk.parser.utils.ParseUtils;

public class BinaryXmlParser {
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private StringPool stringPool;
    private String[] resourceMap;
    private ByteBuffer buffer;
    private XmlStreamer xmlStreamer;
    private Locale locale = Locales.any;

    public BinaryXmlParser(ByteBuffer buffer) {
        this.buffer = buffer.duplicate();
        this.buffer.order(this.byteOrder);
    }

    public void parse() {
        ChunkHeader chunkHeader = this.readChunkHeader();
        if (chunkHeader.chunkType != 3) {
            return;
        }
        XmlHeader xmlHeader = (XmlHeader)chunkHeader;
        chunkHeader = this.readChunkHeader();
        ParseUtils.checkChunkType(1, chunkHeader.chunkType);
        this.stringPool = ParseUtils.readStringPool(this.buffer, (StringPoolHeader)chunkHeader);
        chunkHeader = this.readChunkHeader();
        if (chunkHeader.chunkType == 384) {
            long[] resourceIds = this.readXmlResourceMap((XmlResourceMapHeader)chunkHeader);
            this.resourceMap = new String[resourceIds.length];
            for (int i = 0; i < resourceIds.length; ++i) {
                this.resourceMap[i] = Attribute.AttrIds.getString(resourceIds[i]);
            }
            chunkHeader = this.readChunkHeader();
        }
        while (chunkHeader != null) {
            long beginPos = this.buffer.position();
            switch (chunkHeader.chunkType) {
                case 257: {
                    XmlNamespaceEndTag xmlNamespaceEndTag = this.readXmlNamespaceEndTag();
                    this.xmlStreamer.onNamespaceEnd(xmlNamespaceEndTag);
                    break;
                }
                case 256: {
                    XmlNamespaceStartTag namespaceStartTag = this.readXmlNamespaceStartTag();
                    this.xmlStreamer.onNamespaceStart(namespaceStartTag);
                    break;
                }
                case 258: {
                    XmlNodeStartTag xmlNodeStartTag = this.readXmlNodeStartTag();
                    break;
                }
                case 259: {
                    XmlNodeEndTag xmlNodeEndTag = this.readXmlNodeEndTag();
                    break;
                }
                case 260: {
                    XmlCData xmlCData = this.readXmlCData();
                    break;
                }
                default: {
                    if (chunkHeader.chunkType >= 256 && chunkHeader.chunkType <= 383) {
                        Buffers.skip(this.buffer, (int)(chunkHeader.chunkSize - (long)chunkHeader.headerSize));
                        break;
                    }
                    throw new ParserException("Unexpected chunk type:" + chunkHeader.chunkType);
                }
            }
            this.buffer.position((int)(beginPos + chunkHeader.chunkSize - (long)chunkHeader.headerSize));
            chunkHeader = this.readChunkHeader();
        }
    }

    private XmlCData readXmlCData() {
        XmlCData xmlCData = new XmlCData();
        int dataRef = this.buffer.getInt();
        if (dataRef > 0) {
            xmlCData.data = this.stringPool.get(dataRef);
        }
        xmlCData.typedData = ParseUtils.readResValue(this.buffer, this.stringPool);
        if (this.xmlStreamer != null) {
            // empty if block
        }
        return xmlCData;
    }

    private XmlNodeEndTag readXmlNodeEndTag() {
        XmlNodeEndTag xmlNodeEndTag = new XmlNodeEndTag();
        int nsRef = this.buffer.getInt();
        int nameRef = this.buffer.getInt();
        if (nsRef > 0) {
            xmlNodeEndTag.namespace = this.stringPool.get(nsRef);
        }
        xmlNodeEndTag.name = this.stringPool.get(nameRef);
        if (this.xmlStreamer != null) {
            this.xmlStreamer.onEndTag(xmlNodeEndTag);
        }
        return xmlNodeEndTag;
    }

    private XmlNodeStartTag readXmlNodeStartTag() {
        int nsRef = this.buffer.getInt();
        int nameRef = this.buffer.getInt();
        XmlNodeStartTag xmlNodeStartTag = new XmlNodeStartTag();
        if (nsRef > 0) {
            xmlNodeStartTag.namespace = this.stringPool.get(nsRef);
        }
        xmlNodeStartTag.name = this.stringPool.get(nameRef);
        if (this.xmlStreamer != null) {
            this.xmlStreamer.onStartTag(xmlNodeStartTag);
        }
        int attributeStart = Buffers.readUShort(this.buffer);
        int attributeSize = Buffers.readUShort(this.buffer);
        int attributeCount = Buffers.readUShort(this.buffer);
        int idIndex = Buffers.readUShort(this.buffer);
        int classIndex = Buffers.readUShort(this.buffer);
        int styleIndex = Buffers.readUShort(this.buffer);
        for (int count = 0; count < attributeCount; ++count) {
            Attribute attribute = this.readAttribute();
            if (this.xmlStreamer == null) continue;
            this.xmlStreamer.onAttribute(attribute);
        }
        return xmlNodeStartTag;
    }

    private Attribute readAttribute() {
        int rawValueRef;
        int nsRef = this.buffer.getInt();
        int nameRef = this.buffer.getInt();
        Attribute attribute = new Attribute();
        if (nsRef > 0) {
            attribute.namespace = this.stringPool.get(nsRef);
        }
        attribute.name = this.stringPool.get(nameRef);
        if (attribute.name.isEmpty() && this.resourceMap != null && nameRef < this.resourceMap.length) {
            attribute.name = this.resourceMap[nameRef];
        }
        if ((rawValueRef = this.buffer.getInt()) > 0) {
            attribute.rawValue = this.stringPool.get(rawValueRef);
        }
        attribute.typedValue = ParseUtils.readResValue(this.buffer, this.stringPool, "style".equals(attribute.name) || "theme".equals(attribute.name));
        return attribute;
    }

    private XmlNamespaceStartTag readXmlNamespaceStartTag() {
        int prefixRef = this.buffer.getInt();
        int uriRef = this.buffer.getInt();
        XmlNamespaceStartTag nameSpace = new XmlNamespaceStartTag();
        if (prefixRef > 0) {
            nameSpace.prefix = this.stringPool.get(prefixRef);
        }
        if (uriRef > 0) {
            nameSpace.uri = this.stringPool.get(uriRef);
        }
        return nameSpace;
    }

    private XmlNamespaceEndTag readXmlNamespaceEndTag() {
        int prefixRef = this.buffer.getInt();
        int uriRef = this.buffer.getInt();
        XmlNamespaceEndTag nameSpace = new XmlNamespaceEndTag();
        if (prefixRef > 0) {
            nameSpace.prefix = this.stringPool.get(prefixRef);
        }
        if (uriRef > 0) {
            nameSpace.uri = this.stringPool.get(uriRef);
        }
        return nameSpace;
    }

    private long[] readXmlResourceMap(XmlResourceMapHeader chunkHeader) {
        int count = (int)((chunkHeader.chunkSize - (long)chunkHeader.headerSize) / 4L);
        long[] resourceIds = new long[count];
        for (int i = 0; i < count; ++i) {
            resourceIds[i] = Buffers.readUInt(this.buffer);
        }
        return resourceIds;
    }

    private ChunkHeader readChunkHeader() {
        if (!this.buffer.hasRemaining()) {
            return null;
        }
        long begin = this.buffer.position();
        int chunkType = Buffers.readUShort(this.buffer);
        int headerSize = Buffers.readUShort(this.buffer);
        long chunkSize = Buffers.readUInt(this.buffer);
        switch (chunkType) {
            case 3: {
                return new XmlHeader(chunkType, headerSize, chunkSize);
            }
            case 1: {
                StringPoolHeader stringPoolHeader = new StringPoolHeader(chunkType, headerSize, chunkSize);
                stringPoolHeader.stringCount = Buffers.readUInt(this.buffer);
                stringPoolHeader.styleCount = Buffers.readUInt(this.buffer);
                stringPoolHeader.flags = Buffers.readUInt(this.buffer);
                stringPoolHeader.stringsStart = Buffers.readUInt(this.buffer);
                stringPoolHeader.stylesStart = Buffers.readUInt(this.buffer);
                this.buffer.position((int)(begin + (long)headerSize));
                return stringPoolHeader;
            }
            case 384: {
                this.buffer.position((int)(begin + (long)headerSize));
                return new XmlResourceMapHeader(chunkType, headerSize, chunkSize);
            }
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: {
                XmlNodeHeader header = new XmlNodeHeader(chunkType, headerSize, chunkSize);
                header.lineNum = (int)Buffers.readUInt(this.buffer);
                header.commentRef = (int)Buffers.readUInt(this.buffer);
                this.buffer.position((int)(begin + (long)headerSize));
                return header;
            }
        }
        throw new ParserException("Unexpected chunk type:" + chunkType);
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public XmlStreamer getXmlStreamer() {
        return this.xmlStreamer;
    }

    public void setXmlStreamer(XmlStreamer xmlStreamer) {
        this.xmlStreamer = xmlStreamer;
    }
}

