/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import net.dongliu.apk.parser.bean.CertificateMeta;
import net.dongliu.apk.parser.utils.Utils;
import org.apache.commons.compress.utils.Charsets;
import sun.security.pkcs.PKCS7;

public class CertificateParser {
    private InputStream in;
    private List<CertificateMeta> certificateMetas;

    public CertificateParser(InputStream in) {
        this.in = new BufferedInputStream(in);
    }

    public void parse() throws IOException, CertificateEncodingException {
        PKCS7 pkcs7 = new PKCS7(Utils.toByteArray(this.in));
        X509Certificate[] certificates = pkcs7.getCertificates();
        this.certificateMetas = new ArrayList<CertificateMeta>();
        for (X509Certificate certificate : certificates) {
            CertificateMeta certificateMeta = new CertificateMeta();
            this.certificateMetas.add(certificateMeta);
            byte[] bytes = certificate.getEncoded();
            String certMd5 = this.md5Digest(bytes);
            String publicKeyString = this.byteToHexString(bytes);
            String certBase64Md5 = this.md5Digest(publicKeyString);
            certificateMeta.setData(bytes);
            certificateMeta.setCertBase64Md5(certBase64Md5);
            certificateMeta.setCertMd5(certMd5);
            certificateMeta.setStartDate(certificate.getNotBefore());
            certificateMeta.setEndDate(certificate.getNotAfter());
            certificateMeta.setSignAlgorithm(certificate.getSigAlgName());
            certificateMeta.setSignAlgorithmOID(certificate.getSigAlgOID());
        }
    }

    private String md5Digest(byte[] input) throws IOException {
        MessageDigest digest = this.getDigest("Md5");
        digest.update(input);
        return this.getHexString(digest.digest());
    }

    private String md5Digest(String input) throws IOException {
        MessageDigest digest = this.getDigest("Md5");
        digest.update(input.getBytes(Charsets.UTF_8));
        return this.getHexString(digest.digest());
    }

    private String byteToHexString(byte[] bArray) {
        StringBuilder sb = new StringBuilder(bArray.length);
        for (byte aBArray : bArray) {
            String sTemp = Integer.toHexString(0xFF & (char)aBArray);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    private String getHexString(byte[] digest) {
        BigInteger bi = new BigInteger(1, digest);
        return String.format("%032x", bi);
    }

    private MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public List<CertificateMeta> getCertificateMetas() {
        return this.certificateMetas;
    }
}

