/*
 * Decompiled with CFR 0.152.
 */
package ro.catalin.prata.firuploader.controller;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.PsiClass;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;

public class ModulesManager {
    public static final String ANDROID_VERSION_CODE = "android:versionCode";
    public static final String ANDROID_VERSION_NAME = "android:versionName";
    public static final String ANDROID_APP_ID = "package";
    public static final String ANDROID_APP_NAME = "android:label";
    private static ModulesManager sInstance = null;

    private ModulesManager() {
    }

    public static ModulesManager instance() {
        if (sInstance == null) {
            sInstance = new ModulesManager();
        }
        return sInstance;
    }

    public String getAndroidApkPath(Module module) {
        if (module == null || AndroidFacet.getInstance((Module)module) == null) {
            return null;
        }
        return AndroidRootUtil.getApkPath((AndroidFacet)AndroidFacet.getInstance((Module)module));
    }

    public String getAndroidManifestPath(Module module) {
        if (module == null || AndroidFacet.getInstance((Module)module) == null) {
            return null;
        }
        return AndroidRootUtil.getManifestFile((AndroidFacet)AndroidFacet.getInstance((Module)module)).getPath();
    }

    public String[] getAllModuleNames() {
        Module[] modules = this.getModules();
        if (modules == null) {
            return null;
        }
        String[] moduleNames = new String[modules.length];
        int index = 0;
        for (Module module : modules) {
            moduleNames[index] = module.getName();
            ++index;
        }
        return moduleNames;
    }

    public Module[] getModules() {
        Module[] modules = ModuleManager.getInstance((Project)ProjectManager.getInstance().getOpenProjects()[0]).getSortedModules();
        Module[] sortedModules = new Module[modules.length];
        int reverseIndex = modules.length - 1;
        for (int index = 0; index < modules.length; ++index) {
            sortedModules[index] = modules[reverseIndex];
            --reverseIndex;
        }
        return sortedModules;
    }

    public int getSelectedModuleIndex(String moduleName) {
        Module[] modules = this.getModules();
        if (modules == null || moduleName == null) {
            return 0;
        }
        int index = 0;
        for (Module module : modules) {
            if (module.getName().equals(moduleName)) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    public Module getMostImportantModule() {
        Module[] modules = this.getModules();
        if (modules == null) {
            return null;
        }
        return modules[0];
    }

    public Module getModuleByName(String moduleName) {
        Module[] modules = this.getModulesForProject(ProjectManager.getInstance().getOpenProjects()[0]);
        if (modules == null) {
            return null;
        }
        for (Module module : modules) {
            if (!module.getName().equals(moduleName)) continue;
            return module;
        }
        return null;
    }

    @Deprecated
    public String[] getAllModuleNamesForCurrentProject(Project project) {
        Module[] modules = this.getModulesForProject(project);
        String[] moduleNames = new String[modules.length];
        int index = 0;
        for (Module module : modules) {
            moduleNames[index] = module.getName();
            ++index;
        }
        return moduleNames;
    }

    @Deprecated
    public Module[] getModulesForProject(Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getSortedModules();
        Module[] sortedModules = new Module[modules.length];
        int reverseIndex = modules.length - 1;
        for (int index = 0; index < modules.length; ++index) {
            sortedModules[index] = modules[reverseIndex];
            --reverseIndex;
        }
        return sortedModules;
    }

    @Deprecated
    public int getSelectedModuleIndexForProject(String moduleName, Project project) {
        Module[] modules = this.getModulesForProject(project);
        if (modules == null) {
            return 0;
        }
        int index = 0;
        for (Module module : modules) {
            if (module.getName().equals(moduleName)) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    @Deprecated
    public Module getModuleByName(String moduleName, Project project) {
        Module[] modules = this.getModulesForProject(project);
        if (modules == null) {
            return null;
        }
        for (Module module : modules) {
            if (!module.getName().equals(moduleName)) continue;
            return module;
        }
        return null;
    }

    @Deprecated
    public Module getMostImportantModuleForProject(Project project) {
        Module[] modules = this.getModulesForProject(project);
        if (modules == null) {
            return null;
        }
        return modules[modules.length - 1];
    }

    public Manifest getManifestForModule(Module module) {
        if (module == null || AndroidFacet.getInstance((Module)module) == null) {
            return null;
        }
        return AndroidFacet.getInstance((Module)module).getManifest();
    }

    public String getBuildVersionName(Manifest manifest) {
        if (manifest == null || manifest.getXmlTag() == null || manifest.getXmlTag().getAttribute(ANDROID_VERSION_NAME) == null) {
            return null;
        }
        return manifest.getXmlTag().getAttribute(ANDROID_VERSION_NAME).getValue();
    }

    public String getAppId(Manifest manifest) {
        if (manifest == null || manifest.getXmlTag() == null || manifest.getXmlTag().getAttribute(ANDROID_APP_ID) == null) {
            return null;
        }
        return manifest.getXmlTag().getAttribute(ANDROID_APP_ID).getValue();
    }

    public String getAndroidAppName(Manifest manifest) {
        if (manifest == null || manifest.getXmlTag() == null || manifest.getXmlTag().getAttribute(ANDROID_APP_NAME) == null) {
            return null;
        }
        if (manifest != null && manifest.getApplication() != null && manifest.getApplication().getName() != null) {
            AndroidAttributeValue t = manifest.getApplication().getName();
            if (t != null) {
                PsiClass valur = (PsiClass)t.getValue();
                if (valur != null) {
                    String name = valur.getName();
                    return name;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private void setBuildVersionName(Manifest manifest, String newValue) {
        if (manifest != null && newValue != null && manifest.getXmlTag() != null && manifest.getXmlTag().getAttribute(ANDROID_VERSION_NAME) != null) {
            manifest.getXmlTag().getAttribute(ANDROID_VERSION_NAME).setValue(newValue);
        }
    }

    public void setBuildVersionNameAndCode(final Manifest manifest, final String newVersionNameValue, final String newVersionCodeValue, final ManifestChangesDelegate delegate) {
        if (manifest == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ModulesManager.this.setBuildVersionName(manifest, newVersionNameValue);
                ModulesManager.this.setBuildVersionCode(manifest, newVersionCodeValue);
                if (delegate != null) {
                    delegate.onVersionValueFinishedUpdate();
                }
            }
        });
    }

    private void setBuildVersionCode(Manifest manifest, String newValue) {
        if (manifest != null && newValue != null && manifest.getXmlTag() != null && manifest.getXmlTag().getAttribute(ANDROID_VERSION_CODE) != null) {
            manifest.getXmlTag().getAttribute(ANDROID_VERSION_CODE).setValue(newValue);
        }
    }

    public String getBuildVersionCode(Manifest manifest) {
        if (manifest == null || manifest.getXmlTag() == null || manifest.getXmlTag().getAttribute(ANDROID_VERSION_CODE) == null) {
            return null;
        }
        return manifest.getXmlTag().getAttribute(ANDROID_VERSION_CODE).getValue();
    }

    public Project[] getOpenedProjects() {
        return ProjectManager.getInstance().getOpenProjects();
    }

    public String[] getOpenedProjectsNames() {
        Project[] projects = this.getOpenedProjects();
        String[] projectsNames = new String[projects.length];
        int index = 0;
        for (Project project : projects) {
            projectsNames[index] = project.getName();
            ++index;
        }
        return projectsNames;
    }

    public Project getProjectByName(String name) {
        Project[] projects;
        if (name == null) {
            return null;
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            if (!project.getName().equals(name)) continue;
            return project;
        }
        return null;
    }

    public int getProjectIndexWithName(String name) {
        Project[] projects;
        int index = 0;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            if (project.getName().equals(name)) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    public static interface ManifestChangesDelegate {
        public void onVersionValueFinishedUpdate();
    }
}

