/*
 * Decompiled with CFR 0.152.
 */
package ro.catalin.prata.firuploader.utils;

import android.content.res.AXmlResourceParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import ro.catalin.prata.firuploader.utils.Utils;

public class AnalysisApk {
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.051758E-5f, 1.192093E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNITS = new String[]{"px", "dip", "sp", "pt", "in", "mm", "", ""};
    private static final String[] FRACTION_UNITS = new String[]{"%", "%p", "", "", "", "", "", ""};

    public static String[] unZip(String apkUrl, String logoUrl) {
        String[] st = new String[3];
        byte[] b = new byte[1024];
        try {
            ZipFile zipFile = new ZipFile(new File(apkUrl));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ZipEntry zipEntry = null;
            while (enumeration.hasMoreElements()) {
                int length;
                zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                if ("AndroidManifest.xml".equals(zipEntry.getName())) {
                    try {
                        int type;
                        AXmlResourceParser parser = new AXmlResourceParser();
                        parser.open(zipFile.getInputStream(zipEntry));
                        while ((type = parser.next()) != 1) {
                            switch (type) {
                                case 2: {
                                    for (int i = 0; i != parser.getAttributeCount(); ++i) {
                                        if ("versionName".equals(parser.getAttributeName(i))) {
                                            st[0] = AnalysisApk.getAttributeValue(parser, i);
                                            continue;
                                        }
                                        if ("package".equals(parser.getAttributeName(i))) {
                                            st[1] = AnalysisApk.getAttributeValue(parser, i);
                                            continue;
                                        }
                                        if (!"versionCode".equals(parser.getAttributeName(i))) continue;
                                        st[2] = AnalysisApk.getAttributeValue(parser, i);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Utils.postErrorNoticeTOSlack(e);
                        e.printStackTrace();
                    }
                }
                if (!"res/drawable-ldpi/icon.png".equals(zipEntry.getName())) continue;
                FileOutputStream outputStream = new FileOutputStream(logoUrl);
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                while ((length = inputStream.read(b)) > 0) {
                    ((OutputStream)outputStream).write(b, 0, length);
                }
            }
            zipFile.close();
        }
        catch (IOException e) {
            Utils.postErrorNoticeTOSlack(e);
        }
        return st;
    }

    private static String getAttributeValue(AXmlResourceParser parser, int index) {
        int type = parser.getAttributeValueType(index);
        int data = parser.getAttributeValueData(index);
        if (type == 3) {
            return parser.getAttributeValue(index);
        }
        if (type == 2) {
            return String.format("?%s%08X", AnalysisApk.getPackage(data), data);
        }
        if (type == 1) {
            return String.format("@%s%08X", AnalysisApk.getPackage(data), data);
        }
        if (type == 4) {
            return String.valueOf(Float.intBitsToFloat(data));
        }
        if (type == 17) {
            return String.format("0x%08X", data);
        }
        if (type == 18) {
            return data != 0 ? "true" : "false";
        }
        if (type == 5) {
            return Float.toString(AnalysisApk.complexToFloat(data)) + DIMENSION_UNITS[data & 0xF];
        }
        if (type == 6) {
            return Float.toString(AnalysisApk.complexToFloat(data)) + FRACTION_UNITS[data & 0xF];
        }
        if (type >= 28 && type <= 31) {
            return String.format("#%08X", data);
        }
        if (type >= 16 && type <= 31) {
            return String.valueOf(data);
        }
        return String.format("<0x%X, type 0x%02X>", data, type);
    }

    private static String getPackage(int id) {
        if (id >>> 24 == 1) {
            return "android:";
        }
        return "";
    }

    public static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }
}

