/*
 * Decompiled with CFR 0.152.
 */
package ro.catalin.prata.firuploader.apkReader;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;

public class ApkInfo {
    public static int FINE = 0;
    public static int NULL_VERSION_CODE = 1;
    public static int NULL_VERSION_NAME = 2;
    public static int NULL_PERMISSION = 3;
    public static int NULL_ICON = 4;
    public static int NULL_CERT_FILE = 5;
    public static int BAD_CERT = 6;
    public static int NULL_SF_FILE = 7;
    public static int BAD_SF = 8;
    public static int NULL_MANIFEST = 9;
    public static int NULL_RESOURCES = 10;
    public static int NULL_DEX = 13;
    public static int NULL_METAINFO = 14;
    public static int BAD_JAR = 11;
    public static int BAD_READ_INFO = 12;
    public static int NULL_FILE = 15;
    public static int HAS_REF = 16;
    public String rawAndroidManifest;
    public List<String> dexClassName = new ArrayList<String>();
    public List<String> dexUrls = new ArrayList<String>();
    public String label;
    public String fileHash;
    public String versionName = null;
    public String versionCode = null;
    public String minSdkVersion;
    public String targetSdkVersion;
    public String packageName;
    public List<String> Permissions = new ArrayList<String>();
    public List<String> iconFileName = null;
    public List<String> iconFileNameToGet = null;
    public List<String> iconHash;
    public String rsaCertFileName = null;
    public byte[] rsaCertFileBytes;
    public String sfCertFileName = null;
    public byte[] sfCertFileBytes;
    public String mfCertFileName = null;
    public byte[] mfcCertFileBytes;
    public String manifestFileName;
    public byte[] manifestFileBytes;
    public boolean hasIcon = false;
    public boolean supportSmallScreens = false;
    public boolean supportNormalScreens = false;
    public boolean supportLargeScreens = false;
    public boolean supportAnyDensity = true;
    public Map<String, ArrayList<String>> resStrings;
    public Map<String, String> layoutStrings;
    public Hashtable<String, JarEntry> entryList = new Hashtable();

    public static boolean supportSmallScreen(byte[] dpi) {
        return dpi[0] == 1;
    }

    public static boolean supportNormalScreen(byte[] dpi) {
        return dpi[1] == 1;
    }

    public static boolean supportLargeScreen(byte[] dpi) {
        return dpi[2] == 1;
    }

    public byte[] getDPI() {
        byte[] dpi = new byte[3];
        if (this.supportAnyDensity) {
            dpi[0] = 1;
            dpi[1] = 1;
            dpi[2] = 1;
        } else {
            if (this.supportSmallScreens) {
                dpi[0] = 1;
            }
            if (this.supportNormalScreens) {
                dpi[1] = 1;
            }
            if (this.supportLargeScreens) {
                dpi[2] = 1;
            }
        }
        return dpi;
    }

    public String toString() {
        String ret = "versionCode\t" + this.versionCode + "\r\n" + "versionName\t" + this.versionName + "\r\n" + "Permissions\t" + this.Permissions + "\r\n" + "iconFileName\t" + this.iconFileName + "\r\n" + "iconName\t" + this.iconFileNameToGet + "\r\n" + "manifestFileName\t" + this.manifestFileName + "\r\n" + "layoutStrings\t" + (this.layoutStrings == null ? "" : String.valueOf(this.layoutStrings.size())) + "\r\n" + "resStrings\t" + (this.resStrings == null ? "" : String.valueOf(this.resStrings.size())) + "\r\n";
        return ret;
    }

    private boolean isReference(List<String> strs) {
        try {
            for (String str : strs) {
                if (!this.isReference(str)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isReference(String str) {
        try {
            if (str != null && str.startsWith("@")) {
                Integer.valueOf(str, 16);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean hasReference() {
        return this.isReference(this.versionCode) || this.isReference(this.versionName) || this.isReference(this.iconFileNameToGet);
    }

    public int isValid() {
        if (this.hasReference()) {
            return HAS_REF;
        }
        if (this.versionCode == null) {
            return NULL_VERSION_CODE;
        }
        if (this.versionName == null) {
            return NULL_VERSION_NAME;
        }
        if (this.Permissions == null) {
            return NULL_PERMISSION;
        }
        if (this.iconFileName == null) {
            return NULL_ICON;
        }
        if (this.iconFileNameToGet == null) {
            return NULL_ICON;
        }
        if (!this.hasIcon) {
            return NULL_ICON;
        }
        return FINE;
    }
}

