/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3264;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModNioResourcePack
extends class_3255
implements ModResourcePack {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModNioResourcePack.class);
    private static final Pattern RESOURCE_PACK_PATH = Pattern.compile("[a-z0-9-_.]+");
    private final String name;
    private final ModMetadata modInfo;
    private final List<Path> basePaths;
    private final class_3264 type;
    private final AutoCloseable closer;
    private final ResourcePackActivationType activationType;
    private final Map<class_3264, Set<String>> namespaces;
    private static final String resPrefix = class_3264.field_14188.method_14413() + "/";
    private static final String dataPrefix = class_3264.field_14190.method_14413() + "/";

    public static ModNioResourcePack create(String name, ModContainer mod, String subPath, class_3264 type, ResourcePackActivationType activationType) {
        ArrayList<Path> paths;
        ArrayList<Path> rootPaths = mod.getRootPaths();
        if (subPath == null) {
            paths = rootPaths;
        } else {
            paths = new ArrayList<Path>(rootPaths.size());
            for (Path path : rootPaths) {
                Path childPath = (path = path.toAbsolutePath().normalize()).resolve(subPath.replace("/", path.getFileSystem().getSeparator())).normalize();
                if (!childPath.startsWith(path) || !Files.exists(childPath, new LinkOption[0])) continue;
                paths.add(childPath);
            }
        }
        if (paths.isEmpty()) {
            return null;
        }
        ModNioResourcePack ret = new ModNioResourcePack(name, mod.getMetadata(), paths, type, null, activationType);
        return ret.method_14406(type).isEmpty() ? null : ret;
    }

    private ModNioResourcePack(String name, ModMetadata modInfo, List<Path> paths, class_3264 type, AutoCloseable closer, ResourcePackActivationType activationType) {
        super(null);
        this.name = name;
        this.modInfo = modInfo;
        this.basePaths = paths;
        this.type = type;
        this.closer = closer;
        this.activationType = activationType;
        this.namespaces = ModNioResourcePack.readNamespaces(paths, modInfo.getId());
    }

    private static Map<class_3264, Set<String>> readNamespaces(List<Path> paths, String modId) {
        EnumMap<class_3264, Set<String>> ret = new EnumMap<class_3264, Set<String>>(class_3264.class);
        for (class_3264 type : class_3264.values()) {
            Set namespaces = null;
            for (Path path : paths) {
                Path dir = path.resolve(type.method_14413());
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                String separator = path.getFileSystem().getSeparator();
                try {
                    DirectoryStream<Path> ds = Files.newDirectoryStream(dir);
                    try {
                        for (Path p : ds) {
                            if (!Files.isDirectory(p, new LinkOption[0])) continue;
                            String s = p.getFileName().toString();
                            if (!RESOURCE_PACK_PATH.matcher(s = s.replace(separator, "")).matches()) {
                                LOGGER.warn("Fabric NioResourcePack: ignored invalid namespace: {} in mod ID {}", (Object)s, (Object)modId);
                                continue;
                            }
                            if (namespaces == null) {
                                namespaces = new HashSet();
                            }
                            namespaces.add(s);
                        }
                    }
                    finally {
                        if (ds == null) continue;
                        ds.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("getNamespaces in mod " + modId + " failed!", (Throwable)e);
                }
            }
            ret.put(type, namespaces != null ? namespaces : Collections.emptySet());
        }
        return ret;
    }

    private Path getPath(String filename) {
        if (this.hasAbsentNs(filename)) {
            return null;
        }
        for (Path basePath : this.basePaths) {
            Path childPath = basePath.resolve(filename.replace("/", basePath.getFileSystem().getSeparator())).toAbsolutePath().normalize();
            if (!childPath.startsWith(basePath) || !Files.exists(childPath, new LinkOption[0])) continue;
            return childPath;
        }
        return null;
    }

    private boolean hasAbsentNs(String filename) {
        class_3264 type;
        int prefixLen;
        if (filename.startsWith(resPrefix)) {
            prefixLen = resPrefix.length();
            type = class_3264.field_14188;
        } else if (filename.startsWith(dataPrefix)) {
            prefixLen = dataPrefix.length();
            type = class_3264.field_14190;
        } else {
            return false;
        }
        int nsEnd = filename.indexOf(47, prefixLen);
        if (nsEnd < 0) {
            return false;
        }
        return !this.namespaces.get(type).contains(filename.substring(prefixLen, nsEnd));
    }

    protected InputStream method_14391(String filename) throws IOException {
        Path path = this.getPath(filename);
        if (path != null && Files.isRegularFile(path, new LinkOption[0])) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        InputStream stream = ModResourcePackUtil.openDefault(this.modInfo, this.type, filename);
        if (stream != null) {
            return stream;
        }
        throw new FileNotFoundException("\"" + filename + "\" in Fabric mod \"" + this.modInfo.getId() + "\"");
    }

    protected boolean method_14393(String filename) {
        if (ModResourcePackUtil.containsDefault(this.modInfo, filename)) {
            return true;
        }
        Path path = this.getPath(filename);
        return path != null && Files.isRegularFile(path, new LinkOption[0]);
    }

    public Collection<class_2960> method_14408(class_3264 type, final String namespace, String path, int depth, final Predicate<String> predicate) {
        if (!this.namespaces.getOrDefault(type, Collections.emptySet()).contains(namespace)) {
            return Collections.emptyList();
        }
        final ArrayList<class_2960> ids = new ArrayList<class_2960>();
        for (Path basePath : this.basePaths) {
            final String separator = basePath.getFileSystem().getSeparator();
            final Path nsPath = basePath.resolve(type.method_14413()).resolve(namespace);
            Path searchPath = nsPath.resolve(path.replace("/", separator)).normalize();
            if (!Files.exists(searchPath, new LinkOption[0])) continue;
            try {
                Files.walkFileTree(searchPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String fileName = file.getFileName().toString();
                        if (!fileName.endsWith(".mcmeta") && predicate.test(fileName)) {
                            try {
                                ids.add(new class_2960(namespace, nsPath.relativize(file).toString().replace(separator, "/")));
                            }
                            catch (class_151 e) {
                                LOGGER.error(e.getMessage());
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOGGER.warn("findResources at " + path + " in namespace " + namespace + ", mod " + this.modInfo.getId() + " failed!", (Throwable)e);
            }
        }
        return ids;
    }

    public Set<String> method_14406(class_3264 type) {
        return this.namespaces.getOrDefault(type, Collections.emptySet());
    }

    public void close() {
        if (this.closer != null) {
            try {
                this.closer.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public ModMetadata getFabricModMetadata() {
        return this.modInfo;
    }

    public ResourcePackActivationType getActivationType() {
        return this.activationType;
    }

    public String method_14409() {
        return this.name;
    }
}

