/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.Palette;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;

public final class FixedWidthFontRenderer {
    public static final int FONT_HEIGHT = 9;
    public static final int FONT_WIDTH = 6;
    public static final float WIDTH = 256.0f;
    public static final float BACKGROUND_START = 0.9765625f;
    public static final float BACKGROUND_END = 0.984375f;
    public static final float Z_EPSILON = 0.001f;

    private FixedWidthFontRenderer() {
    }

    public static float toGreyscale(double[] rgb) {
        return (float)((rgb[0] + rgb[1] + rgb[2]) / 3.0);
    }

    public static int getColour(char c, Colour def) {
        return 15 - Terminal.getColour(c, def);
    }

    private static void drawChar(class_4587 transform, class_4588 buffer, float x, float y, int index, float r, float g, float b, int light) {
        if (index == 0 || index == 32) {
            return;
        }
        int column = index % 16;
        int row = index / 16;
        int xStart = 1 + column * 8;
        int yStart = 1 + row * 11;
        class_1159 matrix = transform.method_23760().method_23761();
        class_4581 normalMatrix = transform.method_23760().method_23762();
        FixedWidthFontRenderer.vertex(matrix, normalMatrix, buffer, x, y, 0.001f, r, g, b, (float)xStart / 256.0f, (float)yStart / 256.0f, light);
        FixedWidthFontRenderer.vertex(matrix, normalMatrix, buffer, x, y + 9.0f, 0.001f, r, g, b, (float)xStart / 256.0f, (float)(yStart + 9) / 256.0f, light);
        FixedWidthFontRenderer.vertex(matrix, normalMatrix, buffer, x + 6.0f, y + 9.0f, 0.001f, r, g, b, (float)(xStart + 6) / 256.0f, (float)(yStart + 9) / 256.0f, light);
        FixedWidthFontRenderer.vertex(matrix, normalMatrix, buffer, x + 6.0f, y, 0.001f, r, g, b, (float)(xStart + 6) / 256.0f, (float)yStart / 256.0f, light);
    }

    private static void drawQuad(class_4587 transform, class_4588 buffer, float x, float y, float width, float height, float r, float g, float b, int light) {
        class_1159 matrix = transform.method_23760().method_23761();
        class_4581 normalMatrix = transform.method_23760().method_23762();
        FixedWidthFontRenderer.vertex(matrix, normalMatrix, buffer, x, y, 0.0f, r, g, b, 0.9765625f, 0.9765625f, light);
        FixedWidthFontRenderer.vertex(matrix, normalMatrix, buffer, x, y + height, 0.0f, r, g, b, 0.9765625f, 0.984375f, light);
        FixedWidthFontRenderer.vertex(matrix, normalMatrix, buffer, x + width, y + height, 0.0f, r, g, b, 0.984375f, 0.984375f, light);
        FixedWidthFontRenderer.vertex(matrix, normalMatrix, buffer, x + width, y, 0.0f, r, g, b, 0.984375f, 0.9765625f, light);
    }

    private static void drawQuad(class_4587 transform, class_4588 buffer, float x, float y, float width, float height, Palette palette, boolean greyscale, char colourIndex, int light) {
        float r;
        float g;
        float b;
        double[] colour = palette.getColour(FixedWidthFontRenderer.getColour(colourIndex, Colour.BLACK));
        if (greyscale) {
            g = b = FixedWidthFontRenderer.toGreyscale(colour);
            r = b;
        } else {
            r = (float)colour[0];
            g = (float)colour[1];
            b = (float)colour[2];
        }
        FixedWidthFontRenderer.drawQuad(transform, buffer, x, y, width, height, r, g, b, light);
    }

    private static void drawBackground(@Nonnull class_4587 transform, @Nonnull class_4588 buffer, float x, float y, @Nonnull TextBuffer backgroundColour, @Nonnull Palette palette, boolean greyscale, float leftMarginSize, float rightMarginSize, float height, int light) {
        if (leftMarginSize > 0.0f) {
            FixedWidthFontRenderer.drawQuad(transform, buffer, x - leftMarginSize, y, leftMarginSize, height, palette, greyscale, backgroundColour.charAt(0), light);
        }
        if (rightMarginSize > 0.0f) {
            FixedWidthFontRenderer.drawQuad(transform, buffer, x + (float)(backgroundColour.length() * 6), y, rightMarginSize, height, palette, greyscale, backgroundColour.charAt(backgroundColour.length() - 1), light);
        }
        int blockStart = 0;
        char blockColour = '\u0000';
        for (int i = 0; i < backgroundColour.length(); ++i) {
            char colourIndex = backgroundColour.charAt(i);
            if (colourIndex == blockColour) continue;
            if (blockColour != '\u0000') {
                FixedWidthFontRenderer.drawQuad(transform, buffer, x + (float)(blockStart * 6), y, (float)(6 * (i - blockStart)), height, palette, greyscale, blockColour, light);
            }
            blockColour = colourIndex;
            blockStart = i;
        }
        if (blockColour != '\u0000') {
            FixedWidthFontRenderer.drawQuad(transform, buffer, x + (float)(blockStart * 6), y, (float)(6 * (backgroundColour.length() - blockStart)), height, palette, greyscale, blockColour, light);
        }
    }

    public static void drawString(@Nonnull class_4587 transform, @Nonnull class_4588 buffer, float x, float y, @Nonnull TextBuffer text, @Nonnull TextBuffer textColour, @Nullable TextBuffer backgroundColour, @Nonnull Palette palette, boolean greyscale, float leftMarginSize, float rightMarginSize, int light) {
        if (backgroundColour != null) {
            FixedWidthFontRenderer.drawBackground(transform, buffer, x, y, backgroundColour, palette, greyscale, leftMarginSize, rightMarginSize, 9.0f, light);
        }
        for (int i = 0; i < text.length(); ++i) {
            float r;
            float g;
            float b;
            double[] colour = palette.getColour(FixedWidthFontRenderer.getColour(textColour.charAt(i), Colour.BLACK));
            if (greyscale) {
                g = b = FixedWidthFontRenderer.toGreyscale(colour);
                r = b;
            } else {
                r = (float)colour[0];
                g = (float)colour[1];
                b = (float)colour[2];
            }
            int index = text.charAt(i);
            if (index > 255) {
                index = 63;
            }
            FixedWidthFontRenderer.drawChar(transform, buffer, x + (float)(i * 6), y, index, r, g, b, light);
        }
    }

    public static void drawTerminalWithoutCursor(@Nonnull class_4587 transform, @Nonnull class_4588 buffer, float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize, int light) {
        Palette palette = terminal.getPalette();
        int height = terminal.getHeight();
        FixedWidthFontRenderer.drawBackground(transform, buffer, x, y - topMarginSize, terminal.getBackgroundColourLine(0), palette, greyscale, leftMarginSize, rightMarginSize, topMarginSize, light);
        FixedWidthFontRenderer.drawBackground(transform, buffer, x, y + (float)(height * 9), terminal.getBackgroundColourLine(height - 1), palette, greyscale, leftMarginSize, rightMarginSize, bottomMarginSize, light);
        for (int i = 0; i < height; ++i) {
            FixedWidthFontRenderer.drawString(transform, buffer, x, y + (float)(9 * i), terminal.getLine(i), terminal.getTextColourLine(i), terminal.getBackgroundColourLine(i), palette, greyscale, leftMarginSize, rightMarginSize, 0xF000F0);
        }
    }

    public static void drawCursor(@Nonnull class_4587 transform, @Nonnull class_4588 buffer, float x, float y, @Nonnull Terminal terminal, boolean greyscale) {
        Palette palette = terminal.getPalette();
        int width = terminal.getWidth();
        int height = terminal.getHeight();
        int cursorX = terminal.getCursorX();
        int cursorY = terminal.getCursorY();
        if (terminal.getCursorBlink() && cursorX >= 0 && cursorX < width && cursorY >= 0 && cursorY < height && FrameInfo.getGlobalCursorBlink()) {
            float r;
            float g;
            float b;
            double[] colour = palette.getColour(15 - terminal.getTextColour());
            if (greyscale) {
                g = b = FixedWidthFontRenderer.toGreyscale(colour);
                r = b;
            } else {
                r = (float)colour[0];
                g = (float)colour[1];
                b = (float)colour[2];
            }
            FixedWidthFontRenderer.drawChar(transform, buffer, x + (float)(cursorX * 6), y + (float)(cursorY * 9), 95, r, g, b, 0xF000F0);
        }
    }

    public static void drawTerminal(@Nonnull class_4587 transform, @Nonnull class_4588 buffer, float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize, int light) {
        FixedWidthFontRenderer.drawTerminalWithoutCursor(transform, buffer, x, y, terminal, greyscale, topMarginSize, bottomMarginSize, leftMarginSize, rightMarginSize, light);
        FixedWidthFontRenderer.drawCursor(transform, buffer, x, y, terminal, greyscale);
    }

    public static void drawTerminalImmediate(@Nonnull class_4587 transform, float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        class_4597.class_4598 renderer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        class_4588 buffer = renderer.getBuffer(RenderTypes.GUI_TERMINAL);
        FixedWidthFontRenderer.drawTerminal(transform, buffer, x, y, terminal, greyscale, topMarginSize, bottomMarginSize, leftMarginSize, rightMarginSize, 0xF000F0);
        renderer.method_22993();
    }

    public static void drawEmptyTerminal(@Nonnull class_4587 transform, @Nonnull class_4588 buffer, float x, float y, float width, float height, int light) {
        Colour colour = Colour.BLACK;
        FixedWidthFontRenderer.drawQuad(transform, buffer, x, y, width, height, colour.getR(), colour.getG(), colour.getB(), light);
    }

    public static void drawEmptyTerminalImmediate(@Nonnull class_4587 transform, float x, float y, float width, float height) {
        class_4597.class_4598 renderer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        class_4588 buffer = renderer.getBuffer(RenderTypes.GUI_TERMINAL);
        FixedWidthFontRenderer.drawEmptyTerminal(transform, buffer, x, y, width, height, 0xF000F0);
        renderer.method_22993();
    }

    private static void vertex(class_1159 poseMatrix, class_4581 normalMatrix, class_4588 buffer, float x, float y, float z, float r, float g, float b, float u, float v, int light) {
        buffer.method_22918(poseMatrix, x, y, z).method_22915(r, g, b, 1.0f).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, 0.0f, 0.0f, 1.0f).method_1344();
    }
}

