/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.shared.util.Palette;
import java.io.IOException;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import net.minecraft.class_284;
import net.minecraft.class_293;
import net.minecraft.class_3679;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorTextureBufferShader
extends class_5944 {
    static final int TEXTURE_INDEX = 33987;
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_284 palette;
    private final class_284 width = this.getUniformChecked("Width");
    private final class_284 height = this.getUniformChecked("Height");

    public MonitorTextureBufferShader(class_5912 provider, String name, class_293 format) throws IOException {
        super(provider, name, format);
        this.palette = new class_284("Palette", 6, 48, (class_3679)this);
        this.updateUniformLocation(this.palette);
        class_284 tbo = this.getUniformChecked("Tbo");
        if (tbo != null) {
            tbo.method_35649(3);
        }
    }

    void setupUniform(int width, int height, Palette palette, boolean greyscale) {
        if (this.width != null) {
            this.width.method_35649(width);
        }
        if (this.height != null) {
            this.height.method_35649(height);
        }
        this.setupPalette(palette, greyscale);
    }

    private void setupPalette(Palette palette, boolean greyscale) {
        if (this.palette == null) {
            return;
        }
        FloatBuffer paletteBuffer = this.palette.method_35664();
        paletteBuffer.rewind();
        for (int i = 0; i < 16; ++i) {
            double[] colour = palette.getColour(i);
            if (greyscale) {
                float f = FixedWidthFontRenderer.toGreyscale(colour);
                paletteBuffer.put(f).put(f).put(f);
                continue;
            }
            paletteBuffer.put((float)colour[0]).put((float)colour[1]).put((float)colour[2]);
        }
    }

    public void method_34586() {
        super.method_34586();
        this.palette.method_1300();
    }

    public void close() {
        this.palette.close();
        super.close();
    }

    private void updateUniformLocation(class_284 uniform) {
        int id = class_284.method_22096((int)this.method_1270(), (CharSequence)uniform.method_1298());
        if (id == -1) {
            LOGGER.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)this.method_35787(), (Object)uniform.method_1298());
        } else {
            uniform.method_1297(id);
        }
    }

    @Nullable
    private class_284 getUniformChecked(String name) {
        class_284 uniform = this.method_34582(name);
        if (uniform == null) {
            LOGGER.warn("Monitor shader {} should have uniform {}, but it was not present.", (Object)this.method_35787(), (Object)name);
        }
        return uniform;
    }
}

