/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.Registry;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_156;
import net.minecraft.class_1799;

public final class PocketUpgrades {
    private static final Map<String, IPocketUpgrade> upgrades = new HashMap<String, IPocketUpgrade>();
    private static final Map<IPocketUpgrade, String> upgradeOwners = new Object2ObjectLinkedOpenCustomHashMap(class_156.method_655());

    private PocketUpgrades() {
    }

    public static synchronized void register(@Nonnull IPocketUpgrade upgrade) {
        Objects.requireNonNull(upgrade, "upgrade cannot be null");
        String id = upgrade.getUpgradeID().toString();
        IPocketUpgrade existing = upgrades.get(id);
        if (existing != null) {
            throw new IllegalStateException("Error registering '" + upgrade.getUnlocalisedAdjective() + " pocket computer'. UpgradeID '" + id + "' is already registered by '" + existing.getUnlocalisedAdjective() + " pocket computer'");
        }
        upgrades.put(id, upgrade);
        ModContainer mc = (ModContainer)FabricLoader.getInstance().getModContainer(upgrade.getUpgradeID().method_12836()).orElseGet(null);
        if (mc != null && mc.getMetadata().getId() != null) {
            upgradeOwners.put(upgrade, mc.getMetadata().getId());
        }
    }

    public static IPocketUpgrade get(String id) {
        if (id.equals("computercraft:advanved_modem")) {
            id = "computercraft:advanced_modem";
        }
        return upgrades.get(id);
    }

    public static IPocketUpgrade get(@Nonnull class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        for (IPocketUpgrade upgrade : upgrades.values()) {
            class_1799 craftingStack = upgrade.getCraftingItem();
            if (craftingStack.method_7960() || craftingStack.method_7909() != stack.method_7909() || !upgrade.isItemSuitable(stack)) continue;
            return upgrade;
        }
        return null;
    }

    @Nullable
    public static String getOwner(IPocketUpgrade upgrade) {
        return upgradeOwners.get(upgrade);
    }

    public static Iterable<IPocketUpgrade> getUpgrades() {
        return Collections.unmodifiableCollection(upgrades.values());
    }

    public static Stream<IPocketUpgrade> getVanillaUpgrades() {
        List<IPocketUpgrade> vanilla = Arrays.asList(Registry.PocketUpgrades.wirelessModemNormal, Registry.PocketUpgrades.wirelessModemAdvanced, Registry.PocketUpgrades.speaker);
        return vanilla.stream();
    }
}

