/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dan200.computercraft.shared.common.ClientTerminal;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_291;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL31;

public final class ClientMonitor
extends ClientTerminal {
    private static final Set<ClientMonitor> allMonitors = new HashSet<ClientMonitor>();
    private final TileMonitor origin;
    public long lastRenderFrame = -1L;
    public class_2338 lastRenderPos = null;
    public int tboBuffer;
    public int tboTexture;
    public class_291 buffer;

    public ClientMonitor(boolean colour, TileMonitor origin) {
        super(colour);
        this.origin = origin;
    }

    public TileMonitor getOrigin() {
        return this.origin;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean createBuffer(MonitorRenderer renderer) {
        switch (renderer) {
            case TBO: {
                if (this.tboBuffer != 0) {
                    return false;
                }
                this.deleteBuffers();
                this.tboBuffer = GlStateManager._glGenBuffers();
                GlStateManager._glBindBuffer((int)35882, (int)this.tboBuffer);
                GL15.glBufferData((int)35882, (long)0L, (int)35044);
                this.tboTexture = GlStateManager._genTexture();
                GL11.glBindTexture((int)35882, (int)this.tboTexture);
                GL31.glTexBuffer((int)35882, (int)33330, (int)this.tboBuffer);
                GL11.glBindTexture((int)35882, (int)0);
                GlStateManager._glBindBuffer((int)35882, (int)0);
                this.addMonitor();
                return true;
            }
            case VBO: {
                if (this.buffer != null) {
                    return false;
                }
                this.deleteBuffers();
                this.buffer = new class_291();
                this.addMonitor();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMonitor() {
        Set<ClientMonitor> set = allMonitors;
        synchronized (set) {
            allMonitors.add(this);
        }
    }

    private void deleteBuffers() {
        if (this.tboBuffer != 0) {
            RenderSystem.glDeleteBuffers((int)this.tboBuffer);
            this.tboBuffer = 0;
        }
        if (this.tboTexture != 0) {
            GlStateManager._deleteTexture((int)this.tboTexture);
            this.tboTexture = 0;
        }
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Environment(value=EnvType.CLIENT)
    public void destroy() {
        if (this.tboBuffer != 0 || this.buffer != null) {
            Set<ClientMonitor> set = allMonitors;
            synchronized (set) {
                allMonitors.remove(this);
            }
            this.deleteBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Environment(value=EnvType.CLIENT)
    public static void destroyAll() {
        Set<ClientMonitor> set = allMonitors;
        synchronized (set) {
            Iterator<ClientMonitor> iterator = allMonitors.iterator();
            while (iterator.hasNext()) {
                ClientMonitor monitor = iterator.next();
                monitor.deleteBuffers();
                iterator.remove();
            }
        }
    }
}

