/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.fabric.events.CustomServerEvents;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.client.TerminalState;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import java.util.ArrayDeque;
import java.util.Queue;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class MonitorWatcher {
    private static final Queue<TileMonitor> watching = new ArrayDeque<TileMonitor>();
    private static final Queue<PlayerUpdate> playerUpdates = new ArrayDeque<PlayerUpdate>();

    private MonitorWatcher() {
    }

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(MonitorWatcher::onTick);
        CustomServerEvents.SERVER_PLAYER_LOADED_CHUNK_EVENT.register(MonitorWatcher::onWatch);
    }

    static void enqueue(TileMonitor monitor) {
        if (monitor.enqueued) {
            return;
        }
        monitor.enqueued = true;
        monitor.cached = null;
        watching.add(monitor);
    }

    public static void onWatch(class_3222 serverPlayer, class_1923 chunkPos) {
        class_2818 chunk = (class_2818)serverPlayer.method_14220().method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false);
        if (chunk == null) {
            return;
        }
        for (class_2586 te : chunk.method_12214().values()) {
            TileMonitor monitor;
            ServerMonitor serverMonitor;
            if (!(te instanceof TileMonitor) || (serverMonitor = MonitorWatcher.getMonitor(monitor = (TileMonitor)te)) == null || monitor.enqueued) continue;
            playerUpdates.add(new PlayerUpdate(serverPlayer, monitor));
        }
    }

    public static void onTick(MinecraftServer server) {
        TileMonitor tile;
        boolean obeyLimit;
        PlayerUpdate playerUpdate;
        while ((playerUpdate = playerUpdates.poll()) != null) {
            class_3222 player;
            ServerMonitor monitor;
            TileMonitor tile2 = playerUpdate.monitor;
            if (tile2.enqueued || tile2.method_11015() || (monitor = MonitorWatcher.getMonitor(tile2)) == null || !(player = playerUpdate.player).method_5805() || player.method_14220() != tile2.method_10997()) continue;
            NetworkHandler.sendToPlayer((class_1657)playerUpdate.player, new MonitorClientMessage(tile2.method_11016(), MonitorWatcher.getState(tile2, monitor)));
        }
        long limit = ComputerCraft.monitorBandwidth;
        boolean bl = obeyLimit = limit > 0L;
        while (!(obeyLimit && limit <= 0L || (tile = watching.poll()) == null)) {
            class_2818 chunk;
            tile.enqueued = false;
            ServerMonitor monitor = MonitorWatcher.getMonitor(tile);
            if (monitor == null) continue;
            class_2338 pos = tile.method_11016();
            class_1937 world = tile.method_10997();
            if (!(world instanceof class_3218) || ((class_3218)world).method_14178().field_17254.method_17210((chunk = world.method_8500(pos)).method_12004(), false).isEmpty()) continue;
            TerminalState state = MonitorWatcher.getState(tile, monitor);
            NetworkHandler.sendToAllTracking(new MonitorClientMessage(pos, state), chunk);
            limit -= (long)state.size();
        }
    }

    private static ServerMonitor getMonitor(TileMonitor monitor) {
        return !monitor.method_11015() && monitor.getXIndex() == 0 && monitor.getYIndex() == 0 ? monitor.getCachedServerMonitor() : null;
    }

    private static TerminalState getState(TileMonitor tile, ServerMonitor monitor) {
        TerminalState state = tile.cached;
        if (state == null) {
            state = tile.cached = monitor.write();
        }
        return state;
    }

    private static final class PlayerUpdate {
        final class_3222 player;
        final TileMonitor monitor;

        private PlayerUpdate(class_3222 player, TileMonitor monitor) {
            this.player = player;
            this.monitor = monitor;
        }
    }
}

