/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.ItemStorage;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class TurtleDropCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleDropCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        class_2350 side;
        class_2338 oldPosition;
        class_2338 newPosition;
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        class_2350 direction = this.direction.toWorldDir(turtle);
        class_1799 stack = InventoryUtil.takeItems(this.quantity, turtle.getItemHandler(), turtle.getSelectedSlot(), 1, turtle.getSelectedSlot());
        if (stack.method_7960()) {
            return TurtleCommandResult.failure("No items to drop");
        }
        class_1937 world = turtle.getLevel();
        class_1263 inventory = InventoryUtil.getInventory(world, newPosition = (oldPosition = turtle.getPosition()).method_10093(direction), side = direction.method_10153());
        if (inventory != null) {
            class_1799 remainder = InventoryUtil.storeItems(stack, ItemStorage.wrap(inventory, side));
            if (!remainder.method_7960()) {
                InventoryUtil.storeItems(remainder, turtle.getItemHandler(), turtle.getSelectedSlot());
            }
            if (remainder != stack) {
                turtle.playAnimation(TurtleAnimation.WAIT);
                return TurtleCommandResult.success();
            }
            return TurtleCommandResult.failure("No space for items");
        }
        WorldUtil.dropItemStack(stack, world, oldPosition, direction);
        world.method_8474(1000, newPosition, 0);
        turtle.playAnimation(TurtleAnimation.WAIT);
        return TurtleCommandResult.success();
    }
}

