/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.FakePlayer;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1496;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2625;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_4048;
import net.minecraft.class_4050;

public final class TurtlePlayer
extends FakePlayer {
    private static final GameProfile DEFAULT_PROFILE = new GameProfile(UUID.fromString("0d0c4ca0-4ff1-11e4-916c-0800200c9a66"), "[ComputerCraft]");

    private TurtlePlayer(class_3218 world, GameProfile name) {
        super(world, name);
    }

    private static TurtlePlayer create(ITurtleAccess turtle) {
        class_3222 actualPlayer;
        class_3218 world = (class_3218)turtle.getLevel();
        GameProfile profile = turtle.getOwningPlayer();
        TurtlePlayer player = new TurtlePlayer(world, TurtlePlayer.getProfile(profile));
        player.setState(turtle);
        if (profile != null && profile.getId() != null && (actualPlayer = world.method_8503().method_3760().method_14602(profile.getId())) != null) {
            player.method_14236().method_12875(actualPlayer);
        }
        return player;
    }

    private static GameProfile getProfile(@Nullable GameProfile profile) {
        return profile != null && profile.isComplete() ? profile : DEFAULT_PROFILE;
    }

    public static TurtlePlayer get(ITurtleAccess access) {
        if (!(access instanceof TurtleBrain)) {
            return TurtlePlayer.create(access);
        }
        TurtleBrain brain = (TurtleBrain)access;
        TurtlePlayer player = brain.cachedPlayer;
        if (player == null || player.method_7334() != TurtlePlayer.getProfile(access.getOwningPlayer()) || player.method_5770() != access.getLevel()) {
            player = brain.cachedPlayer = TurtlePlayer.create(brain);
        } else {
            player.setState(access);
        }
        return player;
    }

    public static TurtlePlayer getWithPosition(ITurtleAccess turtle, class_2338 position, class_2350 direction) {
        TurtlePlayer turtlePlayer = TurtlePlayer.get(turtle);
        turtlePlayer.setPosition(turtle, position, direction);
        return turtlePlayer;
    }

    private void setState(ITurtleAccess turtle) {
        if (this.field_7512 != this.field_7498) {
            ComputerCraft.log.warn("Turtle has open container ({})", (Object)this.field_7512);
            this.method_14247();
        }
        class_2338 position = turtle.getPosition();
        this.method_23327((double)position.method_10263() + 0.5, (double)position.method_10264() + 0.5, (double)position.method_10260() + 0.5);
        this.method_5710(turtle.getDirection().method_10144(), 0.0f);
        this.method_31548().method_5448();
    }

    public void setPosition(ITurtleAccess turtle, class_2338 position, class_2350 direction) {
        double posX = (double)position.method_10263() + 0.5;
        double posY = (double)position.method_10264() + 0.5;
        double posZ = (double)position.method_10260() + 0.5;
        if (turtle.getPosition().equals((Object)position)) {
            posX += 0.48 * (double)direction.method_10148();
            posY += 0.48 * (double)direction.method_10164();
            posZ += 0.48 * (double)direction.method_10165();
        }
        if (direction.method_10166() != class_2350.class_2351.field_11052) {
            this.method_5710(direction.method_10144(), 0.0f);
        } else {
            this.method_5710(turtle.getDirection().method_10144(), DirectionUtil.toPitchAngle(direction));
        }
        this.method_23327(posX, posY, posZ);
        this.field_6014 = posX;
        this.field_6036 = posY;
        this.field_5969 = posZ;
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.field_6259 = this.field_6241 = this.method_36454();
    }

    public void loadInventory(@Nonnull class_1799 stack) {
        this.method_31548().method_5448();
        this.method_31548().field_7545 = 0;
        this.method_31548().method_5447(0, stack);
    }

    public void loadInventory(@Nonnull ITurtleAccess turtle) {
        this.method_31548().method_5448();
        int currentSlot = turtle.getSelectedSlot();
        int slots = turtle.getItemHandler().size();
        this.method_31548().field_7545 = 0;
        for (int i = 0; i < slots; ++i) {
            this.method_31548().method_5447(i, turtle.getItemHandler().getStack((currentSlot + i) % slots));
        }
    }

    public void unloadInventory(ITurtleAccess turtle) {
        int currentSlot = turtle.getSelectedSlot();
        int slots = turtle.getItemHandler().size();
        this.method_31548().field_7545 = 0;
        for (int i = 0; i < slots; ++i) {
            turtle.getItemHandler().setStack((currentSlot + i) % slots, this.method_31548().method_5438(i));
        }
        class_2338 dropPosition = turtle.getPosition();
        class_2350 dropDirection = turtle.getDirection().method_10153();
        int totalSize = this.method_31548().method_5439();
        for (int i = slots; i < totalSize; ++i) {
            class_1799 remainder = InventoryUtil.storeItems(this.method_31548().method_5438(i), turtle.getItemHandler(), turtle.getSelectedSlot());
            if (remainder.method_7960()) continue;
            WorldUtil.dropItemStack(remainder, turtle.getLevel(), dropPosition, dropDirection);
        }
        this.method_31548().method_5431();
    }

    @Nonnull
    public class_1299<?> method_5864() {
        return Registry.ModEntities.TURTLE_PLAYER;
    }

    public class_243 method_19538() {
        return new class_243(this.method_23317(), this.method_23318(), this.method_23321());
    }

    public float method_18381(@Nonnull class_4050 pose) {
        return 0.0f;
    }

    public float method_18394(@Nonnull class_4050 pose, @Nonnull class_4048 size) {
        return 0.0f;
    }

    @Override
    @Nonnull
    public OptionalInt method_17355(@Nullable class_3908 prover) {
        return OptionalInt.empty();
    }

    @Override
    public void method_6000() {
    }

    @Override
    public void method_6044() {
    }

    @Override
    public boolean method_5873(@Nonnull class_1297 entityIn, boolean force) {
        return false;
    }

    @Override
    public void method_5848() {
    }

    @Override
    public void method_7311(@Nonnull class_2625 signTile) {
    }

    @Override
    public void method_7291(@Nonnull class_1496 horse, @Nonnull class_1263 inventory) {
    }

    @Override
    public void method_7315(@Nonnull class_1799 stack, @Nonnull class_1268 hand) {
    }

    @Override
    public void method_7346() {
    }

    @Override
    protected void method_6129(@Nonnull class_1293 effect) {
    }
}

