/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.storage.base;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public final class SingleViewIterator<T>
implements Iterator<StorageView<T>>,
TransactionContext.CloseCallback {
    private boolean open = true;
    private boolean hasNext = true;
    private final StorageView<T> view;

    public static <T> Iterator<StorageView<T>> create(StorageView<T> view, TransactionContext transaction) {
        SingleViewIterator<T> it = new SingleViewIterator<T>(view);
        transaction.addCloseCallback(it);
        return it;
    }

    private SingleViewIterator(StorageView<T> view) {
        this.view = view;
    }

    @Override
    public boolean hasNext() {
        return this.open && this.hasNext;
    }

    @Override
    public StorageView<T> next() {
        if (!this.open) {
            throw new NoSuchElementException("The transaction for this iterator was closed.");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasNext = false;
        return this.view;
    }

    @Override
    public void onClose(TransactionContext transaction, TransactionContext.Result result) {
        this.open = false;
    }
}

