/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.gui.OptionScreen;
import dan200.computercraft.client.gui.widgets.ComputerSidebar;
import dan200.computercraft.client.gui.widgets.DynamicImageButton;
import dan200.computercraft.client.gui.widgets.WidgetTerminal;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.server.ContinueUploadMessage;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;

public abstract class ComputerScreenBase<T extends ContainerComputerBase>
extends class_465<T> {
    private static final class_2561 OK = new class_2588("gui.ok");
    private static final class_2561 CANCEL = new class_2588("gui.cancel");
    private static final class_2561 OVERWRITE = new class_2588("gui.computercraft.upload.overwrite_button");
    protected WidgetTerminal terminal;
    protected final ClientComputer computer;
    protected final ComputerFamily family;
    protected final int sidebarYOffset;

    public ComputerScreenBase(T container, class_1661 player, class_2561 title, int sidebarYOffset) {
        super(container, player, title);
        this.computer = (ClientComputer)((ContainerComputerBase)container).getComputer();
        this.family = ((ContainerComputerBase)container).getFamily();
        this.sidebarYOffset = sidebarYOffset;
    }

    protected abstract WidgetTerminal createTerminal();

    protected final void method_25426() {
        super.method_25426();
        this.field_22787.field_1774.method_1462(true);
        this.terminal = (WidgetTerminal)this.method_37063((class_364)this.createTerminal());
        ComputerSidebar.addButtons((class_437)this, this.computer, x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        }, this.field_2776, this.field_2800 + this.sidebarYOffset);
        this.method_25395((class_364)this.terminal);
    }

    public final void method_25432() {
        super.method_25432();
        this.field_22787.field_1774.method_1462(false);
    }

    public final void method_37432() {
        super.method_37432();
        this.terminal.update();
    }

    public final boolean method_25404(int key, int scancode, int modifiers) {
        if (key == 258 && this.method_25399() != null && this.method_25399() == this.terminal) {
            return this.method_25399().method_25404(key, scancode, modifiers);
        }
        return super.method_25404(key, scancode, modifiers);
    }

    public final void method_25394(@Nonnull class_4587 stack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(stack);
        super.method_25394(stack, mouseX, mouseY, partialTicks);
        this.method_2380(stack, mouseX, mouseY);
    }

    public boolean method_25402(double x, double y, int button) {
        boolean changed = super.method_25402(x, y, button);
        if (this.method_25399() instanceof DynamicImageButton) {
            this.method_25395((class_364)this.terminal);
        }
        return changed;
    }

    public boolean method_25406(double x, double y, int button) {
        return this.method_25399() != null && this.method_25399().method_25406(x, y, button) || super.method_25406(x, y, button);
    }

    public final boolean method_25403(double x, double y, int button, double deltaX, double deltaY) {
        return this.method_25399() != null && this.method_25399().method_25403(x, y, button, deltaX, deltaY) || super.method_25403(x, y, button, deltaX, deltaY);
    }

    protected void method_2388(@Nonnull class_4587 transform, int mouseX, int mouseY) {
    }

    public void method_29638(@Nonnull List<Path> files) {
        if (files.isEmpty()) {
            return;
        }
        if (this.computer == null || !this.computer.isOn()) {
            this.alert(UploadResult.FAILED_TITLE, UploadResult.COMPUTER_OFF_MSG);
            return;
        }
        long size = 0L;
        ArrayList<FileUpload> toUpload = new ArrayList<FileUpload>();
        for (Path file : files) {
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            try {
                SeekableByteChannel sbc = Files.newByteChannel(file, new OpenOption[0]);
                try {
                    long fileSize = sbc.size();
                    if (fileSize > 524288L || (size += fileSize) >= 524288L) {
                        this.alert(UploadResult.FAILED_TITLE, UploadResult.TOO_MUCH_MSG);
                        return;
                    }
                    String name = file.getFileName().toString();
                    if (name.length() > 128) {
                        this.alert(UploadResult.FAILED_TITLE, (class_2561)new class_2588("gui.computercraft.upload.failed.name_too_long"));
                        return;
                    }
                    ByteBuffer buffer = ByteBuffer.allocateDirect((int)fileSize);
                    sbc.read(buffer);
                    buffer.flip();
                    byte[] digest = FileUpload.getDigest(buffer);
                    if (digest == null) {
                        this.alert(UploadResult.FAILED_TITLE, (class_2561)new class_2588("gui.computercraft.upload.failed.corrupted"));
                        return;
                    }
                    toUpload.add(new FileUpload(name, buffer, digest));
                }
                finally {
                    if (sbc == null) continue;
                    sbc.close();
                }
            }
            catch (IOException e) {
                ComputerCraft.log.error("Failed uploading files", (Throwable)e);
                this.alert(UploadResult.FAILED_TITLE, (class_2561)new class_2588("gui.computercraft.upload.failed.generic", new Object[]{"Cannot compute checksum"}));
            }
        }
        if (toUpload.size() > 32) {
            this.alert(UploadResult.FAILED_TITLE, (class_2561)new class_2588("gui.computercraft.upload.failed.too_many_files"));
            return;
        }
        if (toUpload.size() > 0) {
            UploadFileMessage.send(this.computer.getInstanceID(), toUpload);
        }
    }

    public void uploadResult(UploadResult result, class_2561 message) {
        switch (result) {
            case SUCCESS: {
                this.alert(UploadResult.SUCCESS_TITLE, message);
                break;
            }
            case ERROR: {
                this.alert(UploadResult.FAILED_TITLE, message);
                break;
            }
            case CONFIRM_OVERWRITE: {
                OptionScreen.show(this.field_22787, UploadResult.UPLOAD_OVERWRITE, message, Arrays.asList(OptionScreen.newButton(CANCEL, b -> this.cancelUpload()), OptionScreen.newButton(OVERWRITE, b -> this.continueUpload())), this::cancelUpload);
            }
        }
    }

    private void continueUpload() {
        class_437 class_4372 = this.field_22787.field_1755;
        if (class_4372 instanceof OptionScreen) {
            OptionScreen screen = (OptionScreen)class_4372;
            screen.disable();
        }
        NetworkHandler.sendToServer(new ContinueUploadMessage(this.computer.getInstanceID(), true));
    }

    private void cancelUpload() {
        this.field_22787.method_1507((class_437)this);
        NetworkHandler.sendToServer(new ContinueUploadMessage(this.computer.getInstanceID(), false));
    }

    private void alert(class_2561 title, class_2561 message) {
        OptionScreen.show(this.field_22787, title, message, Collections.singletonList(OptionScreen.newButton(OK, b -> this.field_22787.method_1507((class_437)this))), () -> this.field_22787.method_1507((class_437)this));
    }
}

