/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.computer.MainThreadExecutor;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

public final class MainThread {
    private static final AtomicLong lastTaskId = new AtomicLong();
    private static final TreeSet<MainThreadExecutor> executors = new TreeSet((a, b) -> {
        if (a == b) {
            return 0;
        }
        long at = a.virtualTime;
        long bt = b.virtualTime;
        if (at == bt) {
            return Integer.compare(a.hashCode(), b.hashCode());
        }
        return at < bt ? -1 : 1;
    });
    private static final HashSet<MainThreadExecutor> cooling = new HashSet();
    private static int currentTick;
    private static long budget;
    private static boolean canExecute;
    private static long minimumTime;

    private MainThread() {
    }

    public static long getUniqueTaskID() {
        return lastTaskId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void queue(@Nonnull MainThreadExecutor executor, boolean sleeper) {
        TreeSet<MainThreadExecutor> treeSet = executors;
        synchronized (treeSet) {
            if (executor.onQueue) {
                throw new IllegalStateException("Cannot queue already queued executor");
            }
            executor.onQueue = true;
            executor.updateTime();
            long newRuntime = minimumTime;
            if (executor.virtualTime == 0L) {
                newRuntime += ComputerCraft.maxMainComputerTime;
            }
            executor.virtualTime = Math.max(newRuntime, executor.virtualTime);
            executors.add(executor);
        }
    }

    static void cooling(@Nonnull MainThreadExecutor executor) {
        cooling.add(executor);
    }

    static void consumeTime(long time) {
        budget -= time;
    }

    static boolean canExecute() {
        return canExecute;
    }

    static int currentTick() {
        return currentTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executePendingTasks() {
        long taskStop;
        ++currentTick;
        canExecute = (budget = Math.min(budget + ComputerCraft.maxMainGlobalTime, ComputerCraft.maxMainGlobalTime)) > 0L;
        cooling.removeIf(MainThreadExecutor::tickCooling);
        if (!canExecute) {
            return;
        }
        long start = System.nanoTime();
        long deadline = start + budget;
        do {
            MainThreadExecutor executor;
            TreeSet<MainThreadExecutor> treeSet = executors;
            synchronized (treeSet) {
                executor = executors.pollFirst();
            }
            if (executor == null) break;
            long taskStart = System.nanoTime();
            executor.execute();
            taskStop = System.nanoTime();
            TreeSet<MainThreadExecutor> treeSet2 = executors;
            synchronized (treeSet2) {
                if (executor.afterExecute(taskStop - taskStart)) {
                    executors.add(executor);
                }
                long newMinimum = executor.virtualTime;
                if (!executors.isEmpty()) {
                    MainThreadExecutor next = executors.first();
                    if (next.virtualTime < newMinimum) {
                        newMinimum = next.virtualTime;
                    }
                }
                minimumTime = Math.max(minimumTime, newMinimum);
            }
        } while (taskStop < deadline);
        MainThread.consumeTime(System.nanoTime() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        currentTick = 0;
        budget = 0L;
        canExecute = true;
        minimumTime = 0L;
        lastTaskId.set(0L);
        cooling.clear();
        TreeSet<MainThreadExecutor> treeSet = executors;
        synchronized (treeSet) {
            executors.clear();
        }
    }

    static {
        canExecute = true;
        minimumTime = 0L;
    }
}

