/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.loader.api.FabricLoader;

public enum MonitorRenderer {
    BEST,
    TBO,
    VBO;

    private static boolean initialised;
    private static boolean shaderMod;
    private static final List<String> shaderModIds;

    @Nonnull
    public static MonitorRenderer current() {
        MonitorRenderer current;
        if (!initialised) {
            MonitorRenderer.initialise();
        }
        if ((current = ComputerCraft.monitorRenderer) == BEST) {
            return MonitorRenderer.best();
        }
        return current;
    }

    private static MonitorRenderer best() {
        if (shaderMod) {
            ComputerCraft.log.warn("Shader mod detected. Enabling VBO monitor renderer for compatibility.");
            ComputerCraft.monitorRenderer = VBO;
            return ComputerCraft.monitorRenderer;
        }
        ComputerCraft.monitorRenderer = TBO;
        return ComputerCraft.monitorRenderer;
    }

    private static void initialise() {
        shaderMod = FabricLoader.getInstance().getAllMods().stream().map(modContainer -> modContainer.getMetadata().getId()).anyMatch(shaderModIds::contains);
        initialised = true;
    }

    static {
        initialised = false;
        shaderModIds = Arrays.asList("iris", "canvas", "optifabric");
    }
}

