/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.util.InventoryUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;

public class TurtleTransferToCommand
implements ITurtleCommand {
    private final int slot;
    private final int quantity;

    public TurtleTransferToCommand(int slot, int limit) {
        this.slot = slot;
        this.quantity = limit;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        class_1799 stack = InventoryUtil.takeItems(this.quantity, turtle.getItemHandler(), turtle.getSelectedSlot(), 1, turtle.getSelectedSlot());
        if (stack.method_7960()) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        class_1799 remainder = InventoryUtil.storeItems(stack, turtle.getItemHandler(), this.slot, 1, this.slot);
        if (!remainder.method_7960()) {
            InventoryUtil.storeItems(remainder, turtle.getItemHandler(), turtle.getSelectedSlot(), 1, turtle.getSelectedSlot());
        }
        if (remainder != stack) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("No space for items");
    }
}

