/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.shared.peripheral.speaker.UpgradeSpeakerPeripheral;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1091;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class TurtleSpeaker
extends AbstractTurtleUpgrade {
    public TurtleSpeaker(class_2960 id, class_1799 item) {
        super(id, TurtleUpgradeType.PERIPHERAL, "upgrade.computercraft.speaker.adjective", item);
    }

    @Override
    public IPeripheral createPeripheral(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return new Peripheral(turtle);
    }

    @Override
    @Nonnull
    @Environment(value=EnvType.CLIENT)
    public TransformedModel getModel(ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return TransformedModel.of(side == TurtleSide.LEFT ? Models.leftModel : Models.rightModel);
    }

    @Override
    public void update(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide turtleSide) {
        IPeripheral peripheral = turtle.getPeripheral(turtleSide);
        if (peripheral instanceof Peripheral) {
            Peripheral speaker = (Peripheral)peripheral;
            speaker.update();
        }
    }

    private static class Peripheral
    extends UpgradeSpeakerPeripheral {
        final ITurtleAccess turtle;

        Peripheral(ITurtleAccess turtle) {
            this.turtle = turtle;
        }

        @Override
        public class_1937 getLevel() {
            return this.turtle.getLevel();
        }

        @Override
        @Nonnull
        public class_243 getPosition() {
            class_2338 pos = this.turtle.getPosition();
            return new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof Peripheral)) return false;
            Peripheral speaker = (Peripheral)other;
            if (this.turtle != speaker.turtle) return false;
            return true;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class Models {
        private static class_1091 leftModel = new class_1091("computercraft:turtle_speaker_upgrade_left", "inventory");
        private static class_1091 rightModel = new class_1091("computercraft:turtle_speaker_upgrade_right", "inventory");

        private Models() {
        }
    }
}

