/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.crafting;

import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.stacks.GenericStack;
import appeng.api.util.AEColor;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.blockentity.crafting.CraftingMonitorModelData;
import appeng.core.definitions.AEBlocks;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class CraftingMonitorBlockEntity
extends CraftingBlockEntity
implements IColorableBlockEntity {
    private GenericStack display;
    private AEColor paintedColor = AEColor.TRANSPARENT;

    public CraftingMonitorBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        this.display = GenericStack.readBuffer(data);
        return oldPaintedColor != this.paintedColor || c;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeByte(this.paintedColor.ordinal());
        GenericStack.writeBuffer(this.display, data);
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        if (data.method_10545("paintedColor")) {
            this.paintedColor = AEColor.values()[data.method_10571("paintedColor")];
        }
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10567("paintedColor", (byte)this.paintedColor.ordinal());
    }

    @Override
    public boolean isAccelerator() {
        return false;
    }

    @Override
    public boolean isStatus() {
        return true;
    }

    public void setJob(@Nullable GenericStack stack) {
        if (!Objects.equals(this.display, stack)) {
            this.display = stack;
            this.markForUpdate();
        }
    }

    @Nullable
    public GenericStack getJobProgress() {
        return this.display;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(class_2350 side, AEColor newPaintedColor, class_1657 who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    @Override
    protected class_1792 getItemFromBlockEntity() {
        return AEBlocks.CRAFTING_MONITOR.method_8389();
    }

    @Override
    public Object getRenderAttachmentData() {
        return new CraftingMonitorModelData(this.getUp(), this.getForward(), this.getConnections(), this.getColor());
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }
}

