/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.crafting;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.client.render.crafting.AssemblerAnimationStatus;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.network.TargetPoint;
import appeng.core.sync.packets.AssemblerAnimationPacket;
import appeng.crafting.CraftingEvent;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.CraftingPatternItem;
import appeng.menu.NullMenu;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class MolecularAssemblerBlockEntity
extends AENetworkInvBlockEntity
implements IUpgradeableObject,
IGridTickable,
ICraftingMachine,
IPowerChannelState {
    public static final class_2960 INV_MAIN = AppEng.makeId("molecular_assembler");
    private final class_1715 craftingInv;
    private final AppEngInternalInventory gridInv = new AppEngInternalInventory(this, 10, 1);
    private final AppEngInternalInventory patternInv = new AppEngInternalInventory(this, 1, 1);
    private final InternalInventory gridInvExt = new FilteredInternalInventory(this.gridInv, new CraftingGridFilter());
    private final InternalInventory internalInv = new CombinedInternalInventory(this.gridInv, this.patternInv);
    private final IUpgradeInventory upgrades;
    private boolean isPowered = false;
    private class_2350 pushDirection = null;
    private class_1799 myPattern = class_1799.field_8037;
    private AECraftingPattern myPlan = null;
    private double progress = 0.0;
    private boolean isAwake = false;
    private boolean forcePlan = false;
    private boolean reboot = true;
    @Environment(value=EnvType.CLIENT)
    private AssemblerAnimationStatus animationStatus;

    public MolecularAssemblerBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IGridTickable.class, this);
        this.upgrades = UpgradeInventories.forMachine(AEBlocks.MOLECULAR_ASSEMBLER, this.getUpgradeSlots(), this::saveChanges);
        this.craftingInv = new class_1715((class_1703)new NullMenu(), 3, 3);
    }

    private int getUpgradeSlots() {
        return 5;
    }

    @Override
    public Optional<class_2561> getDisplayName() {
        if (this.hasCustomInventoryName()) {
            return Optional.of(this.getCustomInventoryName());
        }
        return Optional.of(this.getItemFromBlockEntity().method_7848());
    }

    @Override
    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] table, class_2350 where) {
        if (this.myPattern.method_7960()) {
            boolean isEmpty;
            boolean bl = isEmpty = this.gridInv.isEmpty() && this.patternInv.isEmpty();
            if (isEmpty && patternDetails instanceof AECraftingPattern) {
                AECraftingPattern pattern = (AECraftingPattern)patternDetails;
                this.forcePlan = true;
                this.myPlan = pattern;
                this.pushDirection = where;
                this.fillGrid(table, pattern);
                this.updateSleepiness();
                this.saveChanges();
                return true;
            }
        }
        return false;
    }

    private void fillGrid(KeyCounter[] table, AECraftingPattern adapter) {
        block0: for (int sparseIndex = 0; sparseIndex < 9; ++sparseIndex) {
            int requiredAmount;
            AEKey validFluidKey;
            long amount;
            int inputId = adapter.getCompressedIndexFromSparse(sparseIndex);
            if (inputId == -1) continue;
            KeyCounter list = table[inputId];
            GenericStack validFluid = this.myPlan.getValidFluid(sparseIndex);
            if (validFluid != null && (amount = list.get(validFluidKey = validFluid.what())) >= (long)(requiredAmount = (int)validFluid.amount())) {
                this.gridInv.setItemDirect(sparseIndex, GenericStack.wrapInItemStack(validFluidKey, requiredAmount));
                list.remove(validFluidKey, requiredAmount);
                continue;
            }
            for (Object2LongMap.Entry<AEKey> entry : list) {
                Object object;
                if (entry.getLongValue() <= 0L || !((object = entry.getKey()) instanceof AEItemKey)) continue;
                AEItemKey itemKey = (AEItemKey)object;
                this.gridInv.setItemDirect(sparseIndex, itemKey.toStack());
                list.remove(itemKey, 1L);
                continue block0;
            }
        }
        for (KeyCounter list : table) {
            list.removeZeros();
            if (list.isEmpty()) continue;
            throw new RuntimeException("Could not fill grid with some items, including " + list.iterator().next());
        }
    }

    private void updateSleepiness() {
        boolean wasEnabled = this.isAwake;
        boolean bl = this.isAwake = this.myPlan != null && this.hasMats() || this.canPush();
        if (wasEnabled != this.isAwake) {
            this.getMainNode().ifPresent((grid, node) -> {
                if (this.isAwake) {
                    grid.getTickManager().wakeDevice((IGridNode)node);
                } else {
                    grid.getTickManager().sleepDevice((IGridNode)node);
                }
            });
        }
    }

    private boolean canPush() {
        return !this.gridInv.getStackInSlot(9).method_7960();
    }

    private boolean hasMats() {
        if (this.myPlan == null) {
            return false;
        }
        for (int x = 0; x < this.craftingInv.method_5439(); ++x) {
            this.craftingInv.method_5447(x, this.gridInv.getStackInSlot(x));
        }
        return !this.myPlan.getOutput(this.craftingInv, this.method_10997()).method_7960();
    }

    @Override
    public boolean acceptsPlans() {
        return this.patternInv.isEmpty();
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower || c;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.isPowered);
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        if (this.forcePlan) {
            class_1799 pattern;
            class_1799 class_17992 = pattern = this.myPlan != null ? this.myPlan.getDefinition().toStack() : this.myPattern;
            if (!pattern.method_7960()) {
                class_2487 compound = new class_2487();
                pattern.method_7953(compound);
                data.method_10566("myPlan", (class_2520)compound);
                data.method_10569("pushDirection", this.pushDirection.ordinal());
            }
        }
        this.upgrades.writeToNBT(data, "upgrades");
    }

    @Override
    public void loadTag(class_2487 data) {
        class_1799 pattern;
        super.loadTag(data);
        this.forcePlan = false;
        this.myPattern = class_1799.field_8037;
        this.myPlan = null;
        if (data.method_10545("myPlan") && !(pattern = class_1799.method_7915((class_2487)data.method_10562("myPlan"))).method_7960()) {
            this.forcePlan = true;
            this.myPattern = pattern;
            this.pushDirection = class_2350.values()[data.method_10550("pushDirection")];
        }
        this.upgrades.readFromNBT(data, "upgrades");
        this.recalculatePlan();
    }

    private void recalculatePlan() {
        class_1792 class_17922;
        this.reboot = true;
        if (this.forcePlan) {
            if (this.method_10997() != null && this.myPlan == null) {
                class_1792 class_17923;
                if (!this.myPattern.method_7960() && (class_17923 = this.myPattern.method_7909()) instanceof CraftingPatternItem) {
                    CraftingPatternItem patternItem = (CraftingPatternItem)class_17923;
                    this.myPlan = patternItem.decode(this.myPattern, this.method_10997(), false);
                }
                this.myPattern = class_1799.field_8037;
                if (this.myPlan == null) {
                    AELog.warn("Unable to restore auto-crafting pattern after load: %s", this.myPattern.method_7969());
                    this.forcePlan = false;
                }
            }
            return;
        }
        class_1799 is = this.patternInv.getStackInSlot(0);
        if (!is.method_7960() && (class_17922 = is.method_7909()) instanceof CraftingPatternItem) {
            class_1937 level;
            AECraftingPattern details;
            CraftingPatternItem patternItem = (CraftingPatternItem)class_17922;
            if (!class_1799.method_7984((class_1799)is, (class_1799)this.myPattern) && (details = patternItem.decode(is, level = this.method_10997(), false)) != null) {
                this.progress = 0.0;
                this.myPattern = is;
                this.myPlan = details;
            }
        } else {
            this.progress = 0.0;
            this.forcePlan = false;
            this.myPlan = null;
            this.myPattern = class_1799.field_8037;
            this.pushDirection = null;
        }
        this.updateSleepiness();
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    @Override
    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        if (id.equals((Object)INV_MAIN)) {
            return this.internalInv;
        }
        return super.getSubInventory(id);
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.internalInv;
    }

    @Override
    public InternalInventory getExposedInventoryForSide(class_2350 side) {
        return this.gridInvExt;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.gridInv || inv == this.patternInv) {
            this.recalculatePlan();
        }
    }

    public int getCraftingProgress() {
        return (int)this.progress;
    }

    @Override
    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (class_1799 upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        this.recalculatePlan();
        this.updateSleepiness();
        return new TickingRequest(1, 1, !this.isAwake, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.gridInv.getStackInSlot(9).method_7960()) {
            this.pushOut(this.gridInv.getStackInSlot(9));
            if (this.gridInv.getStackInSlot(9).method_7960()) {
                this.saveChanges();
            }
            this.ejectHeldItems();
            this.updateSleepiness();
            this.progress = 0.0;
            return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
        }
        if (this.myPlan == null) {
            this.updateSleepiness();
            return TickRateModulation.SLEEP;
        }
        if (this.reboot) {
            ticksSinceLastCall = 1;
        }
        if (!this.isAwake) {
            return TickRateModulation.SLEEP;
        }
        this.reboot = false;
        int speed = 10;
        switch (this.upgrades.getInstalledUpgrades(AEItems.SPEED_CARD)) {
            case 0: {
                speed = 10;
                this.progress += (double)this.userPower(ticksSinceLastCall, 10, 1.0);
                break;
            }
            case 1: {
                speed = 13;
                this.progress += (double)this.userPower(ticksSinceLastCall, 13, 1.3);
                break;
            }
            case 2: {
                speed = 17;
                this.progress += (double)this.userPower(ticksSinceLastCall, 17, 1.7);
                break;
            }
            case 3: {
                speed = 20;
                this.progress += (double)this.userPower(ticksSinceLastCall, 20, 2.0);
                break;
            }
            case 4: {
                speed = 25;
                this.progress += (double)this.userPower(ticksSinceLastCall, 25, 2.5);
                break;
            }
            case 5: {
                speed = 50;
                this.progress += (double)this.userPower(ticksSinceLastCall, 50, 5.0);
            }
        }
        if (this.progress >= 100.0) {
            for (int x = 0; x < this.craftingInv.method_5439(); ++x) {
                this.craftingInv.method_5447(x, this.gridInv.getStackInSlot(x));
            }
            this.progress = 0.0;
            class_1799 output = this.myPlan.getOutput(this.craftingInv, this.method_10997());
            if (!output.method_7960()) {
                CraftingEvent.fireAutoCraftingEvent(this.method_10997(), this.myPlan, output, this.craftingInv);
                class_2371<class_1799> craftingRemainders = this.myPlan.getRemainingItems(this.craftingInv);
                this.pushOut(output.method_7972());
                for (int x = 0; x < this.craftingInv.method_5439(); ++x) {
                    this.gridInv.setItemDirect(x, (class_1799)craftingRemainders.get(x));
                }
                if (this.patternInv.isEmpty()) {
                    this.forcePlan = false;
                    this.myPlan = null;
                    this.pushDirection = null;
                }
                this.ejectHeldItems();
                AEItemKey item = AEItemKey.of(output);
                if (item != null) {
                    TargetPoint where = new TargetPoint(this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260(), 32.0, this.field_11863);
                    NetworkHandler.instance().sendToAllAround(new AssemblerAnimationPacket(this.field_11867, (byte)speed, item), where);
                }
                this.saveChanges();
                this.updateSleepiness();
                return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
            }
        }
        return TickRateModulation.FASTER;
    }

    private void ejectHeldItems() {
        if (this.gridInv.getStackInSlot(9).method_7960()) {
            for (int x = 0; x < 9; ++x) {
                class_1799 is = this.gridInv.getStackInSlot(x);
                if (is.method_7960() || this.myPlan != null && this.myPlan.isItemValid(x, AEItemKey.of(is), this.field_11863)) continue;
                this.gridInv.setItemDirect(9, is);
                this.gridInv.setItemDirect(x, class_1799.field_8037);
                this.saveChanges();
                return;
            }
        }
    }

    private int userPower(int ticksPassed, int bonusValue, double acceleratorTax) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            return (int)(grid.getEnergyService().extractAEPower((double)(ticksPassed * bonusValue) * acceleratorTax, Actionable.MODULATE, PowerMultiplier.CONFIG) / acceleratorTax);
        }
        return 0;
    }

    private void pushOut(class_1799 output) {
        if (this.pushDirection == null) {
            for (class_2350 d : class_2350.values()) {
                output = this.pushTo(output, d);
            }
        } else {
            output = this.pushTo(output, this.pushDirection);
        }
        if (output.method_7960() && this.forcePlan) {
            this.forcePlan = false;
            this.recalculatePlan();
        }
        this.gridInv.setItemDirect(9, output);
    }

    private class_1799 pushTo(class_1799 output, class_2350 d) {
        int newSize;
        if (output.method_7960()) {
            return output;
        }
        class_2586 te = this.method_10997().method_8321(this.field_11867.method_10093(d));
        if (te == null) {
            return output;
        }
        ItemTransfer adaptor = InternalInventory.wrapExternal(te, d.method_10153());
        if (adaptor == null) {
            return output;
        }
        int size = output.method_7947();
        int n = newSize = (output = adaptor.addItems(output)).method_7960() ? 0 : output.method_7947();
        if (size != newSize) {
            this.saveChanges();
        }
        return output;
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            boolean newState = false;
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                boolean bl = newState = this.getMainNode().isActive() && grid.getEnergyService().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
            }
            if (newState != this.isPowered) {
                this.isPowered = newState;
                this.markForUpdate();
            }
        }
    }

    @Override
    public boolean isPowered() {
        return this.isPowered;
    }

    @Override
    public boolean isActive() {
        return this.isPowered;
    }

    @Environment(value=EnvType.CLIENT)
    public void setAnimationStatus(@Nullable AssemblerAnimationStatus status) {
        this.animationStatus = status;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public AssemblerAnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    @Override
    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    @Nullable
    public AECraftingPattern getCurrentPattern() {
        if (this.isClientSide()) {
            class_1799 patternItem = this.patternInv.getStackInSlot(0);
            IPatternDetails pattern = PatternDetailsHelper.decodePattern(patternItem, this.field_11863);
            if (pattern instanceof AECraftingPattern) {
                AECraftingPattern craftingPattern = (AECraftingPattern)pattern;
                return craftingPattern;
            }
            return null;
        }
        return this.myPlan;
    }

    private class CraftingGridFilter
    implements IAEItemFilter {
        private CraftingGridFilter() {
        }

        private boolean hasPattern() {
            return MolecularAssemblerBlockEntity.this.myPlan != null && !MolecularAssemblerBlockEntity.this.patternInv.isEmpty();
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return slot == 9;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            if (slot >= 9) {
                return false;
            }
            if (this.hasPattern()) {
                return MolecularAssemblerBlockEntity.this.myPlan.isItemValid(slot, AEItemKey.of(stack), MolecularAssemblerBlockEntity.this.method_10997());
            }
            return false;
        }
    }
}

