/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.implementations.blockentities.IMEChest;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.events.GridPowerStorageStateChanged;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.StorageHelper;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.StorageCell;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.helpers.IPriorityHost;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.DelegatingMEInventory;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.ChestMenu;
import appeng.menu.locator.MenuLocators;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.BlankVariantView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class ChestBlockEntity
extends AENetworkPowerBlockEntity
implements IMEChest,
ITerminalHost,
IPriorityHost,
IColorableBlockEntity,
ServerTickingBlockEntity,
IStorageProvider {
    private static final int BIT_POWER_MASK = -128;
    private static final int BIT_STATE_MASK = 7;
    private static final int BIT_CELL_STATE_MASK = 7;
    private static final int BIT_CELL_STATE_BITS = 3;
    private final AppEngInternalInventory inputInventory = new AppEngInternalInventory(this, 1);
    private final AppEngInternalInventory cellInventory = new AppEngInternalInventory(this, 1);
    private final InternalInventory internalInventory = new CombinedInternalInventory(this.inputInventory, this.cellInventory);
    private final IActionSource mySrc = new MachineSource(this);
    private final IConfigManager config = new ConfigManager();
    private int priority = 0;
    private int state = 0;
    private boolean wasActive = false;
    private AEColor paintedColor = AEColor.TRANSPARENT;
    private boolean isCached = false;
    private ChestMonitorHandler cellHandler;
    private Accessor accessor;
    private Storage<FluidVariant> fluidHandler;
    private class_1792 cellItem = class_1802.field_8162;
    private double idlePowerUsage;

    public ChestBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.setInternalMaxPower(PowerMultiplier.CONFIG.multiply(40.0));
        this.getMainNode().addService(IStorageProvider.class, this).setFlags(GridFlags.REQUIRE_CHANNEL);
        this.config.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.config.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.config.registerSetting(Settings.TYPE_FILTER, TypeFilter.ALL);
        this.config.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.setInternalPublicPowerStorage(true);
        this.setInternalPowerFlow(AccessRestriction.WRITE);
        this.inputInventory.setFilter(new InputInventoryFilter());
        this.cellInventory.setFilter(new CellInventoryFilter());
    }

    public class_1799 getCell() {
        return this.cellInventory.getStackInSlot(0);
    }

    public void setCell(class_1799 stack) {
        this.cellInventory.setItemDirect(0, Objects.requireNonNull(stack));
    }

    @Override
    protected void PowerEvent(GridPowerStorageStateChanged.PowerEventType x) {
        if (x == GridPowerStorageStateChanged.PowerEventType.REQUEST_POWER) {
            this.getMainNode().ifPresent(grid -> grid.postEvent(new GridPowerStorageStateChanged(this, GridPowerStorageStateChanged.PowerEventType.REQUEST_POWER)));
        } else {
            this.recalculateDisplay();
        }
    }

    private void recalculateDisplay() {
        int oldState = this.state;
        int state = 0;
        for (int x = 0; x < this.getCellCount(); ++x) {
            state |= this.getCellStatus(x).ordinal() << 3 * x;
        }
        if (this.isPowered()) {
            state |= 0xFFFFFF80;
        }
        if (oldState != state) {
            this.state = state;
            this.markForUpdate();
        }
    }

    @Override
    public int getCellCount() {
        return 1;
    }

    private void updateHandler() {
        if (!this.isCached) {
            this.cellHandler = null;
            this.accessor = null;
            this.fluidHandler = null;
            class_1799 is = this.getCell();
            if (!is.method_7960()) {
                this.isCached = true;
                StorageCell newCell = StorageCells.getCellInventory(is, this::onCellContentChanged);
                if (newCell != null) {
                    this.idlePowerUsage = 1.0 + newCell.getIdleDrain();
                    this.cellHandler = this.wrap(newCell);
                    this.getMainNode().setIdlePowerUsage(this.idlePowerUsage);
                    this.accessor = new Accessor();
                    if (this.cellHandler != null) {
                        this.fluidHandler = new FluidHandler();
                    }
                }
            }
        }
    }

    private ChestMonitorHandler wrap(StorageCell cellInventory) {
        if (cellInventory == null) {
            return null;
        }
        return new ChestMonitorHandler(cellInventory, cellInventory);
    }

    @Override
    public CellState getCellStatus(int slot) {
        if (this.isClientSide()) {
            return CellState.values()[this.state >> slot * 3 & 7];
        }
        this.updateHandler();
        class_1799 cell = this.getCell();
        ICellHandler ch = StorageCells.getHandler(cell);
        if (this.cellHandler != null && ch != null) {
            return this.cellHandler.cellInventory.getStatus();
        }
        return CellState.ABSENT;
    }

    @Override
    @Nullable
    public class_1792 getCellItem(int slot) {
        if (slot != 0) {
            return null;
        }
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return this.cellItem;
        }
        class_1799 cell = this.getCell();
        return cell.method_7960() ? null : cell.method_7909();
    }

    @Override
    public boolean isPowered() {
        boolean gridPowered;
        if (this.isClientSide()) {
            return (this.state & 0xFFFFFF80) == -128;
        }
        boolean bl = gridPowered = this.getAECurrentPower() > 64.0;
        if (!gridPowered) {
            gridPowered = this.getMainNode().isPowered();
        }
        return super.getAECurrentPower() > 1.0 || gridPowered;
    }

    @Override
    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Override
    protected double extractAEPower(double amt, Actionable mode) {
        IEnergyService eg;
        double stash = 0.0;
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null && (stash = (eg = grid.getEnergyService()).extractAEPower(amt, mode, PowerMultiplier.ONE)) >= amt) {
            return stash;
        }
        return super.extractAEPower(amt - stash, mode) + stash;
    }

    @Override
    public void serverTick() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            double powerUsed;
            if (!grid.getEnergyService().isNetworkPowered() && (powerUsed = this.extractAEPower(this.idlePowerUsage, Actionable.MODULATE, PowerMultiplier.CONFIG)) + 0.1 >= this.idlePowerUsage != (this.state & 0xFFFFFF80) > 0) {
                this.recalculateDisplay();
            }
        } else {
            double powerUsed = this.extractAEPower(this.idlePowerUsage, Actionable.MODULATE, PowerMultiplier.CONFIG);
            if (powerUsed + 0.1 >= this.idlePowerUsage != (this.state & 0xFFFFFF80) > 0) {
                this.recalculateDisplay();
            }
        }
        if (!this.inputInventory.isEmpty()) {
            this.tryToStoreContents();
        }
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        this.state = 0;
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.state |= this.getCellStatus(x).ordinal() << 3 * x;
        }
        if (this.isPowered()) {
            this.state |= 0xFFFFFF80;
        }
        data.writeByte(this.state);
        data.writeByte(this.paintedColor.ordinal());
        data.method_10804(class_1792.method_7880((class_1792)this.getCell().method_7909()));
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        int oldState = this.state;
        this.state = data.readByte();
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        this.cellItem = class_1792.method_7875((int)data.method_10816());
        return oldPaintedColor != this.paintedColor || (this.state & 0xDB6DB6DB) != (oldState & 0xDB6DB6DB) || c;
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.config.readFromNBT(data);
        this.priority = data.method_10550("priority");
        if (data.method_10545("paintedColor")) {
            this.paintedColor = AEColor.values()[data.method_10571("paintedColor")];
        }
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.config.writeToNBT(data);
        data.method_10569("priority", this.priority);
        data.method_10567("paintedColor", (byte)this.paintedColor.ordinal());
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentActive;
        if (reason != IGridNodeListener.State.GRID_BOOT && this.wasActive != (currentActive = this.getMainNode().isActive())) {
            this.wasActive = currentActive;
            IStorageProvider.requestUpdate(this.getMainNode());
            this.recalculateDisplay();
        }
    }

    @Override
    public MEStorage getInventory() {
        this.updateHandler();
        if (this.cellHandler != null) {
            return this.cellHandler;
        }
        return null;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.cellInventory) {
            this.cellHandler = null;
            this.isCached = false;
            IStorageProvider.requestUpdate(this.getMainNode());
            if (this.field_11863 != null) {
                Platform.notifyBlocksOfNeighbors(this.field_11863, this.field_11867);
                this.markForUpdate();
            }
        }
        if (inv == this.inputInventory && !inv.getStackInSlot(slot).method_7960()) {
            this.tryToStoreContents();
        }
    }

    @Override
    public InternalInventory getExposedInventoryForSide(class_2350 side) {
        if (side == this.getForward()) {
            return this.cellInventory;
        }
        return this.inputInventory;
    }

    private void tryToStoreContents() {
        if (!this.inputInventory.isEmpty()) {
            this.updateHandler();
            if (this.cellHandler != null) {
                class_1799 stack = this.inputInventory.getStackInSlot(0);
                if (stack.method_7960()) {
                    return;
                }
                long inserted = StorageHelper.poweredInsert(this, this.cellHandler, AEItemKey.of(stack), stack.method_7947(), this.mySrc);
                if (inserted >= (long)stack.method_7947()) {
                    this.inputInventory.setItemDirect(0, class_1799.field_8037);
                } else {
                    stack.method_7934((int)inserted);
                    this.inputInventory.setItemDirect(0, stack);
                }
            }
        }
    }

    @Override
    public void mountInventories(IStorageMounts storageMounts) {
        if (this.getMainNode().isActive()) {
            this.updateHandler();
            if (this.cellHandler != null) {
                storageMounts.mount(this.cellHandler, this.priority);
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.cellHandler = null;
        this.isCached = false;
        IStorageProvider.requestUpdate(this.getMainNode());
    }

    private void blinkCell(int slot) {
        this.recalculateDisplay();
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    public boolean openGui(class_1657 p) {
        ICellGuiHandler chg;
        ICellHandler ch;
        this.updateHandler();
        if (this.cellHandler != null && (ch = StorageCells.getHandler(this.getCell())) != null && (chg = StorageCells.getGuiHandler(this.getCell())) != null) {
            chg.openChestGui(p, this, ch, this.getCell());
            return true;
        }
        return false;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(class_2350 side, AEColor newPaintedColor, class_1657 who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    private void onCellContentChanged() {
        if (this.cellHandler != null) {
            this.cellHandler.cellInventory.persist();
        }
        this.field_11863.method_8524(this.field_11867);
    }

    public void openCellInventoryMenu(class_1657 player) {
        MenuOpener.open(ChestMenu.TYPE, player, MenuLocators.forBlockEntity(this));
    }

    @Nullable
    public Storage<FluidVariant> getFluidHandler(class_2350 side) {
        if (side != this.getForward()) {
            return this.fluidHandler;
        }
        return null;
    }

    @Nullable
    public IStorageMonitorableAccessor getMEHandler(class_2350 side) {
        if (side != this.getForward()) {
            return this.accessor;
        }
        return null;
    }

    @Override
    public class_1799 getMainMenuIcon() {
        return AEBlocks.CHEST.stack();
    }

    @Override
    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        this.openCellInventoryMenu(player);
    }

    private class InputInventoryFilter
    implements IAEItemFilter {
        private InputInventoryFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return false;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            if (ChestBlockEntity.this.isPowered()) {
                ChestBlockEntity.this.updateHandler();
                return ChestBlockEntity.this.cellHandler != null;
            }
            return false;
        }
    }

    private static class CellInventoryFilter
    implements IAEItemFilter {
        private CellInventoryFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            return StorageCells.getHandler(stack) != null;
        }
    }

    private class ChestMonitorHandler
    extends DelegatingMEInventory {
        private final StorageCell cellInventory;

        public ChestMonitorHandler(MEStorage inventory, StorageCell cellInventory) {
            super(inventory);
            this.cellInventory = cellInventory;
        }

        @Override
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (source.player().map(player -> !this.securityCheck((class_1657)player, SecurityPermissions.INJECT)).orElse(false).booleanValue()) {
                return 0L;
            }
            long inserted = super.insert(what, amount, mode, source);
            if (inserted > 0L && mode == Actionable.MODULATE) {
                ChestBlockEntity.this.blinkCell(0);
            }
            return inserted;
        }

        private boolean securityCheck(class_1657 player, SecurityPermissions requiredPermission) {
            return Platform.checkPermissions(player, ChestBlockEntity.this, requiredPermission, false, false);
        }

        @Override
        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (source.player().map(player -> !this.securityCheck((class_1657)player, SecurityPermissions.EXTRACT)).orElse(false).booleanValue()) {
                return 0L;
            }
            long extracted = super.extract(what, amount, mode, source);
            if (extracted > 0L && mode == Actionable.MODULATE) {
                ChestBlockEntity.this.blinkCell(0);
            }
            return extracted;
        }
    }

    private class Accessor
    implements IStorageMonitorableAccessor {
        private Accessor() {
        }

        @Override
        @Nullable
        public MEStorage getInventory(IActionSource src) {
            if (Platform.canAccess(ChestBlockEntity.this.getMainNode(), src)) {
                return ChestBlockEntity.this.getInventory();
            }
            return null;
        }
    }

    private class FluidHandler
    extends SnapshotParticipant<Boolean>
    implements InsertionOnlyStorage<FluidVariant> {
        private GenericStack queuedInsert;
        private final List<StorageView<FluidVariant>> fakeInputTanks = Collections.singletonList(new BlankVariantView((TransferVariant)FluidVariant.blank(), 81000L));

        private FluidHandler() {
        }

        private boolean canAcceptLiquids() {
            return ChestBlockEntity.this.cellHandler != null;
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            if (this.queuedInsert != null) {
                return 0L;
            }
            ChestBlockEntity.this.updateHandler();
            if (this.canAcceptLiquids()) {
                AEFluidKey what = AEFluidKey.of(resource);
                long inserted = this.pushToNetwork(what, maxAmount, Actionable.SIMULATE);
                if (inserted > 0L) {
                    this.updateSnapshots(transaction);
                    this.queuedInsert = new GenericStack(what, inserted);
                }
                return inserted;
            }
            return 0L;
        }

        public Iterator<StorageView<FluidVariant>> iterator(TransactionContext transaction) {
            if (this.canAcceptLiquids()) {
                return this.fakeInputTanks.iterator();
            }
            return Collections.emptyIterator();
        }

        protected final Boolean createSnapshot() {
            return Boolean.TRUE;
        }

        protected final void readSnapshot(Boolean snapshot) {
            this.queuedInsert = null;
        }

        protected final void onFinalCommit() {
            this.pushToNetwork(this.queuedInsert.what(), this.queuedInsert.amount(), Actionable.MODULATE);
            this.queuedInsert = null;
        }

        private long pushToNetwork(AEKey what, long amount, Actionable mode) {
            ChestBlockEntity.this.updateHandler();
            if (this.canAcceptLiquids()) {
                return StorageHelper.poweredInsert(ChestBlockEntity.this, ChestBlockEntity.this.cellHandler, what, amount, ChestBlockEntity.this.mySrc, mode);
            }
            return 0L;
        }
    }
}

