/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.api.config.ActionItems;
import appeng.api.stacks.GenericStack;
import appeng.client.Point;
import appeng.client.gui.Icon;
import appeng.client.gui.me.common.MEStorageScreen;
import appeng.client.gui.me.items.SetProcessingPatternAmountScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.IconButton;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.TabButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.SlotSemantics;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.StackInteractions;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.FakeSlot;
import appeng.parts.encoding.EncodingMode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4587;

public class PatternEncodingTermScreen<C extends PatternEncodingTermMenu>
extends MEStorageScreen<C> {
    private static final String MODES_TEXTURE = "guis/pattern_modes.png";
    private static final Blitter CRAFTING_MODE_BG = Blitter.texture("guis/pattern_modes.png").src(0, 0, 126, 68);
    private static final Blitter PROCESSING_MODE_BG = Blitter.texture("guis/pattern_modes.png").src(0, 70, 126, 68);
    private final TabButton tabCraftButton;
    private final TabButton tabProcessButton;
    private final Multimap<EncodingMode, IconButton> buttonsByMode = ArrayListMultimap.create();
    private final ToggleButton craftingSubstitutionsBtn;
    private final ToggleButton craftingFluidSubstitutionsBtn;
    private final ActionButton processingCycleOutputBtn;
    private final Scrollbar processingScrollbar;

    public PatternEncodingTermScreen(C menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        ActionButton craftingClearBtn = new ActionButton(ActionItems.CLOSE, act -> menu.clear());
        craftingClearBtn.setHalfSize(true);
        this.widgets.add("craftingClearPattern", (class_339)craftingClearBtn);
        this.buttonsByMode.put((Object)EncodingMode.CRAFTING, (Object)craftingClearBtn);
        ActionButton processingClearBtn = new ActionButton(ActionItems.CLOSE, act -> menu.clear());
        processingClearBtn.setHalfSize(true);
        this.widgets.add("processingClearPattern", (class_339)processingClearBtn);
        this.buttonsByMode.put((Object)EncodingMode.PROCESSING, (Object)processingClearBtn);
        this.craftingSubstitutionsBtn = this.createCraftingSubstitutionButton();
        this.craftingFluidSubstitutionsBtn = this.createCraftingFluidSubstitutionButton();
        this.processingCycleOutputBtn = new ActionButton(ActionItems.CYCLE_PROCESSING_OUTPUT, act -> ((PatternEncodingTermMenu)this.method_17577()).cycleProcessingOutput());
        this.processingCycleOutputBtn.setHalfSize(true);
        this.widgets.add("processingCycleOutput", (class_339)this.processingCycleOutputBtn);
        this.processingScrollbar = this.widgets.addScrollBar("processingPatternModeScrollbar", Scrollbar.SMALL);
        this.processingScrollbar.setRange(0, ((PatternEncodingTermMenu)menu).getProcessingInputSlots().length / 3 - 3, 3);
        this.processingScrollbar.setCaptureMouseWheel(false);
        ActionButton encodeBtn = new ActionButton(ActionItems.ENCODE, act -> menu.encode());
        this.widgets.add("encodePattern", (class_339)encodeBtn);
        this.tabCraftButton = new TabButton(new class_1799((class_1935)class_2246.field_9980), (class_2561)GuiText.CraftingPattern.text(), this.field_22788, btn -> ((PatternEncodingTermMenu)this.method_17577()).setMode(EncodingMode.PROCESSING));
        this.widgets.add("craftingPatternMode", (class_339)this.tabCraftButton);
        this.tabProcessButton = new TabButton(new class_1799((class_1935)class_2246.field_10181), (class_2561)GuiText.ProcessingPattern.text(), this.field_22788, btn -> ((PatternEncodingTermMenu)this.method_17577()).setMode(EncodingMode.CRAFTING));
        this.widgets.add("processingPatternMode", (class_339)this.tabProcessButton);
    }

    private ToggleButton createCraftingSubstitutionButton() {
        ToggleButton button = new ToggleButton(Icon.SUBSTITUTION_ENABLED, Icon.SUBSTITUTION_DISABLED, ((PatternEncodingTermMenu)this.method_17577())::setSubstitute);
        button.setHalfSize(true);
        button.setTooltipOn(List.of(ButtonToolTips.Substitutions.text(), ButtonToolTips.SubstitutionsDescEnabled.text()));
        button.setTooltipOff(List.of(ButtonToolTips.Substitutions.text(), ButtonToolTips.SubstitutionsDescDisabled.text()));
        this.widgets.add("craftingSubstitutions", (class_339)button);
        this.buttonsByMode.put((Object)EncodingMode.CRAFTING, (Object)button);
        return button;
    }

    private ToggleButton createCraftingFluidSubstitutionButton() {
        ToggleButton button = new ToggleButton(Icon.FLUID_SUBSTITUTION_ENABLED, Icon.FLUID_SUBSTITUTION_DISABLED, ((PatternEncodingTermMenu)this.method_17577())::setSubstituteFluids);
        button.setHalfSize(true);
        button.setTooltipOn(List.of(ButtonToolTips.FluidSubstitutions.text(), ButtonToolTips.FluidSubstitutionsDescEnabled.text()));
        button.setTooltipOff(List.of(ButtonToolTips.FluidSubstitutions.text(), ButtonToolTips.FluidSubstitutionsDescDisabled.text()));
        this.widgets.add("craftingFluidSubstitutions", (class_339)button);
        this.buttonsByMode.put((Object)EncodingMode.CRAFTING, (Object)button);
        return button;
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        for (Map.Entry entry : this.buttonsByMode.entries()) {
            ((IconButton)entry.getValue()).setVisibility(((PatternEncodingTermMenu)this.field_2797).getMode() == entry.getKey());
        }
        EncodingMode mode = ((PatternEncodingTermMenu)this.field_2797).getMode();
        this.processingScrollbar.setVisible(mode == EncodingMode.PROCESSING);
        this.processingCycleOutputBtn.setVisibility(((PatternEncodingTermMenu)this.field_2797).canCycleProcessingOutputs());
        this.setSlotsHidden(SlotSemantics.CRAFTING_GRID, mode != EncodingMode.CRAFTING);
        this.setSlotsHidden(SlotSemantics.CRAFTING_RESULT, mode != EncodingMode.CRAFTING);
        this.setSlotsHidden(SlotSemantics.PROCESSING_INPUTS, mode != EncodingMode.PROCESSING);
        this.setSlotsHidden(SlotSemantics.PROCESSING_OUTPUTS, mode != EncodingMode.PROCESSING);
        if (mode == EncodingMode.CRAFTING) {
            this.tabCraftButton.field_22764 = true;
            this.tabProcessButton.field_22764 = false;
            this.craftingSubstitutionsBtn.setState(((PatternEncodingTermMenu)this.field_2797).substitute);
            this.craftingFluidSubstitutionsBtn.setState(((PatternEncodingTermMenu)this.field_2797).substituteFluids);
        } else {
            int effectiveRow;
            FakeSlot slot;
            int i;
            this.tabCraftButton.field_22764 = false;
            this.tabProcessButton.field_22764 = true;
            this.repositionSlots(SlotSemantics.PROCESSING_INPUTS);
            this.repositionSlots(SlotSemantics.PROCESSING_OUTPUTS);
            for (i = 0; i < ((PatternEncodingTermMenu)this.field_2797).getProcessingInputSlots().length; ++i) {
                slot = ((PatternEncodingTermMenu)this.field_2797).getProcessingInputSlots()[i];
                effectiveRow = i / 3 - this.processingScrollbar.getCurrentScroll();
                slot.setActive(effectiveRow >= 0 && effectiveRow < 3);
                slot.field_7872 -= this.processingScrollbar.getCurrentScroll() * 18;
            }
            for (i = 0; i < ((PatternEncodingTermMenu)this.field_2797).getProcessingOutputSlots().length; ++i) {
                slot = ((PatternEncodingTermMenu)this.field_2797).getProcessingOutputSlots()[i];
                effectiveRow = i - this.processingScrollbar.getCurrentScroll();
                slot.setActive(effectiveRow >= 0 && effectiveRow < 3);
                slot.field_7872 -= this.processingScrollbar.getCurrentScroll() * 18;
            }
        }
        this.widgets.setTooltipAreaEnabled("processing-primary-output", mode == EncodingMode.PROCESSING && this.processingScrollbar.getCurrentScroll() == 0);
        this.widgets.setTooltipAreaEnabled("processing-optional-output1", mode == EncodingMode.PROCESSING && this.processingScrollbar.getCurrentScroll() > 0);
        this.widgets.setTooltipAreaEnabled("processing-optional-output2", mode == EncodingMode.PROCESSING);
        this.widgets.setTooltipAreaEnabled("processing-optional-output3", mode == EncodingMode.PROCESSING);
    }

    @Override
    public void drawBG(class_4587 poseStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(poseStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        EncodingMode mode = ((PatternEncodingTermMenu)this.field_2797).getMode();
        this.getModeBlitter(mode).blit(poseStack, this.method_25305());
        if (mode == EncodingMode.CRAFTING && ((PatternEncodingTermMenu)this.field_2797).substituteFluids && this.craftingFluidSubstitutionsBtn.method_25405(mouseX, mouseY)) {
            for (Integer slotIndex : ((PatternEncodingTermMenu)this.field_2797).slotsSupportingFluidSubstitution) {
                this.drawSlotGreenBG(poseStack, ((PatternEncodingTermMenu)this.field_2797).getCraftingGridSlots()[slotIndex]);
            }
        }
    }

    protected Blitter getModeBlitter(EncodingMode mode) {
        Blitter modeBg = mode == EncodingMode.CRAFTING ? CRAFTING_MODE_BG : PROCESSING_MODE_BG;
        modeBg.dest(this.getGuiLeft() + 9, this.getGuiTop() + this.field_2779 - 164);
        return modeBg;
    }

    private void drawSlotGreenBG(class_4587 poseStack, class_1735 slot) {
        int x = this.getGuiLeft() + slot.field_7873;
        int y = this.getGuiTop() + slot.field_7872;
        PatternEncodingTermScreen.method_25294((class_4587)poseStack, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)0x7F00FF00);
    }

    @Override
    public boolean method_25402(double xCoord, double yCoord, int btn) {
        GenericStack currentStack;
        class_1735 slot;
        if (this.field_22787.field_1690.field_1871.method_1433(btn) && ((PatternEncodingTermMenu)this.field_2797).canModifyAmountForSlot(slot = this.method_2386(xCoord, yCoord)) && (currentStack = GenericStack.fromItemStack(slot.method_7677())) != null) {
            SetProcessingPatternAmountScreen screen = new SetProcessingPatternAmountScreen(this, currentStack, newStack -> NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, slot.field_7874, GenericStack.wrapInItemStack(newStack))));
            this.switchToScreen(screen);
            return true;
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    @Override
    protected void method_2380(class_4587 poseStack, int x, int y) {
        if (((PatternEncodingTermMenu)this.field_2797).method_34255().method_7960() && ((PatternEncodingTermMenu)this.field_2797).canModifyAmountForSlot(this.field_2787)) {
            ArrayList<class_2561> itemTooltip = new ArrayList<class_2561>(this.method_25408(this.field_2787.method_7677()));
            GenericStack unwrapped = GenericStack.fromItemStack(this.field_2787.method_7677());
            if (unwrapped != null) {
                itemTooltip.add(Tooltips.getAmountTooltip(ButtonToolTips.Amount, unwrapped));
            }
            itemTooltip.add(Tooltips.getSetAmountTooltip());
            this.drawTooltip(poseStack, x, y, itemTooltip);
        } else {
            super.method_2380(poseStack, x, y);
        }
    }

    @Override
    protected EmptyingAction getEmptyingAction(class_1735 slot, class_1799 carried) {
        EmptyingAction emptyingAction;
        if (((PatternEncodingTermMenu)this.field_2797).isProcessingPatternSlot(slot) && (emptyingAction = StackInteractions.getEmptyingAction(carried)) != null) {
            return emptyingAction;
        }
        return super.getEmptyingAction(slot, carried);
    }

    @Override
    public boolean method_25401(double x, double y, double wheelDelta) {
        Blitter modeBg;
        if (((PatternEncodingTermMenu)this.field_2797).getMode() == EncodingMode.PROCESSING && (this.field_2787 == null || ((PatternEncodingTermMenu)this.field_2797).isProcessingPatternSlot(this.field_2787)) && (modeBg = this.getModeBlitter(EncodingMode.PROCESSING)).getDestRect().method_3318((int)x, (int)y) && this.processingScrollbar.onMouseWheel(new Point((int)x, (int)y), wheelDelta)) {
            return true;
        }
        return super.method_25401(x, y, wheelDelta);
    }
}

