/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei.transfer;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.localization.ItemModText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.FillCraftingGridFromRecipePacket;
import appeng.integration.modules.jei.transfer.AbstractTransferHandler;
import appeng.menu.AEBaseMenu;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.util.CraftingRecipeUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerErrorRenderer;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class UseCraftingRecipeTransfer<T extends CraftingTermMenu>
extends AbstractTransferHandler<T> {
    private static final Comparator<GridInventoryEntry> ENTRY_COMPARATOR = Comparator.comparing(GridInventoryEntry::getStoredAmount);

    public UseCraftingRecipeTransfer(Class<T> containerClass) {
        super(containerClass);
    }

    @Override
    protected TransferHandler.Result transferRecipe(T menu, class_1860<?> recipe, Display display, boolean doTransfer) {
        boolean craftingRecipe = this.isCraftingRecipe(recipe, display);
        if (!craftingRecipe) {
            return TransferHandler.Result.createNotApplicable();
        }
        if (!this.fitsIn3x3Grid(recipe, display)) {
            return TransferHandler.Result.createFailed((class_2561)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (recipe == null) {
            recipe = this.createFakeRecipe(display);
        }
        if (!doTransfer) {
            Set<Integer> missingSlots = ((CraftingTermMenu)menu).findMissingIngredients(this.getGuiSlotToIngredientMap(recipe));
            if (!missingSlots.isEmpty()) {
                return TransferHandler.Result.createSuccessful().color(-2130729728).errorRenderer((Object)new MissingSlots(missingSlots));
            }
        } else {
            this.performTransfer(menu, recipe);
        }
        return TransferHandler.Result.createSuccessful().blocksFurtherHandling();
    }

    private class_1860<?> createFakeRecipe(Display display) {
        class_2371 ingredients = class_2371.method_10213((int)9, (Object)class_1856.field_9017);
        for (int i = 0; i < Math.min(display.getInputEntries().size(), ingredients.size()); ++i) {
            class_1856 ingredient = class_1856.method_26964(((EntryIngredient)display.getInputEntries().get(i)).stream().filter(es -> es.getType() == VanillaEntryTypes.ITEM).map(es -> (class_1799)es.castValue()));
            ingredients.set(i, (Object)ingredient);
        }
        return new class_1869(AppEng.makeId("__fake_recipe"), "", 3, 3, ingredients, class_1799.field_8037);
    }

    protected void performTransfer(T menu, class_1860<?> recipe) {
        class_2371<class_1799> templateItems = this.findGoodTemplateItems(recipe, (MEStorageMenu)menu);
        class_2960 recipeId = recipe.method_8114();
        if (((AEBaseMenu)((Object)menu)).getPlayer().field_6002.method_8433().method_8130(recipe.method_8114()).isEmpty()) {
            AELog.debug("Cannot send recipe id %s to server because it's transient", recipeId);
            recipeId = null;
        }
        NetworkHandler.instance().sendToServer(new FillCraftingGridFromRecipePacket(recipeId, templateItems));
    }

    private class_2371<class_1799> findGoodTemplateItems(class_1860<?> recipe, MEStorageMenu menu) {
        Map<AEKey, Integer> ingredientPriorities = this.getIngredientPriorities(menu, ENTRY_COMPARATOR);
        class_2371 templateItems = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        class_2371<class_1856> ingredients = CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe);
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient.method_8103()) continue;
            class_1799 stack = ingredientPriorities.entrySet().stream().filter(e -> {
                AEItemKey itemKey;
                Object patt5198$temp = e.getKey();
                return patt5198$temp instanceof AEItemKey && ingredient.method_8093((itemKey = (AEItemKey)patt5198$temp).toStack());
            }).max(Comparator.comparingInt(Map.Entry::getValue)).map(e -> ((AEItemKey)e.getKey()).toStack()).orElse(ingredient.method_8105()[0]);
            templateItems.set(i, (Object)stack);
        }
        return templateItems;
    }

    private Map<Integer, class_1856> getGuiSlotToIngredientMap(class_1860<?> recipe) {
        int width;
        class_2371 ingredients = recipe.method_8117();
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            width = shapedRecipe.method_8150();
        } else {
            width = 3;
        }
        HashMap<Integer, class_1856> result = new HashMap<Integer, class_1856>(ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            int guiSlot = i / width * 3 + i % width;
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient.method_8103()) continue;
            result.put(guiSlot, ingredient);
        }
        return result;
    }

    @Nullable
    public TransferHandlerErrorRenderer provideErrorRenderer(TransferHandler.Context context, Object data) {
        if (!(data instanceof MissingSlots)) {
            return null;
        }
        MissingSlots missingSlots = (MissingSlots)data;
        return (matrices, mouseX, mouseY, delta, widgets, bounds, display) -> {
            int i = 0;
            for (Widget widget : widgets) {
                if (!(widget instanceof Slot) || ((Slot)widget).getNoticeMark() != 1 || !missingSlots.indices().contains(i++)) continue;
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, 400.0);
                Rectangle innerBounds = ((Slot)widget).getInnerBounds();
                class_332.method_25294((class_4587)matrices, (int)innerBounds.x, (int)innerBounds.y, (int)innerBounds.getMaxX(), (int)innerBounds.getMaxY(), (int)0x40FF0000);
                matrices.method_22909();
            }
        };
    }

    private record MissingSlots(Set<Integer> indices) {
    }
}

