/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPart;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.GuiDataSyncPacket;
import appeng.helpers.InventoryAction;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.me.helpers.PlayerSource;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.DataSynchronization;
import appeng.menu.locator.MenuLocator;
import appeng.menu.me.interaction.ContainerItemContext;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.StackInteractions;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.CraftingMatrixSlot;
import appeng.menu.slot.CraftingTermSlot;
import appeng.menu.slot.DisabledSlot;
import appeng.menu.slot.FakeSlot;
import appeng.menu.slot.InaccessibleSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.ConfigMenuInventory;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public abstract class AEBaseMenu
extends class_1703 {
    private static final int MAX_STRING_LENGTH = Short.MAX_VALUE;
    private final IActionSource mySrc;
    @Nullable
    private final class_2586 blockEntity;
    @Nullable
    private final IPart part;
    @Nullable
    protected final ItemMenuHost itemMenuHost;
    private final DataSynchronization dataSync = new DataSynchronization((Object)this);
    private final class_1661 playerInventory;
    private final Set<Integer> lockedPlayerInventorySlots = new HashSet<Integer>();
    private final Map<class_1735, SlotSemantic> semanticBySlot = new HashMap<class_1735, SlotSemantic>();
    private final ArrayListMultimap<SlotSemantic, class_1735> slotsBySemantic = ArrayListMultimap.create();
    private final Map<String, ClientAction<?>> clientActions = new HashMap();
    private boolean menuValid = true;
    private MenuLocator locator;
    private int ticksSinceCheck = 900;
    private final Set<class_1735> clientSideSlot = new HashSet<class_1735>();

    public AEBaseMenu(class_3917<?> menuType, int id, class_1661 playerInventory, Object host) {
        super(menuType, id);
        this.playerInventory = playerInventory;
        this.blockEntity = host instanceof class_2586 ? (class_2586)host : null;
        this.part = host instanceof IPart ? (IPart)host : null;
        ItemMenuHost itemMenuHost = this.itemMenuHost = host instanceof ItemMenuHost ? (ItemMenuHost)host : null;
        if (host != null && this.blockEntity == null && this.part == null && this.itemMenuHost == null) {
            throw new IllegalArgumentException("Must have a valid host, instead " + host + " in " + playerInventory);
        }
        if (this.itemMenuHost != null && this.itemMenuHost.getSlot() != null) {
            this.lockPlayerInventorySlot(this.itemMenuHost.getSlot());
        }
        this.mySrc = new PlayerSource(this.getPlayer(), this.getActionHost());
    }

    protected final IActionHost getActionHost() {
        if (this.itemMenuHost instanceof IActionHost) {
            return (IActionHost)((Object)this.itemMenuHost);
        }
        if (this.blockEntity instanceof IActionHost) {
            return (IActionHost)this.blockEntity;
        }
        if (this.part instanceof IActionHost) {
            return (IActionHost)((Object)this.part);
        }
        return null;
    }

    protected final boolean isActionHost() {
        return this.itemMenuHost instanceof IActionHost || this.blockEntity instanceof IActionHost || this.part instanceof IActionHost;
    }

    public class_1657 getPlayer() {
        return this.getPlayerInventory().field_7546;
    }

    public IActionSource getActionSource() {
        return this.mySrc;
    }

    public void verifyPermissions(SecurityPermissions security, boolean requirePower) {
        if (this.isClientSide()) {
            return;
        }
        ++this.ticksSinceCheck;
        if (this.ticksSinceCheck < 20) {
            return;
        }
        this.ticksSinceCheck = 0;
        this.setValidMenu(this.isValidMenu() && this.hasAccess(security, requirePower));
    }

    protected final boolean hasAccess(SecurityPermissions perm, boolean requirePower) {
        if (!this.isActionHost() && !requirePower) {
            return true;
        }
        IActionHost host = this.getActionHost();
        if (host != null) {
            return Platform.checkPermissions(this.getPlayer(), host, perm, requirePower, false);
        }
        return false;
    }

    public class_1661 getPlayerInventory() {
        return this.playerInventory;
    }

    public void lockPlayerInventorySlot(int invSlot) {
        Preconditions.checkArgument((invSlot >= 0 && invSlot < this.playerInventory.method_5439() ? 1 : 0) != 0, (String)"cannot lock player inventory slot: %s", (int)invSlot);
        this.lockedPlayerInventorySlots.add(invSlot);
    }

    public Object getTarget() {
        if (this.blockEntity != null) {
            return this.blockEntity;
        }
        if (this.part != null) {
            return this.part;
        }
        return this.itemMenuHost;
    }

    public class_2586 getBlockEntity() {
        return this.blockEntity;
    }

    protected final void createPlayerInventorySlots(class_1661 playerInventory) {
        Preconditions.checkState((boolean)this.getSlots(SlotSemantics.PLAYER_INVENTORY).isEmpty(), (Object)"Player inventory was already created");
        for (int i = 0; i < playerInventory.field_7547.size(); ++i) {
            DisabledSlot slot = this.lockedPlayerInventorySlots.contains(i) ? new DisabledSlot((class_1263)playerInventory, i) : new class_1735((class_1263)playerInventory, i, 0, 0);
            SlotSemantic s = i < class_1661.method_7368() ? SlotSemantics.PLAYER_HOTBAR : SlotSemantics.PLAYER_INVENTORY;
            this.addSlot(slot, s);
        }
    }

    protected class_1735 addSlot(class_1735 slot, SlotSemantic semantic) {
        Preconditions.checkState((!this.semanticBySlot.containsKey(slot = this.method_7621(slot)) ? 1 : 0) != 0);
        this.semanticBySlot.put(slot, semantic);
        this.slotsBySemantic.put((Object)semantic, (Object)slot);
        return slot;
    }

    public class_1735 addClientSideSlot(class_1735 slot, SlotSemantic semantic) {
        Preconditions.checkState((boolean)this.isClientSide(), (Object)"Can only add client-side slots on the client");
        if (!this.clientSideSlot.add(slot)) {
            throw new IllegalStateException("Client-side slot already exists");
        }
        slot.field_7874 = this.field_7761.size();
        this.field_7761.add((Object)slot);
        if (semantic != null) {
            this.semanticBySlot.put(slot, semantic);
            this.slotsBySemantic.put((Object)semantic, (Object)slot);
        }
        return slot;
    }

    public void removeClientSideSlot(class_1735 slot) {
        if (this.field_7761.get(slot.field_7874) != slot) {
            throw new IllegalStateException("Trying to remove slot which isn't currently in the menu");
        }
        if (!this.clientSideSlot.remove(slot)) {
            throw new IllegalStateException("Trying to remove slot which isn't a client-side slot");
        }
        this.field_7761.remove(slot.field_7874);
        this.semanticBySlot.remove(slot);
        this.slotsBySemantic.values().remove(slot);
        for (int i = slot.field_7874; i < this.field_7761.size(); ++i) {
            ((class_1735)this.field_7761.get((int)i)).field_7874 = i;
        }
    }

    public boolean isClientSideSlot(class_1735 slot) {
        return this.clientSideSlot.contains(slot);
    }

    public List<class_1735> getSlots(SlotSemantic semantic) {
        return this.slotsBySemantic.get((Object)semantic);
    }

    protected class_1735 method_7621(class_1735 newSlot) {
        if (newSlot instanceof AppEngSlot) {
            AppEngSlot s = (AppEngSlot)newSlot;
            s.setMenu(this);
        }
        return super.method_7621(newSlot);
    }

    public void method_7623() {
        if (this.itemMenuHost != null && !this.itemMenuHost.onBroadcastChanges(this)) {
            this.setValidMenu(false);
            return;
        }
        if (this.isServerSide()) {
            if (this.blockEntity != null && this.blockEntity.method_10997().method_8321(this.blockEntity.method_11016()) != this.blockEntity) {
                this.setValidMenu(false);
            }
            if (this.dataSync.hasChanges()) {
                this.sendPacketToClient(new GuiDataSyncPacket(this.field_7763, this.dataSync::writeUpdate));
            }
        }
        super.method_7623();
    }

    private boolean isPlayerSideSlot(class_1735 slot) {
        if (slot.field_7871 == this.playerInventory) {
            return true;
        }
        SlotSemantic slotSemantic = this.semanticBySlot.get(slot);
        return slotSemantic == SlotSemantics.PLAYER_INVENTORY || slotSemantic == SlotSemantics.PLAYER_HOTBAR || slotSemantic == SlotSemantics.CRAFTING_GRID;
    }

    public class_1799 method_7601(class_1657 player, int idx) {
        if (this.isClientSide()) {
            return class_1799.field_8037;
        }
        class_1735 clickSlot = (class_1735)this.field_7761.get(idx);
        boolean playerSide = this.isPlayerSideSlot(clickSlot);
        if (clickSlot instanceof DisabledSlot || clickSlot instanceof InaccessibleSlot) {
            return class_1799.field_8037;
        }
        if (clickSlot.method_7681()) {
            class_1799 tis = clickSlot.method_7677();
            if (tis.method_7960()) {
                return class_1799.field_8037;
            }
            ArrayList<class_1735> selectedSlots = new ArrayList<class_1735>();
            if (playerSide) {
                if (!(tis = this.transferStackToMenu(tis)).method_7960()) {
                    for (class_1735 cs : this.field_7761) {
                        if (this.isPlayerSideSlot(cs) || cs instanceof FakeSlot || cs instanceof CraftingMatrixSlot || !cs.method_7680(tis)) continue;
                        selectedSlots.add(cs);
                    }
                }
            } else {
                tis = tis.method_7972();
                for (class_1735 cs : this.field_7761) {
                    if (!this.isPlayerSideSlot(cs) || cs instanceof FakeSlot || cs instanceof CraftingMatrixSlot || !cs.method_7680(tis)) continue;
                    selectedSlots.add(cs);
                }
            }
            if (selectedSlots.isEmpty() && playerSide && !tis.method_7960()) {
                for (class_1735 cs : this.field_7761) {
                    class_1799 destination = cs.method_7677();
                    if (this.isPlayerSideSlot(cs) || !(cs instanceof FakeSlot)) continue;
                    if (class_1799.method_31577((class_1799)destination, (class_1799)tis)) break;
                    if (!destination.method_7960()) continue;
                    cs.method_7673(tis.method_7972());
                    this.method_7623();
                    break;
                }
            }
            if (!tis.method_7960()) {
                for (class_1735 d : selectedSlots) {
                    if (!d.method_7680(tis) || !d.method_7681() || !this.x(clickSlot, tis, d)) continue;
                    return class_1799.field_8037;
                }
                for (class_1735 d : selectedSlots) {
                    class_1799 tmp;
                    if (!d.method_7680(tis)) continue;
                    if (d.method_7681()) {
                        if (!this.x(clickSlot, tis, d)) continue;
                        return class_1799.field_8037;
                    }
                    int maxSize = tis.method_7914();
                    if (maxSize > d.method_7675()) {
                        maxSize = d.method_7675();
                    }
                    if ((tmp = tis.method_7972()).method_7947() > maxSize) {
                        tmp.method_7939(maxSize);
                    }
                    tis.method_7939(tis.method_7947() - tmp.method_7947());
                    d.method_7673(tmp);
                    if (tis.method_7947() <= 0) {
                        clickSlot.method_7673(class_1799.field_8037);
                        d.method_7668();
                        this.method_7623();
                        return class_1799.field_8037;
                    }
                    this.method_7623();
                }
            }
            clickSlot.method_7673(!tis.method_7960() ? tis : class_1799.field_8037);
        }
        this.method_7623();
        return class_1799.field_8037;
    }

    private boolean x(class_1735 clickSlot, class_1799 tis, class_1735 d) {
        class_1799 t = d.method_7677().method_7972();
        if (class_1799.method_31577((class_1799)t, (class_1799)tis)) {
            int placeable;
            int maxSize = t.method_7914();
            if (maxSize > d.method_7675()) {
                maxSize = d.method_7675();
            }
            if ((placeable = maxSize - t.method_7947()) > 0) {
                if (tis.method_7947() < placeable) {
                    placeable = tis.method_7947();
                }
                t.method_7939(t.method_7947() + placeable);
                tis.method_7939(tis.method_7947() - placeable);
                d.method_7673(t);
                if (tis.method_7947() <= 0) {
                    clickSlot.method_7673(class_1799.field_8037);
                    d.method_7668();
                    this.method_7623();
                    this.method_7623();
                    return true;
                }
                this.method_7623();
            }
        }
        return false;
    }

    public boolean method_7597(class_1657 PlayerEntity) {
        if (this.isValidMenu()) {
            if (this.blockEntity instanceof class_1263) {
                return ((class_1263)this.blockEntity).method_5443(PlayerEntity);
            }
            return true;
        }
        return false;
    }

    public boolean method_7615(class_1735 s) {
        if (s instanceof AppEngSlot) {
            return ((AppEngSlot)s).isDraggable();
        }
        return super.method_7615(s);
    }

    public void setFilter(int slotIndex, class_1799 item) {
        if (slotIndex < 0 || slotIndex >= this.field_7761.size()) {
            return;
        }
        class_1735 s = this.method_7611(slotIndex);
        if (!(s instanceof AppEngSlot)) {
            return;
        }
        AppEngSlot appEngSlot = (AppEngSlot)s;
        if (!appEngSlot.isSlotEnabled()) {
            return;
        }
        if (s instanceof FakeSlot) {
            s.method_7673(item);
        }
    }

    public void doAction(class_3222 player, InventoryAction action, int slot, long id) {
        ConfigMenuInventory configInv;
        AppEngSlot appEngSlot;
        InternalInventory internalInventory;
        if (slot < 0 || slot >= this.field_7761.size()) {
            return;
        }
        class_1735 s = this.method_7611(slot);
        if (s instanceof CraftingTermSlot) {
            switch (action) {
                case CRAFT_SHIFT: 
                case CRAFT_ITEM: 
                case CRAFT_STACK: {
                    ((CraftingTermSlot)s).doClick(action, (class_1657)player);
                }
            }
        }
        if (s instanceof FakeSlot) {
            FakeSlot fakeSlot = (FakeSlot)s;
            this.handleFakeSlotAction(fakeSlot, action);
            return;
        }
        if (s instanceof AppEngSlot && (internalInventory = (appEngSlot = (AppEngSlot)s).getInventory()) instanceof ConfigMenuInventory && (configInv = (ConfigMenuInventory)internalInventory).getDelegate().getMode() == GenericStackInv.Mode.STORAGE) {
            GenericStackInv realInv = configInv.getDelegate();
            int realInvSlot = appEngSlot.field_7875;
            if (action == InventoryAction.FILL_ITEM) {
                AEKey what2 = realInv.getKey(realInvSlot);
                this.handleFillingHeldItem((amount, mode) -> realInv.extract(realInvSlot, what2, amount, mode), what2);
            } else if (action == InventoryAction.EMPTY_ITEM) {
                this.handleEmptyHeldItem((what, amount, mode) -> realInv.insert(realInvSlot, what, amount, mode));
            }
        }
        if (action == InventoryAction.MOVE_REGION) {
            ArrayList<class_1735> from = new ArrayList<class_1735>();
            for (class_1735 j : this.field_7761) {
                if (j == null || j.getClass() != s.getClass() || j instanceof CraftingTermSlot) continue;
                from.add(j);
            }
            for (class_1735 fr : from) {
                this.method_7601((class_1657)player, fr.field_7874);
            }
        }
    }

    protected final void handleFillingHeldItem(FillingSource source, AEKey what) {
        ContainerItemContext ctx = StackInteractions.findCarriedContext(this.getPlayer(), this);
        if (ctx == null) {
            return;
        }
        long amountAllowed = ctx.insert(what, Long.MAX_VALUE, Actionable.SIMULATE);
        if (amountAllowed == 0L) {
            return;
        }
        long canPull = source.extract(amountAllowed, Actionable.SIMULATE);
        if (canPull <= 0L) {
            return;
        }
        long canFill = ctx.insert(what, canPull, Actionable.MODULATE);
        if (canFill == 0L) {
            return;
        }
        long extracted = source.extract(canFill, Actionable.MODULATE);
        if (extracted <= 0L) {
            AELog.error("Unable to pull fluid out of the ME system even though the simulation said yes ", new Object[0]);
            return;
        }
        ctx.playFillSound(this.getPlayer(), what);
    }

    protected final void handleEmptyHeldItem(EmptyingSink sink) {
        long amount;
        ContainerItemContext ctx = StackInteractions.findCarriedContext(this.getPlayer(), this);
        if (ctx == null) {
            return;
        }
        GenericStack content = ctx.getExtractableContent();
        if (content == null) {
            return;
        }
        AEKey what = content.what();
        long canInsert = sink.insert(what, amount = content.amount(), Actionable.SIMULATE);
        if (canInsert <= 0L) {
            return;
        }
        long extracted = ctx.extract(what, canInsert, Actionable.MODULATE);
        if (extracted != canInsert) {
            AELog.error("Fluid item [%s] reported a different possible amount to drain than it actually provided.", this.method_34255());
            return;
        }
        if (sink.insert(what, extracted, Actionable.MODULATE) != extracted) {
            AELog.error("Failed to insert previously simulated %s into ME system", what);
            return;
        }
        ctx.playEmptySound(this.getPlayer(), what);
    }

    private void handleFakeSlotAction(FakeSlot fakeSlot, InventoryAction action) {
        class_1799 hand = this.method_34255();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                fakeSlot.increase(hand);
                break;
            }
            case PLACE_SINGLE: {
                if (hand.method_7960()) break;
                class_1799 is = hand.method_7972();
                is.method_7939(1);
                fakeSlot.increase(is);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                class_1799 is = fakeSlot.method_7677();
                if (!is.method_7960()) {
                    fakeSlot.decrease(hand);
                    break;
                }
                if (hand.method_7960()) break;
                is = hand.method_7972();
                is.method_7939(1);
                fakeSlot.method_7673(is);
                break;
            }
            case EMPTY_ITEM: {
                EmptyingAction emptyingAction = StackInteractions.getEmptyingAction(hand);
                if (emptyingAction == null) break;
                fakeSlot.method_7673(GenericStack.wrapInItemStack(emptyingAction.what(), emptyingAction.maxAmount()));
                break;
            }
        }
    }

    protected class_1799 transferStackToMenu(class_1799 input) {
        return input;
    }

    public void swapSlotContents(int slotA, int slotB) {
        class_1799 testB;
        class_1735 a = this.method_7611(slotA);
        class_1735 b = this.method_7611(slotB);
        if (a == null || b == null) {
            return;
        }
        class_1799 isA = a.method_7677();
        class_1799 isB = b.method_7677();
        if (isA.method_7960() && isB.method_7960()) {
            return;
        }
        if (!isA.method_7960() && !a.method_7674(this.getPlayerInventory().field_7546)) {
            return;
        }
        if (!isB.method_7960() && !b.method_7674(this.getPlayerInventory().field_7546)) {
            return;
        }
        if (!isB.method_7960() && !a.method_7680(isB)) {
            return;
        }
        if (!isA.method_7960() && !b.method_7680(isA)) {
            return;
        }
        class_1799 testA = isB.method_7960() ? class_1799.field_8037 : isB.method_7972();
        class_1799 class_17992 = testB = isA.method_7960() ? class_1799.field_8037 : isA.method_7972();
        if (!testA.method_7960() && testA.method_7947() > a.method_7675()) {
            if (!testB.method_7960()) {
                return;
            }
            int totalA = testA.method_7947();
            testA.method_7939(a.method_7675());
            testB = testA.method_7972();
            testB.method_7939(totalA - testA.method_7947());
        }
        if (!testB.method_7960() && testB.method_7947() > b.method_7675()) {
            if (!testA.method_7960()) {
                return;
            }
            int totalB = testB.method_7947();
            testB.method_7939(b.method_7675());
            testA = testB.method_7972();
            testA.method_7939(totalB - testA.method_7947());
        }
        a.method_7673(testA);
        b.method_7673(testB);
    }

    @OverridingMethodsMustInvokeSuper
    public void onServerDataSync() {
    }

    public void onSlotChange(class_1735 s) {
    }

    public boolean isValidForSlot(class_1735 s, class_1799 i) {
        return true;
    }

    public boolean isValidMenu() {
        return this.menuValid;
    }

    public void setValidMenu(boolean isContainerValid) {
        this.menuValid = isContainerValid;
    }

    public MenuLocator getLocator() {
        return this.locator;
    }

    public void setLocator(MenuLocator locator) {
        this.locator = locator;
    }

    public boolean isClientSide() {
        return this.getPlayer().method_5770().method_8608();
    }

    protected boolean isServerSide() {
        return !this.isClientSide();
    }

    protected final void sendPacketToClient(BasePacket packet) {
        class_1657 class_16572 = this.getPlayer();
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            NetworkHandler.instance().sendTo(packet, serverPlayer);
        }
    }

    public void method_34252() {
        super.method_34252();
        if (this.dataSync.hasFields()) {
            this.sendPacketToClient(new GuiDataSyncPacket(this.field_7763, this.dataSync::writeFull));
        }
    }

    public final void receiveServerSyncData(GuiDataSyncPacket packet) {
        this.dataSync.readUpdate(packet.getData());
        this.onServerDataSync();
    }

    public final void receiveClientAction(GuiDataSyncPacket packet) {
        class_2540 data = packet.getData();
        String name = data.method_10800(256);
        ClientAction<?> action = this.clientActions.get(name);
        if (action == null) {
            throw new IllegalArgumentException("Unknown client action: '" + name + "'");
        }
        action.handle(data);
    }

    protected final <T> void registerClientAction(String name, Class<T> argClass, Consumer<T> handler) {
        if (this.clientActions.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate client action registered: " + name);
        }
        this.clientActions.put(name, new ClientAction<T>(name, argClass, handler));
    }

    protected final void registerClientAction(String name, Runnable callback) {
        this.registerClientAction(name, Void.class, arg -> callback.run());
    }

    protected final <T> void sendClientAction(String action, T arg) {
        String jsonPayload;
        ClientAction<?> clientAction = this.clientActions.get(action);
        if (clientAction == null) {
            throw new IllegalArgumentException("Trying to send unregistered client action: " + action);
        }
        if (clientAction.argClass == Void.class) {
            if (arg != null) {
                throw new IllegalArgumentException("Client action " + action + " requires no argument, but it was given");
            }
            jsonPayload = null;
        } else {
            if (arg == null) {
                throw new IllegalArgumentException("Client action " + action + " requires an argument, but none was given");
            }
            if (clientAction.argClass != arg.getClass()) {
                throw new IllegalArgumentException("Trying to send client action " + action + " with wrong argument type " + arg.getClass() + ", expected: " + clientAction.argClass);
            }
            jsonPayload = clientAction.gson.toJson(arg);
        }
        if (jsonPayload != null && jsonPayload.length() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot send client action " + action + " because serialized argument is longer than 32767 (" + jsonPayload.length() + ")");
        }
        NetworkHandler.instance().sendToServer(new GuiDataSyncPacket(this.field_7763, writer -> {
            writer.method_10814(clientAction.name);
            if (jsonPayload != null) {
                writer.method_10814(jsonPayload);
            }
        }));
    }

    protected final void sendClientAction(String action) {
        this.sendClientAction(action, null);
    }

    protected final void setupUpgrades(IUpgradeInventory upgrades) {
        for (int i = 0; i < upgrades.size(); ++i) {
            RestrictedInputSlot slot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, i);
            slot.setNotDraggable();
            this.addSlot(slot, SlotSemantics.UPGRADE);
        }
    }

    protected static interface FillingSource {
        public long extract(long var1, Actionable var3);
    }

    protected static interface EmptyingSink {
        public long insert(AEKey var1, long var2, Actionable var4);
    }

    private static class ClientAction<T> {
        private final Gson gson = new GsonBuilder().create();
        private final String name;
        private final Class<T> argClass;
        private final Consumer<T> handler;

        public ClientAction(String name, Class<T> argClass, Consumer<T> handler) {
            this.name = name;
            this.argClass = argClass;
            this.handler = handler;
        }

        public void handle(class_2540 buffer) {
            Object arg = null;
            if (this.argClass != Void.class) {
                String payload = buffer.method_19772();
                AELog.debug("Handling client action '%s' with payload %s", this.name, payload);
                arg = this.gson.fromJson(payload, this.argClass);
            } else {
                AELog.debug("Handling client action '%s'", this.name);
            }
            this.handler.accept(arg);
        }
    }
}

