/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.core.AELog;
import appeng.core.settings.TickRates;
import appeng.hooks.ticking.TickHandler;
import appeng.items.parts.PartModels;
import appeng.me.service.helpers.Connections;
import appeng.me.service.helpers.TunnelConnection;
import appeng.parts.AEBasePart;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;

public class MEP2PTunnelPart
extends P2PTunnelPart<MEP2PTunnelPart>
implements IGridTickable {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_me");
    private final Connections connection = new Connections(this);
    private final IManagedGridNode outerNode = GridHelper.createManagedNode(this, AEBasePart.NodeListener.INSTANCE).setTagName("outer").setInWorldNode(true).setFlags(GridFlags.DENSE_CAPACITY, GridFlags.CANNOT_CARRY_COMPRESSED);

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public MEP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL, GridFlags.COMPRESSED_CHANNEL).addService(IGridTickable.class, this);
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public void readFromNBT(class_2487 extra) {
        super.readFromNBT(extra);
        this.outerNode.loadFromNBT(extra);
    }

    @Override
    public void writeToNBT(class_2487 extra) {
        super.writeToNBT(extra);
        this.outerNode.saveToNBT(extra);
    }

    @Override
    public void onTunnelNetworkChange() {
        super.onTunnelNetworkChange();
        if (!this.isOutput()) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
        }
    }

    @Override
    public AECableType getExternalCableConnectionType() {
        return AECableType.DENSE_SMART;
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.outerNode.destroy();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.outerNode.create(this.getLevel(), this.getBlockEntity().method_11016());
    }

    @Override
    public void setPartHostInfo(class_2350 side, IPartHost host, class_2586 blockEntity) {
        super.setPartHostInfo(side, host, blockEntity);
        this.outerNode.setExposedOnSides(EnumSet.of(side));
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return this.outerNode.getNode();
    }

    @Override
    public void onPlacement(class_1657 player) {
        super.onPlacement(player);
        this.outerNode.setOwningPlayer(player);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.METunnel, true, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (node.hasGridBooted()) {
            if (!node.isPowered() || !node.isActive()) {
                this.connection.markDestroy();
            } else {
                this.connection.markCreate();
            }
            TickHandler.instance().addCallable((class_1936)this.getBlockEntity().method_10997(), this.connection);
            return TickRateModulation.SLEEP;
        }
        return TickRateModulation.IDLE;
    }

    public void updateConnections(Connections connections) {
        if (this.isOutput()) {
            return;
        }
        if (connections.isDestroy()) {
            for (TunnelConnection cw : this.connection.getConnections().values()) {
                cw.getConnection().destroy();
            }
            this.connection.getConnections().clear();
        } else if (connections.isCreate()) {
            IGrid grid = this.getMainNode().getGrid();
            Iterator<TunnelConnection> i = this.connection.getConnections().values().iterator();
            while (i.hasNext()) {
                TunnelConnection cw = i.next();
                if (grid != null && cw.getTunnel().getMainNode().getGrid() == grid && cw.getTunnel().getMainNode().isActive()) continue;
                cw.getConnection().destroy();
                i.remove();
            }
            List newSides = this.getOutputs();
            for (MEP2PTunnelPart me : newSides) {
                if (!me.getMainNode().isActive() || connections.getConnections().get(me.getGridNode()) != null) continue;
                try {
                    connections.getConnections().put(me.getGridNode(), new TunnelConnection(me, GridHelper.createGridConnection(this.outerNode.getNode(), me.outerNode.getNode())));
                }
                catch (FailedConnectionException e) {
                    class_2586 start = this.getBlockEntity();
                    class_2586 end = me.getBlockEntity();
                    AELog.debug(e);
                    AELog.warn("Failed to establish a ME P2P Tunnel between the tunnels at [x=%d, y=%d, z=%d] and [x=%d, y=%d, z=%d]", start.method_11016().method_10263(), start.method_11016().method_10264(), start.method_11016().method_10260(), end.method_11016().method_10263(), end.method_11016().method_10264(), end.method_11016().method_10260());
                }
            }
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

