/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testworld;

import appeng.blockentity.networking.EnergyCellBlockEntity;
import appeng.blockentity.storage.SkyStoneTankBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.items.parts.PartItem;
import appeng.me.service.P2PService;
import appeng.parts.AEBasePart;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.server.testworld.PlotBuilder;
import appeng.util.SettingsFrom;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableInt;

public class P2PTestPlots {
    public static void me(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        P2PTestPlots.placeTunnel(plot, AEParts.ME_P2P_TUNNEL);
        plot.cable(origin.method_10067().method_10067()).part(class_2350.field_11039, AEParts.IMPORT_BUS);
        plot.chest(origin.method_10067().method_10067().method_10067(), new class_1799((class_1935)class_1802.field_8542));
        plot.cable(origin.method_10078().method_10078()).part(class_2350.field_11034, AEParts.STORAGE_BUS);
        plot.chest(origin.method_10078().method_10078().method_10078(), new class_1799[0]);
        plot.part(origin, class_2350.field_11036, AEParts.STORAGE_BUS, storageBus -> storageBus.setPriority(1));
        plot.chest(origin.method_10084(), new class_1799[0]);
        plot.cable(origin.method_10078().method_10084());
        plot.cable(origin.method_10078().method_10078().method_10084()).part(class_2350.field_11039, AEParts.QUARTZ_FIBER);
        plot.test(helper -> helper.method_36018(() -> {
            helper.method_36047(origin.method_10067().method_10067().method_10067());
            helper.method_35983(origin.method_10078().method_10078().method_10078(), class_1802.field_8542);
        }));
    }

    public static void item(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        P2PTestPlots.placeTunnel(plot, AEParts.ITEM_P2P_TUNNEL);
        plot.hopper(origin.method_10067().method_10067(), class_2350.field_11034, new class_1799((class_1935)class_1802.field_8542));
        class_2338 chestPos = origin.method_10078().method_10078();
        plot.chest(chestPos, new class_1799[0]);
        plot.test(helper -> helper.method_36018(() -> helper.method_35983(chestPos, class_1802.field_8542)));
    }

    public static void fluid(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        P2PTestPlots.placeTunnel(plot, AEParts.FLUID_P2P_TUNNEL);
        class_2338 outputPos = origin.method_10078().method_10078();
        plot.block(outputPos, AEBlocks.SKY_STONE_TANK);
        plot.cable(origin.method_10067().method_10067()).part(class_2350.field_11034, AEParts.EXPORT_BUS, part -> part.getConfig().addFilter((class_3611)class_3612.field_15910));
        plot.creativeEnergyCell(origin.method_10067().method_10067().method_10074());
        plot.drive(origin.method_10067().method_10067().method_10084()).addCreativeCell().add((class_3611)class_3612.field_15910);
        plot.test(helper -> helper.method_36018(() -> {
            SkyStoneTankBlockEntity tank = (SkyStoneTankBlockEntity)helper.method_36014(outputPos);
            SingleVariantStorage<FluidVariant> storage = tank.getStorage();
            helper.check(FluidVariant.of((class_3611)class_3612.field_15910).equals(storage.variant), "No water stored");
            helper.check(storage.amount > 0L, "No amount >0 stored");
        }));
    }

    public static void energy(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        P2PTestPlots.placeTunnel(plot, AEParts.FE_P2P_TUNNEL);
        plot.block(origin.method_10067().method_10067(), AEBlocks.DEBUG_ENERGY_GEN);
        plot.block(origin.method_10078().method_10078(), AEBlocks.ENERGY_ACCEPTOR);
        class_2338 cellPos = origin.method_10078().method_10078().method_10084();
        plot.block(cellPos, AEBlocks.ENERGY_CELL);
        MutableDouble cellEnergy = new MutableDouble(0.0);
        plot.test(helper -> helper.method_36041().method_36076(10).method_36079(() -> {
            EnergyCellBlockEntity cell = (EnergyCellBlockEntity)helper.method_36014(cellPos);
            cellEnergy.setValue(cell.getAECurrentPower());
        }).method_36076(10).method_36079(() -> {
            EnergyCellBlockEntity cell = (EnergyCellBlockEntity)helper.method_36014(cellPos);
            helper.check(cell.getAECurrentPower() > cellEnergy.getValue(), "Cell should start charging through the P2P tunnel");
        }).method_36075());
    }

    public static void light(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        P2PTestPlots.placeTunnel(plot, AEParts.LIGHT_P2P_TUNNEL);
        plot.block(origin.method_10067().method_10067(), class_2246.field_10524);
        class_2338 leverPos = origin.method_10067().method_10067().method_10084();
        plot.block(leverPos, class_2246.field_10363);
        class_2338 outputPos = origin.method_10078().method_10078();
        plot.test(helper -> {
            MutableInt lightLevel = new MutableInt(0);
            helper.method_36041().method_36076(20).method_36085(() -> {
                lightLevel.setValue(helper.method_35943().method_8314(class_1944.field_9282, helper.method_36052(outputPos)));
                helper.method_36039(leverPos);
            }).method_36079(() -> {
                int newLightLevel = helper.method_35943().method_8314(class_1944.field_9282, helper.method_36052(outputPos));
                helper.check(newLightLevel > lightLevel.getValue(), "Light-Level didn't increase");
            }).method_36085(() -> helper.method_36039(leverPos)).method_36079(() -> {
                int newLightLevel = helper.method_35943().method_8314(class_1944.field_9282, helper.method_36052(outputPos));
                helper.check(newLightLevel <= lightLevel.getValue(), "Light-Level didn't reset");
            }).method_36075();
        });
    }

    private static <T extends P2PTunnelPart<?>> void placeTunnel(PlotBuilder plot, ItemDefinition<PartItem<T>> tunnel) {
        class_2338 origin = class_2338.field_10980;
        plot.creativeEnergyCell(origin.method_10074());
        plot.cable(origin);
        plot.cable(origin.method_10067()).part(class_2350.field_11039, tunnel);
        plot.cable(origin.method_10078()).part(class_2350.field_11034, tunnel);
        plot.afterGridInitAt(origin, (grid, gridNode) -> {
            class_2338 absOrigin = ((AEBasePart)gridNode.getOwner()).getBlockEntity().method_11016();
            P2PService p2p = P2PService.get(grid);
            P2PTunnelPart inputTunnel = null;
            P2PTunnelPart outputTunnel = null;
            for (P2PTunnelPart p2pPart : grid.getMachines(((PartItem)tunnel.method_8389()).getPartClass())) {
                if (p2pPart.getBlockEntity().method_11016().equals((Object)absOrigin.method_10067())) {
                    inputTunnel = p2pPart;
                    continue;
                }
                if (!p2pPart.getBlockEntity().method_11016().equals((Object)absOrigin.method_10078())) continue;
                outputTunnel = p2pPart;
            }
            Objects.requireNonNull(inputTunnel, "inputTunnel");
            Objects.requireNonNull(outputTunnel, "outputTunnel");
            inputTunnel.setFrequency(p2p.newFrequency());
            p2p.updateFreq(inputTunnel, inputTunnel.getFrequency());
            class_2487 settings = new class_2487();
            inputTunnel.exportSettings(SettingsFrom.MEMORY_CARD, settings);
            outputTunnel.importSettings(SettingsFrom.MEMORY_CARD, settings, null);
        });
    }
}

