/*
 * Decompiled with CFR 0.152.
 */
package appeng.thirdparty.codechicken.lib.model.pipeline.transformers;

import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;

public class QuadCornerKicker
implements RenderContext.QuadTransform {
    public static final QuadCornerKicker INSTANCE = new QuadCornerKicker();
    public static int[][] horizonals = new int[][]{{2, 3, 4, 5}, {2, 3, 4, 5}, {0, 1, 4, 5}, {0, 1, 4, 5}, {0, 1, 2, 3}, {0, 1, 2, 3}};
    private int mySide;
    private int facadeMask;
    private class_238 box;
    private double thickness;
    private static final double EPSILON = 1.0E-5;

    public void setSide(int side) {
        this.mySide = side;
    }

    public void setFacadeMask(int mask) {
        this.facadeMask = mask;
    }

    public void setBox(class_238 box) {
        this.box = box;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public boolean transform(MutableQuadView quad) {
        int side = quad.nominalFace().ordinal();
        if (side != this.mySide && side != (this.mySide ^ 1)) {
            for (int hoz : horizonals[this.mySide]) {
                if (side == hoz || side == (hoz ^ 1) || (this.facadeMask & 1 << hoz) == 0) continue;
                Corner corner = Corner.fromSides(this.mySide ^ 1, side, hoz);
                for (int i = 0; i < 4; ++i) {
                    float x = quad.posByIndex(i, 0);
                    float y = quad.posByIndex(i, 1);
                    float z = quad.posByIndex(i, 2);
                    if (!QuadCornerKicker.epsComp(x, corner.pX(this.box)) || !QuadCornerKicker.epsComp(y, corner.pY(this.box)) || !QuadCornerKicker.epsComp(z, corner.pZ(this.box))) continue;
                    class_2382 vec = class_2350.values()[hoz].method_10163();
                    x = (float)((double)x - (double)vec.method_10263() * this.thickness);
                    y = (float)((double)y - (double)vec.method_10264() * this.thickness);
                    z = (float)((double)z - (double)vec.method_10260() * this.thickness);
                    quad.pos(i, x, y, z);
                }
            }
        }
        return true;
    }

    private static boolean epsComp(float a, float b) {
        if (a == b) {
            return true;
        }
        return (double)Math.abs(a - b) < 1.0E-5;
    }

    public static enum Corner {
        MIN_X_MIN_Y_MIN_Z(class_2350.class_2352.field_11060, class_2350.class_2352.field_11060, class_2350.class_2352.field_11060),
        MIN_X_MIN_Y_MAX_Z(class_2350.class_2352.field_11060, class_2350.class_2352.field_11060, class_2350.class_2352.field_11056),
        MIN_X_MAX_Y_MIN_Z(class_2350.class_2352.field_11060, class_2350.class_2352.field_11056, class_2350.class_2352.field_11060),
        MIN_X_MAX_Y_MAX_Z(class_2350.class_2352.field_11060, class_2350.class_2352.field_11056, class_2350.class_2352.field_11056),
        MAX_X_MIN_Y_MIN_Z(class_2350.class_2352.field_11056, class_2350.class_2352.field_11060, class_2350.class_2352.field_11060),
        MAX_X_MIN_Y_MAX_Z(class_2350.class_2352.field_11056, class_2350.class_2352.field_11060, class_2350.class_2352.field_11056),
        MAX_X_MAX_Y_MIN_Z(class_2350.class_2352.field_11056, class_2350.class_2352.field_11056, class_2350.class_2352.field_11060),
        MAX_X_MAX_Y_MAX_Z(class_2350.class_2352.field_11056, class_2350.class_2352.field_11056, class_2350.class_2352.field_11056);

        private class_2350.class_2352 xAxis;
        private class_2350.class_2352 yAxis;
        private class_2350.class_2352 zAxis;
        private static final int[] sideMask;

        private Corner(class_2350.class_2352 xAxis, class_2350.class_2352 yAxis, class_2350.class_2352 zAxis) {
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            this.zAxis = zAxis;
        }

        public static Corner fromSides(int sideA, int sideB, int sideC) {
            return Corner.values()[sideMask[sideA] | sideMask[sideB] | sideMask[sideC]];
        }

        public float pX(class_238 box) {
            return (float)(this.xAxis == class_2350.class_2352.field_11060 ? box.field_1323 : box.field_1320);
        }

        public float pY(class_238 box) {
            return (float)(this.yAxis == class_2350.class_2352.field_11060 ? box.field_1322 : box.field_1325);
        }

        public float pZ(class_238 box) {
            return (float)(this.zAxis == class_2350.class_2352.field_11060 ? box.field_1321 : box.field_1324);
        }

        static {
            sideMask = new int[]{0, 2, 0, 1, 0, 4};
        }
    }
}

