/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.content.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.impl.content.registry.FireBlockHooks;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class FlammableBlockRegistryImpl
implements FlammableBlockRegistry,
SimpleSynchronousResourceReloadListener {
    private static final FlammableBlockRegistry.Entry REMOVED = new FlammableBlockRegistry.Entry(0, 0);
    private static final Map<class_2248, FlammableBlockRegistryImpl> REGISTRIES = new HashMap<class_2248, FlammableBlockRegistryImpl>();
    private static final Collection<class_2960> RELOAD_DEPS = Collections.singletonList(ResourceReloadListenerKeys.TAGS);
    private static int idCounter = 0;
    private final Map<class_2248, FlammableBlockRegistry.Entry> registeredEntriesBlock = new HashMap<class_2248, FlammableBlockRegistry.Entry>();
    private final Map<class_6862<class_2248>, FlammableBlockRegistry.Entry> registeredEntriesTag = new HashMap<class_6862<class_2248>, FlammableBlockRegistry.Entry>();
    private final Map<class_2248, FlammableBlockRegistry.Entry> computedEntries = new HashMap<class_2248, FlammableBlockRegistry.Entry>();
    private final class_2960 id;
    private final class_2248 key;
    private boolean tagsPresent = false;

    private FlammableBlockRegistryImpl(class_2248 key) {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)this);
        this.id = new class_2960("fabric:private/fire_registry_" + ++idCounter);
        this.key = key;
    }

    public void method_14491(class_3300 var1) {
        this.reload();
        this.tagsPresent = true;
    }

    private void reload() {
        this.computedEntries.clear();
        for (class_6862<class_2248> tag : this.registeredEntriesTag.keySet()) {
            FlammableBlockRegistry.Entry entry = this.registeredEntriesTag.get(tag);
            for (class_6880 block : class_2378.field_11146.method_40286(tag)) {
                this.computedEntries.put((class_2248)block.comp_349(), entry);
            }
        }
        this.computedEntries.putAll(this.registeredEntriesBlock);
    }

    @Override
    public FlammableBlockRegistry.Entry get(class_2248 block) {
        FlammableBlockRegistry.Entry entry = this.computedEntries.get(block);
        if (entry != null) {
            return entry;
        }
        return ((FireBlockHooks)this.key).fabric_getVanillaEntry(block.method_9564());
    }

    public FlammableBlockRegistry.Entry getFabric(class_2248 block) {
        return this.computedEntries.get(block);
    }

    @Override
    public void add(class_2248 block, FlammableBlockRegistry.Entry value) {
        this.registeredEntriesBlock.put(block, value);
        if (this.tagsPresent) {
            this.reload();
        }
    }

    @Override
    public void add(class_6862<class_2248> tag, FlammableBlockRegistry.Entry value) {
        this.registeredEntriesTag.put(tag, value);
        if (this.tagsPresent) {
            this.reload();
        }
    }

    @Override
    public void remove(class_2248 block) {
        this.add(block, REMOVED);
    }

    @Override
    public void remove(class_6862<class_2248> tag) {
        this.add(tag, REMOVED);
    }

    @Override
    public void clear(class_2248 block) {
        this.registeredEntriesBlock.remove(block);
        if (this.tagsPresent) {
            this.reload();
        }
    }

    @Override
    public void clear(class_6862<class_2248> tag) {
        this.registeredEntriesTag.remove(tag);
        if (this.tagsPresent) {
            this.reload();
        }
    }

    public static FlammableBlockRegistryImpl getInstance(class_2248 block) {
        if (!(block instanceof FireBlockHooks)) {
            throw new RuntimeException("Not a hookable fire block: " + block);
        }
        return REGISTRIES.computeIfAbsent(block, FlammableBlockRegistryImpl::new);
    }

    public class_2960 getFabricId() {
        return this.id;
    }

    public Collection<class_2960> getFabricDependencies() {
        return RELOAD_DEPS;
    }
}

