/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.fabricmc.fabric.impl.registry.sync.packet.DirectRegistryPacketHandler;
import net.fabricmc.fabric.impl.registry.sync.packet.NbtRegistryPacketHandler;
import net.fabricmc.fabric.impl.registry.sync.packet.RegistryPacketHandler;
import net.minecraft.class_1255;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistrySyncManager {
    public static final boolean DEBUG = Boolean.getBoolean("fabric.registry.debug");
    @Deprecated
    public static final RegistryPacketHandler NBT_PACKET_HANDLER = new NbtRegistryPacketHandler();
    public static final RegistryPacketHandler DIRECT_PACKET_HANDLER = new DirectRegistryPacketHandler();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FabricRegistrySync");
    private static final boolean DEBUG_WRITE_REGISTRY_DATA = Boolean.getBoolean("fabric.registry.debug.writeContentsAsCsv");
    private static final boolean FORCE_NBT_SYNC = Boolean.getBoolean("fabric.registry.forceNbtSync");
    public static boolean postBootstrap = false;

    private RegistrySyncManager() {
    }

    public static void sendPacket(MinecraftServer server, class_3222 player) {
        if (!DEBUG && server.method_19466(player.method_7334())) {
            return;
        }
        if (FORCE_NBT_SYNC) {
            LOGGER.warn("Force NBT sync is enabled");
            RegistrySyncManager.sendPacket(player, NBT_PACKET_HANDLER);
            return;
        }
        if (ServerPlayNetworking.canSend((class_3222)player, (class_2960)DIRECT_PACKET_HANDLER.getPacketId())) {
            RegistrySyncManager.sendPacket(player, DIRECT_PACKET_HANDLER);
        } else {
            LOGGER.debug("Player {} can't receive direct packet, using nbt packet instead", (Object)player.method_5820());
            RegistrySyncManager.sendPacket(player, NBT_PACKET_HANDLER);
        }
    }

    private static void sendPacket(class_3222 player, RegistryPacketHandler handler) {
        Map<class_2960, Object2IntMap<class_2960>> map = RegistrySyncManager.createAndPopulateRegistryMap(true, null);
        if (map != null) {
            handler.sendPacket(player, map);
        }
    }

    public static void receivePacket(class_1255<?> executor, RegistryPacketHandler handler, class_2540 buf, boolean accept, Consumer<Exception> errorHandler) {
        handler.receivePacket(buf);
        if (!handler.isPacketFinished()) {
            return;
        }
        if (DEBUG) {
            String handlerName = handler.getClass().getSimpleName();
            LOGGER.info("{} total packet: {}", (Object)handlerName, (Object)handler.getTotalPacketReceived());
            LOGGER.info("{} raw size: {}", (Object)handlerName, (Object)handler.getRawBufSize());
            LOGGER.info("{} deflated size: {}", (Object)handlerName, (Object)handler.getDeflatedBufSize());
        }
        Map<class_2960, Object2IntMap<class_2960>> map = handler.getSyncedRegistryMap();
        if (accept) {
            try {
                executor.method_5385(() -> {
                    if (map == null) {
                        errorHandler.accept(new RemapException("Received null map in sync packet!"));
                        return null;
                    }
                    try {
                        RegistrySyncManager.apply(map, RemappableRegistry.RemapMode.REMOTE);
                    }
                    catch (RemapException e) {
                        errorHandler.accept(e);
                    }
                    return null;
                }).get(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                errorHandler.accept(e);
            }
        }
    }

    @Nullable
    public static Map<class_2960, Object2IntMap<class_2960>> createAndPopulateRegistryMap(boolean isClientSync, @Nullable Map<class_2960, Object2IntMap<class_2960>> activeMap) {
        LinkedHashMap<class_2960, Object2IntMap<class_2960>> map = new LinkedHashMap<class_2960, Object2IntMap<class_2960>>();
        for (class_2960 registryId : class_2378.field_11144.method_10235()) {
            RegistryAttributeHolder attributeHolder;
            class_2378 registry = (class_2378)class_2378.field_11144.method_10223(registryId);
            if (DEBUG_WRITE_REGISTRY_DATA) {
                File location = new File(".fabric" + File.separatorChar + "debug" + File.separatorChar + "registry");
                boolean c = true;
                if (!location.exists() && !location.mkdirs()) {
                    LOGGER.warn("[fabric-registry-sync debug] Could not create " + location.getAbsolutePath() + " directory!");
                    c = false;
                }
                if (c && registry != null) {
                    File file = new File(location, registryId.toString().replace(':', '.').replace('/', '.') + ".csv");
                    try (FileOutputStream stream = new FileOutputStream(file);){
                        StringBuilder builder = new StringBuilder("Raw ID,String ID,Class Type\n");
                        for (Object o : registry) {
                            String classType = o == null ? "null" : o.getClass().getName();
                            class_2960 id = registry.method_10221(o);
                            if (id == null) continue;
                            int rawId = registry.method_10206(o);
                            String stringId = id.toString();
                            builder.append("\"").append(rawId).append("\",\"").append(stringId).append("\",\"").append(classType).append("\"\n");
                        }
                        stream.write(builder.toString().getBytes(StandardCharsets.UTF_8));
                    }
                    catch (IOException e) {
                        LOGGER.warn("[fabric-registry-sync debug] Could not write to " + file.getAbsolutePath() + "!", (Throwable)e);
                    }
                }
            }
            Object2IntMap<class_2960> previousIdMap = null;
            if (activeMap != null && activeMap.containsKey(registryId)) {
                previousIdMap = activeMap.get(registryId);
            }
            if (!(attributeHolder = RegistryAttributeHolder.get(registry)).hasAttribute(isClientSync ? RegistryAttribute.SYNCED : RegistryAttribute.PERSISTED)) {
                LOGGER.debug("Not {} registry: {}", (Object)(isClientSync ? "syncing" : "saving"), (Object)registryId);
                continue;
            }
            if ((previousIdMap == null || isClientSync) && !attributeHolder.hasAttribute(RegistryAttribute.MODDED)) {
                LOGGER.debug("Skipping un-modded registry: " + registryId);
                continue;
            }
            if (previousIdMap != null) {
                LOGGER.debug("Preserving previously modded registry: " + registryId);
            }
            if (isClientSync) {
                LOGGER.debug("Syncing registry: " + registryId);
            } else {
                LOGGER.debug("Saving registry: " + registryId);
            }
            if (!(registry instanceof RemappableRegistry)) continue;
            Object2IntLinkedOpenHashMap idMap = new Object2IntLinkedOpenHashMap();
            IntOpenHashSet rawIdsFound = DEBUG ? new IntOpenHashSet() : null;
            for (Object o : registry) {
                class_2960 id = registry.method_10221(o);
                if (id == null) continue;
                int rawId = registry.method_10206(o);
                if (DEBUG) {
                    if (registry.method_10223(id) != o) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + registryId + ": object " + o + " -> string ID " + id + " -> object " + registry.method_10223(id) + "!");
                    }
                    if (registry.method_10200(rawId) != o) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + registryId + ": object " + o + " -> integer ID " + rawId + " -> object " + registry.method_10200(rawId) + "!");
                    }
                    if (!rawIdsFound.add(rawId)) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + registryId + ": multiple objects hold the raw ID " + rawId + " (this one is " + id + ")");
                    }
                }
                idMap.put((Object)id, rawId);
            }
            if (!isClientSync && previousIdMap != null) {
                for (class_2960 key : previousIdMap.keySet()) {
                    if (idMap.containsKey((Object)key)) continue;
                    LOGGER.debug("Saving orphaned registry entry: " + key);
                    idMap.put((Object)key, previousIdMap.getInt((Object)key));
                }
            }
            map.put(registryId, (Object2IntMap<class_2960>)idMap);
        }
        if (!isClientSync && activeMap != null) {
            for (class_2960 registryKey : activeMap.keySet()) {
                if (map.containsKey(registryKey)) continue;
                LOGGER.debug("Saving orphaned registry: " + registryKey);
                map.put(registryKey, activeMap.get(registryKey));
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public static void apply(Map<class_2960, Object2IntMap<class_2960>> map, RemappableRegistry.RemapMode mode) throws RemapException {
        HashSet containedRegistries = Sets.newHashSet(map.keySet());
        for (class_2960 registryId : class_2378.field_11144.method_10235()) {
            if (!containedRegistries.remove(registryId)) continue;
            Object2IntMap<class_2960> registryMap = map.get(registryId);
            class_2378 registry = (class_2378)class_2378.field_11144.method_10223(registryId);
            RegistryAttributeHolder attributeHolder = RegistryAttributeHolder.get(registry);
            if (!attributeHolder.hasAttribute(RegistryAttribute.MODDED)) {
                LOGGER.debug("Not applying registry data to vanilla registry {}", (Object)registryId.toString());
                continue;
            }
            if (!(registry instanceof RemappableRegistry)) continue;
            Object2IntOpenHashMap idMap = new Object2IntOpenHashMap();
            for (class_2960 key : registryMap.keySet()) {
                idMap.put((Object)key, registryMap.getInt((Object)key));
            }
            ((RemappableRegistry)registry).remap(registryId.toString(), (Object2IntMap<class_2960>)idMap, mode);
        }
        if (!containedRegistries.isEmpty()) {
            LOGGER.warn("[fabric-registry-sync] Could not find the following registries: " + Joiner.on((String)", ").join((Iterable)containedRegistries));
        }
    }

    public static void unmap() throws RemapException {
        for (class_2960 registryId : class_2378.field_11144.method_10235()) {
            class_2378 registry = (class_2378)class_2378.field_11144.method_10223(registryId);
            if (!(registry instanceof RemappableRegistry)) continue;
            ((RemappableRegistry)registry).unmap(registryId.toString());
        }
    }

    public static void bootstrapRegistries() {
        postBootstrap = true;
    }
}

