/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.mixin.content.registry.AxeItemAccessor;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StrippableBlockRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrippableBlockRegistry.class);

    private StrippableBlockRegistry() {
    }

    public static void register(class_2248 input, class_2248 stripped) {
        class_2248 old;
        StrippableBlockRegistry.requireNonNullAndAxisProperty(input, "input block");
        StrippableBlockRegistry.requireNonNullAndAxisProperty(stripped, "stripped block");
        Map<class_2248, class_2248> strippedBlocks = AxeItemAccessor.getStrippedBlocks();
        if (!(strippedBlocks instanceof HashMap)) {
            strippedBlocks = new HashMap<class_2248, class_2248>(strippedBlocks);
            AxeItemAccessor.setStrippedBlocks(strippedBlocks);
        }
        if ((old = strippedBlocks.put(input, stripped)) != null) {
            LOGGER.debug("Replaced old stripping mapping from {} to {} with {}", new Object[]{input, old, stripped});
        }
    }

    private static void requireNonNullAndAxisProperty(class_2248 block, String name) {
        Objects.requireNonNull(block, name + " cannot be null");
        if (!block.method_9595().method_11659().contains(class_2741.field_12496)) {
            throw new IllegalArgumentException(name + " must have the 'axis' property");
        }
    }
}

