/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering.fluid;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1163;
import net.minecraft.class_1723;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2373;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4588;
import net.minecraft.class_5458;
import net.minecraft.class_775;

public class FluidRenderHandlerRegistryImpl
implements FluidRenderHandlerRegistry {
    private static final int DEFAULT_WATER_COLOR = ((class_1959)class_5458.field_25933.method_29107(class_1972.field_9423)).method_8687();
    private final Map<class_3611, FluidRenderHandler> handlers = new IdentityHashMap<class_3611, FluidRenderHandler>();
    private final Map<class_3611, FluidRenderHandler> modHandlers = new IdentityHashMap<class_3611, FluidRenderHandler>();
    private final Map<class_2248, Boolean> overlayBlocks = new IdentityHashMap<class_2248, Boolean>();
    private class_775 fluidRenderer;

    @Override
    public FluidRenderHandler get(class_3611 fluid) {
        return this.handlers.get(fluid);
    }

    public FluidRenderHandler getOverride(class_3611 fluid) {
        return this.modHandlers.get(fluid);
    }

    @Override
    public void register(class_3611 fluid, FluidRenderHandler renderer) {
        this.handlers.put(fluid, renderer);
        this.modHandlers.put(fluid, renderer);
    }

    @Override
    public void setBlockTransparency(class_2248 block, boolean transparent) {
        this.overlayBlocks.put(block, transparent);
    }

    @Override
    public boolean isBlockTransparent(class_2248 block) {
        return this.overlayBlocks.computeIfAbsent(block, k -> k instanceof class_2373 || k instanceof class_2397);
    }

    public void onFluidRendererReload(class_775 renderer, class_1058[] waterSprites, final class_1058[] lavaSprites, class_1058 waterOverlay) {
        this.fluidRenderer = renderer;
        final class_1058[] waterSpritesFull = new class_1058[]{waterSprites[0], waterSprites[1], waterOverlay};
        FluidRenderHandler waterHandler = new FluidRenderHandler(){

            @Override
            public class_1058[] getFluidSprites(class_1920 view, class_2338 pos, class_3610 state) {
                return waterSpritesFull;
            }

            @Override
            public int getFluidColor(class_1920 view, class_2338 pos, class_3610 state) {
                if (view != null && pos != null) {
                    return class_1163.method_4961((class_1920)view, (class_2338)pos);
                }
                return DEFAULT_WATER_COLOR;
            }
        };
        FluidRenderHandler lavaHandler = new FluidRenderHandler(){

            @Override
            public class_1058[] getFluidSprites(class_1920 view, class_2338 pos, class_3610 state) {
                return lavaSprites;
            }
        };
        this.register((class_3611)class_3612.field_15910, waterHandler);
        this.register((class_3611)class_3612.field_15909, waterHandler);
        this.register((class_3611)class_3612.field_15908, lavaHandler);
        this.register((class_3611)class_3612.field_15907, lavaHandler);
        this.handlers.putAll(this.modHandlers);
        class_1059 texture = class_310.method_1551().method_1554().method_24153(class_1723.field_21668);
        for (FluidRenderHandler handler : this.handlers.values()) {
            handler.reloadTextures(texture);
        }
    }

    public boolean renderFluid(class_2338 pos, class_1920 world, class_4588 vertexConsumer, class_2680 blockState, class_3610 fluidState) {
        return this.fluidRenderer.method_3347(world, pos, vertexConsumer, blockState, fluidState);
    }
}

