/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.spatial;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.SpatialPylonCalculator;
import appeng.me.cluster.implementations.SpatialPylonCluster;
import appeng.util.iterators.ChainedIterator;
import com.google.common.collect.Iterators;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class SpatialPylonBlockEntity
extends AENetworkBlockEntity
implements IAEMultiBlock<SpatialPylonCluster> {
    public static final int DISPLAY_END_MIN = 1;
    public static final int DISPLAY_END_MAX = 2;
    public static final int DISPLAY_MIDDLE = 3;
    public static final int DISPLAY_X = 4;
    public static final int DISPLAY_Y = 8;
    public static final int DISPLAY_Z = 12;
    public static final int MB_STATUS = 15;
    public static final int DISPLAY_ENABLED = 16;
    public static final int DISPLAY_POWERED_ENABLED = 32;
    public static final int NET_STATUS = 48;
    private final SpatialPylonCalculator calc = new SpatialPylonCalculator(this);
    private int displayBits = 0;
    private SpatialPylonCluster cluster;

    public SpatialPylonBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL, GridFlags.MULTIBLOCK).setIdlePowerUsage(0.5).addService(IGridMultiblock.class, this::getMultiblockNodes);
    }

    @Override
    public void onChunkUnloaded() {
        this.disconnect(false);
        super.onChunkUnloaded();
    }

    @Override
    public void onReady() {
        super.onReady();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.calc.calculateMultiblock(serverLevel, this.field_11867);
        }
    }

    @Override
    public void method_11012() {
        super.method_11012();
        this.disconnect(false);
    }

    public void neighborChanged(class_2338 changedPos) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.calc.updateMultiblockAfterNeighborUpdate(serverLevel, this.field_11867, changedPos);
        }
    }

    @Override
    public void disconnect(boolean b) {
        if (this.cluster != null) {
            this.cluster.destroy();
            this.updateStatus(null);
        }
    }

    @Override
    public SpatialPylonCluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public void updateStatus(SpatialPylonCluster c) {
        if (this.method_11015()) {
            return;
        }
        this.cluster = c;
        this.getMainNode().setExposedOnSides(c == null ? EnumSet.noneOf(class_2350.class) : EnumSet.allOf(class_2350.class));
        this.recalculateDisplay();
    }

    public void recalculateDisplay() {
        int oldBits = this.displayBits;
        this.displayBits = 0;
        if (this.cluster != null) {
            this.displayBits = this.cluster.getBoundsMin().equals((Object)this.field_11867) ? 1 : (this.cluster.getBoundsMax().equals((Object)this.field_11867) ? 2 : 3);
            switch (this.cluster.getCurrentAxis()) {
                case X: {
                    this.displayBits |= 4;
                    break;
                }
                case Y: {
                    this.displayBits |= 8;
                    break;
                }
                case Z: {
                    this.displayBits |= 0xC;
                    break;
                }
                default: {
                    this.displayBits = 0;
                }
            }
            if (this.getMainNode().isPowered()) {
                this.displayBits |= 0x20;
            }
            if (this.cluster.isValid() && this.getMainNode().isActive()) {
                this.displayBits |= 0x10;
            }
        }
        if (oldBits != this.displayBits) {
            this.markForUpdate();
        }
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        int old = this.displayBits;
        this.displayBits = data.readByte();
        return old != this.displayBits || c;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeByte(this.displayBits);
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.recalculateDisplay();
        }
    }

    public int getDisplayBits() {
        return this.displayBits;
    }

    @Override
    public Object getRenderAttachmentData() {
        return this.getDisplayBits();
    }

    private Iterator<IGridNode> getMultiblockNodes() {
        if (this.getCluster() == null) {
            return new ChainedIterator<IGridNode>(new IGridNode[0]);
        }
        return Iterators.transform(this.getCluster().getBlockEntities(), AENetworkBlockEntity::getGridNode);
    }
}

