/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.iface;

import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.util.IConfigManager;
import appeng.core.settings.TickRates;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.iface.PatternProviderLogicHost;
import appeng.helpers.iface.PatternProviderReturnInventory;
import appeng.helpers.iface.PatternProviderTarget;
import appeng.me.helpers.MachineSource;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;

public class PatternProviderLogic
implements InternalInventoryHost,
ICraftingProvider {
    public static final int NUMBER_OF_PATTERN_SLOTS = 9;
    private final PatternProviderLogicHost host;
    private final IManagedGridNode mainNode;
    private final IActionSource actionSource;
    private final ConfigManager configManager = new ConfigManager();
    private int priority;
    private final AppEngInternalInventory patternInventory = new AppEngInternalInventory(this, 9);
    private final List<IPatternDetails> patterns = new ArrayList<IPatternDetails>();
    private final Set<AEKey> patternInputs = new HashSet<AEKey>();
    private final List<GenericStack> sendList = new ArrayList<GenericStack>();
    private class_2350 sendDirection;
    private final PatternProviderReturnInventory returnInv;
    private static final Collection<class_2248> BAD_BLOCKS = new HashSet<class_2248>(100);

    public PatternProviderLogic(IManagedGridNode mainNode, PatternProviderLogicHost host) {
        this.host = host;
        this.mainNode = mainNode.setFlags(GridFlags.REQUIRE_CHANNEL).addService(IGridTickable.class, new Ticker()).addService(ICraftingProvider.class, this);
        this.actionSource = new MachineSource(mainNode::getNode);
        this.configManager.registerSetting(Settings.BLOCKING_MODE, YesNo.NO);
        this.configManager.registerSetting(Settings.PATTERN_ACCESS_TERMINAL, YesNo.YES);
        this.returnInv = new PatternProviderReturnInventory(() -> this.mainNode.ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node)));
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.host.saveChanges();
        ICraftingProvider.requestUpdate(this.mainNode);
    }

    public void writeToNBT(class_2487 tag) {
        this.configManager.writeToNBT(tag);
        this.patternInventory.writeToNBT(tag, "patterns");
        tag.method_10569("priority", this.priority);
        class_2499 sendListTag = new class_2499();
        for (GenericStack toSend : this.sendList) {
            sendListTag.add((Object)GenericStack.writeTag(toSend));
        }
        tag.method_10566("sendList", (class_2520)sendListTag);
        if (this.sendDirection != null) {
            tag.method_10567("sendDirection", (byte)this.sendDirection.method_10146());
        }
        tag.method_10566("returnInv", (class_2520)this.returnInv.writeToTag());
    }

    public void readFromNBT(class_2487 tag) {
        this.configManager.readFromNBT(tag);
        this.patternInventory.readFromNBT(tag, "patterns");
        this.priority = tag.method_10550("priority");
        class_2499 sendListTag = tag.method_10554("sendList", 10);
        for (int i = 0; i < sendListTag.size(); ++i) {
            GenericStack stack = GenericStack.readTag(sendListTag.method_10602(i));
            if (stack == null) continue;
            this.addToSendList(stack.what(), stack.amount());
        }
        if (tag.method_10545("sendDirection")) {
            this.sendDirection = class_2350.method_10143((int)tag.method_10571("sendDirection"));
        }
        this.returnInv.readFromTag(tag.method_10554("returnInv", 10));
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    public void saveChanges() {
        this.host.saveChanges();
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        this.saveChanges();
        this.updatePatterns();
    }

    @Override
    public boolean isClientSide() {
        class_1937 level = this.host.getBlockEntity().method_10997();
        return level == null || level.method_8608();
    }

    public void updatePatterns() {
        this.patterns.clear();
        this.patternInputs.clear();
        for (class_1799 stack : this.patternInventory) {
            IPatternDetails details = PatternDetailsHelper.decodePattern(stack, this.host.getBlockEntity().method_10997());
            if (details == null) continue;
            this.patterns.add(details);
            for (IPatternDetails.IInput iinput : details.getInputs()) {
                for (GenericStack inputCandidate : iinput.getPossibleInputs()) {
                    this.patternInputs.add(inputCandidate.what().dropSecondary());
                }
            }
        }
        ICraftingProvider.requestUpdate(this.mainNode);
    }

    @Override
    public List<IPatternDetails> getAvailablePatterns() {
        return this.patterns;
    }

    @Override
    public int getPatternPriority() {
        return this.priority;
    }

    @Override
    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!(this.sendList.isEmpty() && this.mainNode.isActive() && this.patterns.contains(patternDetails))) {
            return false;
        }
        class_2586 be = this.host.getBlockEntity();
        class_1937 level = be.method_10997();
        for (class_2350 direction : this.host.getTargets()) {
            PatternProviderLogicHost adjHost;
            class_2338 adjPos = be.method_11016().method_10093(direction);
            class_2586 adjBe = level.method_8321(adjPos);
            class_2350 adjBeSide = direction.method_10153();
            if (adjBe instanceof PatternProviderLogicHost && (adjHost = (PatternProviderLogicHost)adjBe).getLogic().sameGrid(this.mainNode.getGrid())) continue;
            ICraftingMachine craftingMachine = ICraftingMachine.of(adjBe, adjBeSide);
            if (craftingMachine != null && craftingMachine.acceptsPlans()) {
                if (!craftingMachine.pushPattern(patternDetails, inputHolder, adjBeSide)) continue;
                return true;
            }
            PatternProviderTarget adapter = PatternProviderTarget.get(level, adjPos, adjBe, adjBeSide, this.actionSource);
            if (adapter == null || this.isBlocking() && adapter.containsPatternInput(this.patternInputs) || !this.adapterAcceptsAll(adapter, inputHolder)) continue;
            for (KeyCounter inputList : inputHolder) {
                for (Object2LongMap.Entry<AEKey> input : inputList) {
                    long amount;
                    AEKey what = (AEKey)input.getKey();
                    long inserted = adapter.insert(what, amount = input.getLongValue(), Actionable.MODULATE);
                    if (inserted >= amount) continue;
                    this.addToSendList(what, amount - inserted);
                }
            }
            this.sendDirection = direction;
            this.sendStacksOut();
            return true;
        }
        return false;
    }

    private boolean sameGrid(@Nullable IGrid grid) {
        return grid != null && grid == this.mainNode.getGrid();
    }

    public boolean isBlocking() {
        return this.configManager.getSetting(Settings.BLOCKING_MODE) == YesNo.YES;
    }

    private boolean adapterAcceptsAll(PatternProviderTarget target, KeyCounter[] inputHolder) {
        for (KeyCounter inputList : inputHolder) {
            for (Object2LongMap.Entry<AEKey> input : inputList) {
                long inserted = target.insert((AEKey)input.getKey(), input.getLongValue(), Actionable.SIMULATE);
                if (inserted != 0L) continue;
                return false;
            }
        }
        return true;
    }

    private void addToSendList(AEKey what, long amount) {
        if (amount > 0L) {
            this.sendList.add(new GenericStack(what, amount));
            this.mainNode.ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
        }
    }

    private boolean sendStacksOut() {
        class_2586 adjBe;
        class_2338 adjPos;
        if (this.sendDirection == null) {
            if (!this.sendList.isEmpty()) {
                throw new IllegalStateException("Invalid pattern provider state, this is a bug.");
            }
            return false;
        }
        class_2586 be = this.host.getBlockEntity();
        class_1937 level = be.method_10997();
        PatternProviderTarget adapter = PatternProviderTarget.get(level, adjPos = be.method_11016().method_10093(this.sendDirection), adjBe = level.method_8321(adjPos), this.sendDirection.method_10153(), this.actionSource);
        if (adapter == null) {
            return false;
        }
        boolean didSomething = false;
        ListIterator<GenericStack> it = this.sendList.listIterator();
        while (it.hasNext()) {
            long amount;
            GenericStack stack = it.next();
            AEKey what = stack.what();
            long inserted = adapter.insert(what, amount = stack.amount(), Actionable.MODULATE);
            if (inserted >= amount) {
                it.remove();
                didSomething = true;
                continue;
            }
            if (inserted <= 0L) continue;
            it.set(new GenericStack(what, amount - inserted));
            didSomething = true;
        }
        if (this.sendList.isEmpty()) {
            this.sendDirection = null;
        }
        return didSomething;
    }

    @Override
    public boolean isBusy() {
        return !this.sendList.isEmpty();
    }

    private boolean hasWorkToDo() {
        return !this.sendList.isEmpty() || !this.returnInv.isEmpty();
    }

    private boolean doWork() {
        return this.returnInv.injectIntoNetwork(this.mainNode.getGrid().getStorageService().getInventory(), this.actionSource) | this.sendStacksOut();
    }

    public InternalInventory getPatternInv() {
        return this.patternInventory;
    }

    public void onMainNodeStateChanged() {
        ICraftingProvider.requestUpdate(this.mainNode);
        if (this.mainNode.hasGridBooted()) {
            this.mainNode.ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
        }
    }

    public void addDrops(List<class_1799> drops) {
        for (class_1799 class_17992 : this.patternInventory) {
            drops.add(class_17992);
        }
        for (GenericStack genericStack : this.sendList) {
            genericStack.what().addDrops(genericStack.amount(), drops, this.host.getBlockEntity().method_10997(), this.host.getBlockEntity().method_11016());
        }
        this.returnInv.addDrops(drops, this.host.getBlockEntity().method_10997(), this.host.getBlockEntity().method_11016());
    }

    public PatternProviderReturnInventory getReturnInv() {
        return this.returnInv;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public class_2561 getTermName() {
        class_2248 directedBlock;
        class_2586 host = this.host.getBlockEntity();
        class_1937 hostWorld = host.method_10997();
        if (((ICustomNameObject)((Object)this.host)).hasCustomInventoryName()) {
            return ((ICustomNameObject)((Object)this.host)).getCustomInventoryName();
        }
        Iterator iterator = this.host.getTargets().iterator();
        while (true) {
            Optional<class_2561> displayName;
            PatternProviderLogicHost interfaceHost;
            if (!iterator.hasNext()) {
                return new class_2585("Nothing");
            }
            class_2350 direction = (class_2350)iterator.next();
            class_2338 targ = host.method_11016().method_10093(direction);
            class_2586 directedBlockEntity = hostWorld.method_8321(targ);
            if (directedBlockEntity == null || directedBlockEntity instanceof PatternProviderLogicHost && (interfaceHost = (PatternProviderLogicHost)directedBlockEntity).getLogic().sameGrid(this.mainNode.getGrid())) continue;
            ICraftingMachine craftingMachine = ICraftingMachine.of(directedBlockEntity, direction.method_10153());
            if (craftingMachine != null && (displayName = craftingMachine.getDisplayName()).isPresent()) {
                return displayName.get();
            }
            ItemTransfer adaptor = InternalInventory.wrapExternal(directedBlockEntity, direction.method_10153());
            if (adaptor == null || !adaptor.mayAllowTransfer()) continue;
            class_2680 directedBlockState = hostWorld.method_8320(targ);
            directedBlock = directedBlockState.method_26204();
            class_1799 what = new class_1799((class_1935)directedBlock, 1);
            try {
                class_243 from = new class_243((double)host.method_11016().method_10263() + 0.5, (double)host.method_11016().method_10264() + 0.5, (double)host.method_11016().method_10260() + 0.5);
                from = from.method_1031((double)direction.method_10148() * 0.501, (double)direction.method_10164() * 0.501, (double)direction.method_10165() * 0.501);
                class_243 to = from.method_1031((double)direction.method_10148(), (double)direction.method_10164(), (double)direction.method_10165());
                Object hit = null;
                if (hit != null && !BAD_BLOCKS.contains(directedBlock) && !hit.method_17777().equals((Object)directedBlockEntity.method_11016())) {
                    // empty if block
                }
            }
            catch (Throwable t) {
                BAD_BLOCKS.add(directedBlock);
            }
            if (what.method_7909() != class_1802.field_8162) {
                return new class_2588(what.method_7922());
            }
            class_1792 item = class_1792.method_7867((class_2248)directedBlock);
            if (item == class_1802.field_8162) break;
        }
        return new class_2588(directedBlock.method_9539());
    }

    public long getSortValue() {
        class_2586 te = this.host.getBlockEntity();
        return te.method_11016().method_10260() << 24 ^ te.method_11016().method_10263() << 8 ^ te.method_11016().method_10264();
    }

    private class Ticker
    implements IGridTickable {
        private Ticker() {
        }

        @Override
        public TickingRequest getTickingRequest(IGridNode node) {
            return new TickingRequest(TickRates.Interface, !PatternProviderLogic.this.hasWorkToDo(), true);
        }

        @Override
        public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
            if (!PatternProviderLogic.this.mainNode.isActive()) {
                return TickRateModulation.SLEEP;
            }
            boolean couldDoWork = PatternProviderLogic.this.doWork();
            return PatternProviderLogic.this.hasWorkToDo() ? (couldDoWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER) : TickRateModulation.SLEEP;
        }
    }
}

