/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import appeng.api.parts.IPart;
import appeng.core.localization.InGameTooltip;
import appeng.integration.modules.waila.part.IPartDataProvider;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;

public final class P2PStateDataProvider
implements IPartDataProvider {
    private static final byte STATE_UNLINKED = 0;
    private static final byte STATE_OUTPUT = 1;
    private static final byte STATE_INPUT = 2;
    public static final String TAG_P2P_STATE = "p2pState";
    public static final String TAG_P2P_OUTPUTS = "p2pOutputs";
    public static final String TAG_P2P_FREQUENCY = "p2pFrequency";

    @Override
    public void appendBody(IPart part, class_2487 partTag, List<class_2561> tooltip) {
        if (partTag.method_10573(TAG_P2P_STATE, 1)) {
            byte state = partTag.method_10571(TAG_P2P_STATE);
            int outputs = partTag.method_10550(TAG_P2P_OUTPUTS);
            switch (state) {
                case 0: {
                    tooltip.add((class_2561)InGameTooltip.P2PUnlinked.text());
                    break;
                }
                case 1: {
                    tooltip.add((class_2561)InGameTooltip.P2POutput.text());
                    break;
                }
                case 2: {
                    tooltip.add(P2PStateDataProvider.getOutputText(outputs));
                }
            }
            short freq = partTag.method_10568(TAG_P2P_FREQUENCY);
            String freqTooltip = Platform.p2p().toHexString(freq);
            tooltip.add((class_2561)new class_2588("gui.tooltips.ae2.P2PFrequency", new Object[]{freqTooltip}));
        }
    }

    @Override
    public void appendServerData(class_3222 player, IPart part, class_2487 partTag) {
        if (part instanceof P2PTunnelPart) {
            P2PTunnelPart p2pTunnel = (P2PTunnelPart)part;
            if (!p2pTunnel.isPowered()) {
                return;
            }
            partTag.method_10575(TAG_P2P_FREQUENCY, p2pTunnel.getFrequency());
            int state = 0;
            if (!p2pTunnel.isOutput()) {
                int outputCount = p2pTunnel.getOutputs().size();
                if (outputCount > 0) {
                    state = 2;
                    partTag.method_10569(TAG_P2P_OUTPUTS, outputCount);
                }
            } else if (p2pTunnel.getInput() != null) {
                state = 1;
            }
            partTag.method_10567(TAG_P2P_STATE, (byte)state);
        }
    }

    private static class_2561 getOutputText(int outputs) {
        if (outputs <= 1) {
            return InGameTooltip.P2PInputOneOutput.text();
        }
        return InGameTooltip.P2PInputManyOutputs.text(outputs);
    }
}

