/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigurableObject;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IPriorityHost;
import appeng.util.CustomNameUtil;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.class_1268;
import net.minecraft.class_129;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public abstract class AEBasePart
implements IPart,
IActionHost,
ICustomNameObject,
ISegmentedInventory {
    private final IManagedGridNode mainNode;
    private IPartItem<?> partItem;
    private class_2586 blockEntity = null;
    private IPartHost host = null;
    @Nullable
    private class_2350 side;
    @Nullable
    private class_2561 customName;

    public AEBasePart(IPartItem<?> partItem) {
        this.partItem = Objects.requireNonNull(partItem, "partItem");
        this.mainNode = this.createMainNode().setVisualRepresentation(AEItemKey.of(this.partItem)).setExposedOnSides(EnumSet.noneOf(class_2350.class));
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode(this, NodeListener.INSTANCE);
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
    }

    public final boolean isClientSide() {
        return this.blockEntity == null || this.blockEntity.method_10997() == null || this.blockEntity.method_10997().method_8608();
    }

    public IPartHost getHost() {
        return this.host;
    }

    protected AEColor getColor() {
        if (this.host == null) {
            return AEColor.TRANSPARENT;
        }
        return this.host.getColor();
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    @Override
    public IGridNode getActionableNode() {
        return this.mainNode.getNode();
    }

    public final class_2586 getBlockEntity() {
        return this.blockEntity;
    }

    public class_1937 getLevel() {
        return this.blockEntity.method_10997();
    }

    @Override
    public class_2561 getCustomInventoryName() {
        return Objects.requireNonNullElse(this.customName, class_2585.field_24366);
    }

    @Override
    public boolean hasCustomInventoryName() {
        return this.customName != null;
    }

    @Override
    public void addEntityCrashInfo(class_129 crashreportcategory) {
        crashreportcategory.method_578("Part Side", (Object)this.getSide());
        class_2586 beHost = this.getBlockEntity();
        if (beHost != null) {
            beHost.method_11003(crashreportcategory);
            class_1937 level = beHost.method_10997();
            if (level != null) {
                crashreportcategory.method_578("Level", (Object)level.method_27983());
            }
        }
    }

    @Override
    public IPartItem<?> getPartItem() {
        return this.partItem;
    }

    protected void setPartItem(IPartItem<?> partItem) {
        if (partItem != this.partItem) {
            this.partItem = Objects.requireNonNull(partItem);
            this.getMainNode().setVisualRepresentation(partItem);
        }
    }

    @Override
    public void readFromNBT(class_2487 data) {
        this.mainNode.loadFromNBT(data);
        if (data.method_10545("customName")) {
            try {
                this.customName = class_2561.class_2562.method_10877((String)data.method_10558("customName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeToNBT(class_2487 data) {
        this.mainNode.saveToNBT(data);
        if (this.customName != null) {
            data.method_10582("customName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
    }

    @Override
    public IGridNode getGridNode() {
        return this.mainNode.getNode();
    }

    @Override
    public void removeFromWorld() {
        this.mainNode.destroy();
    }

    @Override
    public void addToWorld() {
        this.mainNode.create(this.getLevel(), this.blockEntity.method_11016());
    }

    @Override
    public void setPartHostInfo(class_2350 side, IPartHost host, class_2586 blockEntity) {
        this.setSide(side);
        this.blockEntity = blockEntity;
        this.host = host;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 3.0f;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        this.customName = CustomNameUtil.getCustomName(input);
        AEBasePart aEBasePart = this;
        if (aEBasePart instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)((Object)aEBasePart);
            configurableObject.getConfigManager().readFromNBT(input);
        }
        if ((aEBasePart = this) instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)aEBasePart);
            pHost.setPriority(input.method_10550("priority"));
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void exportSettings(SettingsFrom mode, class_2487 output) {
        CustomNameUtil.setCustomName(output, this.customName);
        if (mode == SettingsFrom.MEMORY_CARD) {
            AEBasePart aEBasePart = this;
            if (aEBasePart instanceof IConfigurableObject) {
                IConfigurableObject configurableObject = (IConfigurableObject)((Object)aEBasePart);
                configurableObject.getConfigManager().writeToNBT(output);
            }
            if ((aEBasePart = this) instanceof IPriorityHost) {
                IPriorityHost pHost = (IPriorityHost)((Object)aEBasePart);
                output.method_10569("priority", pHost.getPriority());
            }
        }
    }

    public boolean useStandardMemoryCard() {
        return true;
    }

    private boolean useMemoryCard(class_1657 player) {
        class_1792 class_17922;
        class_1799 memCardIS = player.method_31548().method_7391();
        if (!memCardIS.method_7960() && this.useStandardMemoryCard() && (class_17922 = memCardIS.method_7909()) instanceof IMemoryCard) {
            IMemoryCard memoryCard = (IMemoryCard)class_17922;
            Object partItem = this.getPartItem().method_8389();
            if (AEParts.INTERFACE.method_8389() == partItem) {
                partItem = AEBlocks.INTERFACE.method_8389();
            } else if (AEParts.PATTERN_PROVIDER.method_8389() == partItem) {
                partItem = AEBlocks.PATTERN_PROVIDER.method_8389();
            }
            String name = partItem.method_7876();
            if (InteractionUtil.isInAlternateUseMode(player)) {
                class_2487 data = new class_2487();
                this.exportSettings(SettingsFrom.MEMORY_CARD, data);
                if (!data.method_33133()) {
                    memoryCard.setMemoryCardContents(memCardIS, name, data);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                }
            } else {
                String storedName = memoryCard.getSettingsName(memCardIS);
                class_2487 data = memoryCard.getData(memCardIS);
                if (name.equals(storedName)) {
                    this.importSettings(SettingsFrom.MEMORY_CARD, data, player);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                } else {
                    memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean onActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (this.useMemoryCard(player)) {
            return true;
        }
        return this.onPartActivate(player, hand, pos);
    }

    @Override
    public final boolean onShiftActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (this.useMemoryCard(player)) {
            return true;
        }
        return this.onPartShiftActivate(player, hand, pos);
    }

    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        return false;
    }

    public boolean onPartShiftActivate(class_1657 player, class_1268 hand, class_243 pos) {
        return false;
    }

    @Override
    public void onPlacement(class_1657 player) {
        this.mainNode.setOwningPlayer(player);
    }

    public class_2350 getSide() {
        return this.side;
    }

    private void setSide(class_2350 side) {
        this.side = side;
    }

    @Override
    @Nullable
    @OverridingMethodsMustInvokeSuper
    public InternalInventory getSubInventory(class_2960 id) {
        return null;
    }

    public static class NodeListener<T extends AEBasePart>
    implements IGridNodeListener<T> {
        public static final NodeListener<AEBasePart> INSTANCE = new NodeListener();

        @Override
        public void onSecurityBreak(T nodeOwner, IGridNode node) {
            if (((AEBasePart)nodeOwner).getHost().getPart(((AEBasePart)nodeOwner).getSide()) == nodeOwner) {
                ArrayList<class_1799> items = new ArrayList<class_1799>();
                nodeOwner.addPartDrop(items, false);
                nodeOwner.addAdditionalDrops(items, false);
                ((AEBasePart)nodeOwner).getHost().removePart(((AEBasePart)nodeOwner).getSide());
                if (!items.isEmpty()) {
                    class_2586 be = ((AEBasePart)nodeOwner).getHost().getBlockEntity();
                    Platform.spawnDrops(be.method_10997(), be.method_11016(), items);
                }
            }
        }

        @Override
        public void onSaveChanges(T nodeOwner, IGridNode node) {
            ((AEBasePart)nodeOwner).getHost().markForSave();
        }

        @Override
        public void onStateChanged(T nodeOwner, IGridNode node, IGridNodeListener.State state) {
            ((AEBasePart)nodeOwner).onMainNodeStateChanged(state);
        }
    }
}

