/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.networking.IGrid;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.menu.implementations.IOBusMenu;
import appeng.parts.automation.IOBusPart;
import appeng.parts.automation.StackTransferContextImpl;
import appeng.parts.automation.StackWorldBehaviors;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3917;

public class ImportBusPart
extends IOBusPart {
    private StackImportStrategy importStrategy;

    public ImportBusPart(IPartItem<?> partItem) {
        super(TickRates.ImportBus, partItem);
    }

    @Override
    protected boolean doBusWork(IGrid grid) {
        if (this.importStrategy == null) {
            class_2586 self = this.getHost().getBlockEntity();
            class_2338 fromPos = self.method_11016().method_10093(this.getSide());
            class_2350 fromSide = this.getSide().method_10153();
            this.importStrategy = StackWorldBehaviors.createImportFacade((class_3218)this.getLevel(), fromPos, fromSide);
        }
        StackTransferContextImpl context = new StackTransferContextImpl(grid.getStorageService(), grid.getEnergyService(), this.source, this.getOperationsPerTick(), this.getFilter());
        context.setInverted(this.isUpgradedWith(AEItems.INVERTER_CARD));
        this.importStrategy.transfer(context);
        return context.hasDoneWork();
    }

    @Override
    protected class_3917<?> getMenuType() {
        return IOBusMenu.IMPORT_TYPE;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

