/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.core.AELog;
import appeng.util.IVariantConversion;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

class StorageImportStrategy<V extends TransferVariant<?>>
implements StackImportStrategy {
    private final BlockApiCache<Storage<V>, class_2350> apiCache;
    private final class_2350 fromSide;
    private final IVariantConversion<V> conversion;

    public StorageImportStrategy(BlockApiLookup<Storage<V>, class_2350> apiLookup, IVariantConversion<V> conversion, class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        this.apiCache = BlockApiCache.create(apiLookup, (class_3218)level, (class_2338)fromPos);
        this.fromSide = fromSide;
        this.conversion = conversion;
    }

    @Override
    public boolean transfer(StackTransferContext context) {
        if (!context.isKeyTypeEnabled(this.conversion.getKeyType())) {
            return false;
        }
        Storage adjacentStorage = (Storage)this.apiCache.find((Object)this.fromSide);
        if (adjacentStorage == null) {
            return false;
        }
        long remainingTransferAmount = (long)context.getOperationsRemaining() * (long)this.conversion.getKeyType().getAmountPerOperation();
        IStorageService inv = context.getInternalStorage();
        try (Transaction tx = Transaction.openOuter();){
            Object extractable = null;
            long extractableAmount = 0L;
            for (StorageView view : adjacentStorage.iterable((TransactionContext)tx)) {
                long amountForThisResource;
                long amount;
                TransferVariant resource = (TransferVariant)view.getResource();
                AEKey resourceKey = this.conversion.getKey(resource);
                if (resourceKey == null || extractable != null && !extractable.equals(resourceKey) || context.isInFilter(resourceKey) == context.isInverted() || (amount = view.extract((Object)resource, amountForThisResource = inv.getInventory().insert(resourceKey, remainingTransferAmount, Actionable.SIMULATE, context.getActionSource()), (TransactionContext)tx)) <= 0L) continue;
                if (extractable != null) {
                    extractableAmount += amount;
                } else {
                    extractable = resourceKey;
                    extractableAmount += amount;
                }
                if ((remainingTransferAmount -= amount) > 0L) continue;
                break;
            }
            if (extractable == null) {
                boolean bl = false;
                return bl;
            }
            long inserted = inv.getInventory().insert((AEKey)extractable, extractableAmount, Actionable.MODULATE, context.getActionSource());
            if (inserted < extractableAmount) {
                long leftover = extractableAmount - inserted;
                if ((leftover -= adjacentStorage.insert(this.conversion.getVariant((AEKey)extractable), leftover, (TransactionContext)tx)) > 0L) {
                    AELog.warn("Extracted %dx%s from adjacent storage and voided it because network refused insert", leftover, extractable);
                }
            }
            long opsUsed = Math.max(1L, inserted / (long)this.conversion.getKeyType().getAmountPerOperation());
            context.reduceOperationsRemaining(opsUsed);
            tx.commit();
            boolean bl = true;
            return bl;
        }
    }

    public static StackImportStrategy createItem(class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        return new StorageImportStrategy<ItemVariant>(ItemStorage.SIDED, IVariantConversion.ITEM, level, fromPos, fromSide);
    }

    public static StackImportStrategy createFluid(class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        return new StorageImportStrategy<FluidVariant>(FluidStorage.SIDED, IVariantConversion.FLUID, level, fromPos, fromSide);
    }
}

