/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testworld;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.util.AEColor;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ColoredItemDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.items.parts.PartItem;
import appeng.server.testworld.BlockEntityCustomizer;
import appeng.server.testworld.BuildAction;
import appeng.server.testworld.CableBuilder;
import appeng.server.testworld.DriveBuilder;
import appeng.server.testworld.PartCustomizer;
import appeng.server.testworld.PlaceBlockState;
import appeng.server.testworld.PlacePart;
import appeng.server.testworld.PlotTestHelper;
import appeng.server.testworld.PostGridInitAction;
import appeng.server.testworld.SpawnEntityAction;
import appeng.server.testworld.Test;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2401;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_3611;

public interface PlotBuilder {
    public void addBuildAction(BuildAction var1);

    public class_3341 bb(String var1);

    public static String posToBb(class_2338 pos) {
        return pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260();
    }

    default public CableBuilder cable(class_2338 pos) {
        return this.cable(PlotBuilder.posToBb(pos));
    }

    default public CableBuilder cable(String bb) {
        return this.cable(bb, AEParts.GLASS_CABLE, AEColor.TRANSPARENT);
    }

    default public CableBuilder cable(String bb, ColoredItemDefinition<? extends IPartItem<?>> definition) {
        return this.cable(bb, definition, AEColor.TRANSPARENT);
    }

    default public CableBuilder cable(String bb, ColoredItemDefinition<? extends IPartItem<?>> definition, AEColor color) {
        return this.cable(bb, definition.item(color));
    }

    default public CableBuilder cable(String bb, IPartItem<?> what) {
        this.addBuildAction(new PlacePart(this.bb(bb), what, null));
        return new CableBuilder(this, bb);
    }

    default public CableBuilder denseCable(class_2338 pos) {
        return this.cable(PlotBuilder.posToBb(pos), (IPartItem)AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT));
    }

    default public void part(String bb, class_2350 side, ItemDefinition<? extends PartItem<?>> part) {
        this.addBuildAction(new PlacePart(this.bb(bb), (IPartItem)part.method_8389(), side));
    }

    default public void part(class_2338 pos, class_2350 side, ItemDefinition<? extends PartItem<?>> part) {
        this.part(PlotBuilder.posToBb(pos), side, part);
    }

    default public <T extends IPart> void part(class_2338 pos, class_2350 side, ItemDefinition<? extends PartItem<T>> part, Consumer<T> partCustomizer) {
        this.part(PlotBuilder.posToBb(pos), side, part, partCustomizer);
    }

    default public <T extends IPart> void part(String bb, class_2350 side, ItemDefinition<? extends PartItem<T>> part, Consumer<T> partCustomizer) {
        this.addBuildAction(new PlacePart(this.bb(bb), (IPartItem)part.method_8389(), side));
        this.addBuildAction(new PartCustomizer<T>(this.bb(bb), side, part, partCustomizer));
    }

    default public void creativeEnergyCell(class_2338 pos) {
        this.creativeEnergyCell(PlotBuilder.posToBb(pos));
    }

    default public void creativeEnergyCell(String bb) {
        this.block(bb, AEBlocks.CREATIVE_ENERGY_CELL);
    }

    default public class_2338 leverOn(class_2338 pos, class_2350 side) {
        class_2338 leverPos = pos.method_10093(side);
        class_2738 face = class_2738.field_12471;
        if (side == class_2350.field_11036) {
            face = class_2738.field_12473;
            side = class_2350.field_11034;
        } else if (side == class_2350.field_11033) {
            face = class_2738.field_12475;
            side = class_2350.field_11034;
        }
        class_2680 state = (class_2680)((class_2680)class_2246.field_10363.method_9564().method_11657((class_2769)class_2401.field_11007, (Comparable)face)).method_11657((class_2769)class_2401.field_11177, (Comparable)side);
        this.blockState(leverPos, state);
        return leverPos;
    }

    default public class_2338 buttonOn(class_2338 pos, class_2350 side) {
        class_2338 leverPos = pos.method_10093(side);
        class_2738 face = class_2738.field_12471;
        if (side == class_2350.field_11036) {
            face = class_2738.field_12473;
            side = class_2350.field_11034;
        } else if (side == class_2350.field_11033) {
            face = class_2738.field_12475;
            side = class_2350.field_11034;
        }
        class_2680 state = (class_2680)((class_2680)class_2246.field_23864.method_9564().method_11657((class_2769)class_2269.field_11007, (Comparable)face)).method_11657((class_2769)class_2269.field_11177, (Comparable)side);
        this.blockState(leverPos, state);
        return leverPos;
    }

    default public void block(class_2338 pos, BlockDefinition<?> block) {
        this.block(PlotBuilder.posToBb(pos), block);
    }

    default public void block(String bb, BlockDefinition<?> block) {
        this.blockState(bb, block.block().method_9564());
    }

    default public <T extends AEBaseBlockEntity> void blockEntity(class_2338 pos, BlockDefinition<? extends AEBaseEntityBlock<T>> block, Consumer<T> postProcessor) {
        this.blockEntity(PlotBuilder.posToBb(pos), block, postProcessor);
    }

    default public <T extends AEBaseBlockEntity> void blockEntity(String bb, BlockDefinition<? extends AEBaseEntityBlock<T>> block, Consumer<T> postProcessor) {
        this.blockState(bb, block.block().method_9564());
        class_2591<T> type = block.block().getBlockEntityType();
        this.addBuildAction(new BlockEntityCustomizer<T>(this.bb(bb), type, postProcessor));
    }

    default public void chest(class_2338 pos, class_1799 ... stacks) {
        this.chest(PlotBuilder.posToBb(pos), stacks);
    }

    default public void chest(String bb, class_1799 ... stacks) {
        this.block(bb, class_2246.field_10034);
        this.customizeBlockEntity(bb, class_2591.field_11914, (T chest) -> {
            for (int i = 0; i < stacks.length; ++i) {
                chest.method_5447(i, stacks[i]);
            }
        });
    }

    default public void filledHopper(String bb, class_2350 direction, class_1935 item) {
        class_1799 stack = new class_1799(item);
        stack.method_7939(stack.method_7914());
        this.filledHopper(bb, direction, stack);
    }

    default public void filledHopper(String bb, class_2350 direction, class_1799 stack) {
        this.blockState(bb, (class_2680)class_2246.field_10312.method_9564().method_11657((class_2769)class_2377.field_11129, (Comparable)direction));
        this.customizeBlockEntity(bb, class_2591.field_11888, (T hopper) -> {
            for (int i = 0; i < hopper.method_5439(); ++i) {
                hopper.method_5447(i, stack.method_7972());
            }
        });
    }

    default public void hopper(class_2338 pos, class_2350 direction, class_1799 ... stacks) {
        this.hopper(PlotBuilder.posToBb(pos), direction, stacks);
    }

    default public void hopper(String bb, class_2350 direction, class_1799 ... stacks) {
        this.blockState(bb, (class_2680)class_2246.field_10312.method_9564().method_11657((class_2769)class_2377.field_11129, (Comparable)direction));
        this.customizeBlockEntity(bb, class_2591.field_11888, (T hopper) -> {
            for (int i = 0; i < stacks.length; ++i) {
                hopper.method_5447(i, stacks[i]);
            }
        });
    }

    default public <T extends class_2586> void customizeBlockEntity(String bb, class_2591<T> type, Consumer<T> consumer) {
        this.addBuildAction(new BlockEntityCustomizer<T>(this.bb(bb), type, consumer));
    }

    default public <T extends class_2586> void customizeBlockEntity(class_2338 pos, class_2591<T> type, Consumer<T> consumer) {
        this.customizeBlockEntity(PlotBuilder.posToBb(pos), type, consumer);
    }

    default public void block(class_2338 pos, class_2248 block) {
        this.block(PlotBuilder.posToBb(pos), block);
    }

    default public void block(String bb, class_2248 block) {
        this.blockState(bb, block.method_9564());
    }

    default public void fluid(String bb, class_3611 fluid) {
        this.blockState(bb, fluid.method_15785().method_15759());
    }

    default public void blockState(class_2338 pos, class_2680 blockState) {
        this.blockState(PlotBuilder.posToBb(pos), blockState);
    }

    default public void blockState(String bb, class_2680 blockState) {
        this.addBuildAction(new PlaceBlockState(this.bb(bb), blockState));
    }

    public PlotBuilder transform(Function<class_3341, class_3341> var1);

    default public PlotBuilder offset(int x, int y, int z) {
        return this.transform(bb -> bb.method_19311(x, y, z));
    }

    default public PlotBuilder offset(class_2338 pos) {
        return this.offset(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    default public void afterGridInitAt(String bb, BiConsumer<IGrid, IGridNode> consumer) {
        this.addBuildAction(new PostGridInitAction(this.bb(bb), consumer, true));
    }

    default public void afterGridInitAt(class_2338 pos, BiConsumer<IGrid, IGridNode> consumer) {
        this.afterGridInitAt(PlotBuilder.posToBb(pos), consumer);
    }

    default public void afterGridExistsAt(String bb, BiConsumer<IGrid, IGridNode> consumer) {
        this.addBuildAction(new PostGridInitAction(this.bb(bb), consumer, false));
    }

    default public void afterGridExistsAt(class_2338 pos, BiConsumer<IGrid, IGridNode> consumer) {
        this.afterGridExistsAt(PlotBuilder.posToBb(pos), consumer);
    }

    default public void storageDrive(class_2338 pos) {
        this.blockEntity(PlotBuilder.posToBb(pos), AEBlocks.DRIVE, (T drive) -> {
            InternalInventory cells = drive.getInternalInventory();
            cells.addItems(AEItems.ITEM_CELL_64K.stack());
            cells.addItems(AEItems.FLUID_CELL_64K.stack());
        });
    }

    default public DriveBuilder drive(class_2338 pos) {
        ArrayList<class_1799> cells = new ArrayList<class_1799>(10);
        this.blockEntity(PlotBuilder.posToBb(pos), AEBlocks.DRIVE, (T drive) -> {
            InternalInventory cellInv = drive.getInternalInventory();
            for (class_1799 cell : cells) {
                cellInv.addItems(cell);
            }
        });
        return new DriveBuilder(cells);
    }

    public Test test(Consumer<PlotTestHelper> var1);

    default public void fencedEntity(class_2338 pos, class_1299<?> entity) {
        this.fencedEntity(pos, entity, e -> {});
    }

    default public void fencedEntity(class_2338 pos, class_1299<?> entity, Consumer<class_1297> postProcessor) {
        PlotBuilder subPlot = this.offset(pos.method_10263(), pos.method_10264(), pos.method_10260());
        subPlot.block("[-1,1] -1 [-1,1]", class_2246.field_10340);
        subPlot.block("[-1,1] 0 [-1,1]", class_2246.field_10252);
        subPlot.block("0 0 0", class_2246.field_10124);
        this.addBuildAction(new SpawnEntityAction(this.bb(PlotBuilder.posToBb(pos)), entity, postProcessor));
    }
}

